/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.item;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.ApplicationFrameActionList;
import com.appframework.utils.OS;
import com.novell.gw.ab.UnresolvedAddressException;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.item.SaveCallBack;
import com.novell.gw.jclient.application.controls.FoldersDialog;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.frames.compose.FrameCompose;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.impl.cache.FoldersCache;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.WorkinProgressFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class ActionSaveDraft
extends AppAction {
    private static Logger logger = Logger.getLogger(ActionSaveDraft.class);

    public ActionSaveDraft(ApplicationFrameActionList theAppActionList) {
        super((ActionList)theAppActionList, ActionKey.SAVE_DRAFT, StringResources.SAVE_DRAFT, ImageResources.ACTION_SAVE_DRAFT);
        this.setAccelerator(KeyStroke.getKeyStroke(83, OS.getMetaKey()));
        this.setEnabled(false);
    }

    protected void performAction(ActionEvent e) {
        this.doSaveDraft();
    }

    public boolean doSaveDraft() {
        FrameCompose frame = (FrameCompose)this.getActionList().getOwnerComponent();
        frame.getItemEdit().hideTFPopups();
        AbstractItem item = frame.getNewItem();
        String where = null;
        if (item.isDraft()) {
            where = item.getViewFolder(this.getUserGuid()).getNativeFolder().getFullPath();
        } else {
            AbstractFolder folder = FoldersCache.getFolder(WorkinProgressFolder.class, this.getUserGuid());
            FoldersDialog foldersDialog = new FoldersDialog(frame, folder, StringResources.SELECT_THE_FOLDER_YOU_WANR);
            foldersDialog.pack();
            foldersDialog.setLocationRelativeTo(null);
            foldersDialog.setVisible(true);
            if (foldersDialog.isOkActionProcessed()) {
                where = foldersDialog.getSelectedFolder().getNativeFolder().getFullPath();
            } else {
                return false;
            }
        }
        SaveCallBack callback = new SaveCallBack();
        try {
            if (item.isDraft()) {
                GWCommandManager.getInstance(this.getUserGuid()).saveDraft(item, where, callback);
            } else if (item.isSaved()) {
                GWCommandManager.getInstance(this.getUserGuid()).modifyItem(item, callback);
            } else {
                GWCommandManager.getInstance(this.getUserGuid()).saveDraft(item, where, callback);
            }
            frame.clearDirtyState();
        }
        catch (UnresolvedAddressException e1) {
            frame.setVisible(true);
            JOptionPane.showMessageDialog(frame, StringResources.SOME_ADDRESSES_ARE_UNDELIVERABLE, StringResources.UNDELIVERABLE_MESSAGE, 2);
        }
        catch (GWCommandException e1) {
            logger.error((Object)e1, (Throwable)e1);
            ErrorDialog.processGWException(e1, frame);
        }
        return true;
    }

    public boolean showWithText() {
        return false;
    }
}

