/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.item;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.ApplicationFrameActionList;
import com.appframework.components.ButtonList;
import com.appframework.event.AppEvent;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.item.AbstractMultipleItemsAction;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class ActionShowInChecklist
extends AbstractMultipleItemsAction {
    private ButtonList buttons;

    public ActionShowInChecklist(ApplicationFrameActionList theAppActionList) {
        super((ActionList)theAppActionList, ActionKey.SHOW_IN_CHECKLIST, StringResources.SHOW_IN_TASKLIST, ImageResources.SHOW_IN_TASKLIST);
        this.setType(AppAction.ActionType.CHECKABLE);
        this.buttons = new ButtonList(false);
    }

    protected void performAction(ActionEvent e) {
        if (this.hasItems()) {
            Boolean b;
            if (this.hasItemList()) {
                IItemList itemList = this.getItemList();
                b = !itemList.isSelectionInChecklist();
                itemList.showSelectionInChecklist(b);
            } else {
                b = !this.getItem().isInChecklist();
                this.getItem().showInChecklist(b);
            }
            this.setSelected(b);
        } else {
            JOptionPane.showMessageDialog(this.getActionList().getOwnerComponent(), StringResources.NO_ITEM_IS_SELECTED, StringResources.GROUPWISE_CLIENT, 2);
        }
    }

    public JMenuItem getMenuItem() {
        JMenuItem menuItem = super.getMenuItem();
        this.buttons.add(menuItem);
        return menuItem;
    }

    public JComponent getToolBarComponent() {
        JComponent component = super.getToolBarComponent();
        if (component instanceof AbstractButton) {
            this.buttons.add((AbstractButton)component);
        }
        return component;
    }

    protected void handle_OPEN_FOLDER(AppEvent theEvent) {
        super.handle_OPEN_FOLDER(theEvent);
        AbstractFolder folder = (AbstractFolder)theEvent.getData();
        assert (folder != null);
        if (folder.getDisplaySettings().getViewMode() != 8) {
            this.setEnabled(folder.getDisplaySettings().getViewMode() != 7);
        }
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        if (this.buttons != null) {
            this.buttons.setSelected(selected);
        }
    }

    public void setEnabled(boolean newValue) {
        super.setEnabled(newValue);
        if (this.buttons != null) {
            this.buttons.setEnabled(newValue);
        }
    }

    protected boolean checkEnableOnSelect() {
        boolean hasItemList = this.hasItemList();
        boolean result = false;
        boolean selected = false;
        if (this.hasItems()) {
            if (hasItemList) {
                IItemList itemList = this.getItemList();
                result = itemList.canShowSelectionInChecklist();
                selected = itemList.isSelectionInChecklist();
            } else {
                AbstractItem item = this.getItem();
                result = item.canShowInChecklist();
                selected = item.isInChecklist();
            }
        }
        this.setSelected(selected);
        return result;
    }
}

