/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.item;

import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.actions.item.AbstractReplyDialog;
import com.novell.gw.jclient.application.controls.RadioButtonGroup;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicRadioButton;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRadioButton;

public class ReplyPostingDialog
extends AbstractReplyDialog {
    private JRadioButton rbReplyToOriginal = new JMnemonicRadioButton(StringResources.REPLY_TO_ORIGINAL_DISCUSSION_TOPIC);
    private JRadioButton rbReplySubject = new JMnemonicRadioButton(StringResources.REPLY_TO_SELECTED_SUBJECT);
    private JRadioButton rbReplyPrivately = new JMnemonicRadioButton(StringResources.REPLY_PRIVATELY_OUTSIDE_DISCUSSION);
    private JRadioButton rbReplyToSender = new JMnemonicRadioButton(StringResources.TO_SENDER_ONLY);
    private JRadioButton rbReplyToAll = new JMnemonicRadioButton(StringResources.TO_ALL_SENDER_AND_RECIPIENTS);
    private IMessage originalMessage = null;

    public ReplyPostingDialog(JDialog parentDialog, IMessage originalMessage) {
        super(parentDialog);
        this.originalMessage = originalMessage;
        this.buildUI();
    }

    public ReplyPostingDialog(JFrame parentFrame, IMessage originalMessage) {
        super(parentFrame);
        this.originalMessage = originalMessage;
        this.buildUI();
        this.cbInculdeAttachments.setEnabled(originalMessage.hasPaperclipAttachments());
    }

    protected void buildUI() {
        super.buildUI();
        RadioButtonGroup buttonGroup = new RadioButtonGroup(this);
        ((ButtonGroup)buttonGroup).add(this.rbReplyToOriginal);
        ((ButtonGroup)buttonGroup).add(this.rbReplySubject);
        ((ButtonGroup)buttonGroup).add(this.rbReplyPrivately);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.anchor = 21;
        c.weightx = 1.0;
        this.pnlOptions.add((Component)this.rbReplyToOriginal, c);
        this.pnlOptions.add((Component)this.rbReplySubject, c);
        this.pnlOptions.add((Component)this.rbReplyPrivately, c);
        this.rbReplySubject.setSelected(true);
        buttonGroup = new RadioButtonGroup(this);
        ((ButtonGroup)buttonGroup).add(this.rbReplyToSender);
        ((ButtonGroup)buttonGroup).add(this.rbReplyToAll);
        c.insets.left = 15;
        this.pnlOptions.add((Component)this.rbReplyToSender, c);
        this.pnlOptions.add((Component)this.rbReplyToAll, c);
        this.init();
    }

    private void init() {
        this.rbReplyToSender.setSelected(true);
        this.rbReplyToOriginal.setEnabled(this.originalMessage != null && this.originalMessage.canReplyToOriginalTopic());
        this.rbReplyToSender.setEnabled(false);
        this.rbReplyToAll.setEnabled(false);
        this.rbReplyPrivately.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean b = e.getStateChange() == 1;
                ReplyPostingDialog.this.rbReplyToSender.setEnabled(b);
                ReplyPostingDialog.this.rbReplyToAll.setEnabled(b && !MessageUtils.isNntpMessageOrHeader(ReplyPostingDialog.this.originalMessage));
            }
        });
    }

    public int getResult() {
        int nntp = 0;
        if (MessageUtils.isNntpMessageOrHeader(this.originalMessage)) {
            nntp = 128;
        }
        if (this.rbReplyToOriginal.isSelected()) {
            return 0x100 | nntp;
        }
        if (this.rbReplySubject.isSelected()) {
            return 0x10 | nntp;
        }
        int privateFlag = 0;
        if (this.originalMessage.isDiscussionItem()) {
            privateFlag = 32;
        }
        if (this.rbReplyToSender.isSelected()) {
            return 33;
        }
        return 39;
    }
}

