/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.item;

import com.appframework.components.AbstractOKAction;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.BasicDialog;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;

public class RetractDialog
extends BasicDialog {
    private static Logger logger = Logger.getLogger(RetractDialog.class);
    public static final int MY_MAILBOX = 0;
    public static final int RECIPIENTS_MAILBOX = 1;
    public static final int ALL_MAILBOX = 2;
    public static final int ACTION_CANCELED = 3;
    private JPanel pnlCheckID;
    private JRadioButton rbMyMailBox;
    private JRadioButton rbRecipients;
    private JRadioButton rbAll;
    private JLabel lbRetract;
    private JTextArea taRetractComment;
    private OrientableButton btnOK;
    private OrientableButton btnCancel;
    private ButtonGroup buttonGroup;
    private int result = -1;

    private RetractDialog(Dialog parentDialog) {
        super(parentDialog);
        this.buildUI();
    }

    private RetractDialog(Frame parentFrame) {
        super(parentFrame);
        this.buildUI();
    }

    private RetractDialog() {
        this.buildUI();
    }

    private void buildUI() {
        this.setTitle(StringResources.DELETE_ITEM);
        this.pnlCheckID = new OrientablePanel();
        this.pnlCheckID.setLayout(new BoxLayout(this.pnlCheckID, 3));
        this.pnlCheckID.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ' ' + StringResources.DELETE_ITEM + ' '));
        CommentsEnabler commentsEnabler = new CommentsEnabler();
        this.rbMyMailBox = new JMnemonicRadioButton(new CommentsDisabler());
        this.rbRecipients = new OrientableRadioButton(commentsEnabler);
        UIUtils.setText(this.rbRecipients, StringResources.RECIPIENTS_MAILBOX);
        this.rbAll = new OrientableRadioButton(commentsEnabler);
        UIUtils.setText(this.rbAll, StringResources.ALL_MAILBOXES);
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.rbMyMailBox);
        this.buttonGroup.add(this.rbRecipients);
        this.buttonGroup.add(this.rbAll);
        this.rbMyMailBox.setSelected(true);
        this.lbRetract = new OrientableLabel(StringResources.RETRACT_COMMENT);
        this.taRetractComment = new GWTextArea(5, 20);
        this.setEnabledCommentArea(false);
        this.btnOK = new OrientableButton(new ButtonOKAction());
        this.btnCancel = new OrientableButton(new ButtonCancelAction());
        this.pnlCheckID.add(this.rbMyMailBox);
        this.pnlCheckID.add(this.rbRecipients);
        this.pnlCheckID.add(this.rbAll);
        OrientablePanel content = new OrientablePanel();
        content.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, -2, 3, -2);
        c.weightx = 1.0;
        c.gridwidth = 3;
        content.add((Component)this.pnlCheckID, c);
        c.anchor = 21;
        c.fill = 0;
        ++c.gridy;
        c.insets = new Insets(0, 1, 0, 0);
        content.add((Component)this.lbRetract, c);
        c.fill = 1;
        c.insets = new Insets(3, 0, 6, 0);
        c.weighty = 1.0;
        ++c.gridy;
        content.add((Component)new OrientableScrollPane(this.taRetractComment), c);
        c.fill = 2;
        c.gridwidth = 1;
        ++c.gridy;
        c.insets = new Insets(0, 0, 0, 3);
        c.weightx = 0.0;
        c.weighty = 0.0;
        content.add((Component)this.btnOK, c);
        c.gridx = 1;
        c.insets = new Insets(0, 0, 0, 0);
        content.add((Component)this.btnCancel, c);
        content.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add(content);
        this.setDefaultButton(this.btnOK);
        this.setCancelButton(this.btnCancel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                RetractDialog.this.result = 3;
            }
        });
    }

    private int getResultID() {
        if (this.result == -1) {
            this.result = this.rbMyMailBox.isSelected() ? 0 : (this.rbRecipients.isSelected() ? 1 : 2);
        }
        return this.result;
    }

    private String getRetractComment() {
        return this.taRetractComment.getText();
    }

    public static Result showDialog(Component parentComponent) {
        Window window = ControlsUtils.getWindowForComponent(parentComponent);
        RetractDialog dd = window instanceof Frame ? new RetractDialog((Frame)parentComponent) : (window instanceof Dialog ? new RetractDialog((Dialog)parentComponent) : new RetractDialog());
        dd.setModal(true);
        UIUtils.centerWindow((Window)dd, parentComponent);
        dd.pack();
        dd.setVisible(true);
        return new Result(dd.getResultID(), dd.getRetractComment());
    }

    private void setEnabledCommentArea(boolean b) {
        this.taRetractComment.setEnabled(b);
        this.taRetractComment.setBackground(b ? Color.WHITE : Color.GRAY.brighter());
    }

    private class CommentsDisabler
    extends AbstractAction {
        public CommentsDisabler() {
            super(StringResources.MY_MAILBOX);
        }

        public void actionPerformed(ActionEvent e) {
            RetractDialog.this.setEnabledCommentArea(false);
        }
    }

    private class CommentsEnabler
    extends AbstractAction {
        private CommentsEnabler() {
        }

        public void actionPerformed(ActionEvent e) {
            RetractDialog.this.setEnabledCommentArea(true);
        }
    }

    private class ButtonCancelAction
    extends AbstractAction {
        public ButtonCancelAction() {
            super(StringResources.CANCEL);
        }

        public void actionPerformed(ActionEvent e) {
            RetractDialog.this.result = 3;
            RetractDialog.this.setVisible(false);
        }
    }

    private class ButtonOKAction
    extends AbstractOKAction {
        private ButtonOKAction() {
        }

        public void actionPerformed(ActionEvent e) {
            RetractDialog.this.setVisible(false);
        }
    }

    public static class Result {
        private int resultID;
        private String comment = "";

        private Result(int theResultID, String theComment) {
            if (theResultID < 0 || theResultID > 3) {
                throw new IllegalArgumentException();
            }
            this.resultID = theResultID;
            this.comment = theComment;
        }

        public String getComment() {
            return this.comment;
        }

        public int getResultID() {
            return this.resultID;
        }
    }
}

