/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.send;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.ApplicationFrameActionList;
import com.appframework.utils.OS;
import com.novell.gw.ab.UnresolvedAddressException;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.send.SendCallbackImpl;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.frames.compose.FrameCompose;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class ActionPost
extends AppAction {
    private boolean modify = false;

    public ActionPost(ApplicationFrameActionList theAppActionList) {
        super((ActionList)theAppActionList, ActionKey.POST_ITEM, StringResources.POST, ImageResources.ACT_POST);
        KeyStroke keyStroke = OS.isMacOS() ? KeyStroke.getKeyStroke(68, OS.getMetaKey()) : KeyStroke.getKeyStroke(68, 512);
        this.setAccelerator(keyStroke);
    }

    protected void performAction(ActionEvent e) {
        FrameCompose frame = (FrameCompose)this.getActionList().getOwnerComponent();
        AbstractItem item = frame.getNewItem();
        try {
            SendCallbackImpl callback = new SendCallbackImpl(frame, (IMessage)item.getNativeItem());
            if (this.modify) {
                GWCommandManager.getInstance(this.getUserGuid()).modifyItem(item, callback);
            } else {
                GWCommandManager.getInstance(this.getUserGuid()).postItem(item, callback, frame.getFromDataStore());
            }
            if (!callback.isWasCalled()) {
                frame.setVisible(false);
            }
        }
        catch (UnresolvedAddressException e1) {
            frame.setVisible(true);
            JOptionPane.showMessageDialog(frame, StringResources.SOME_ADDRESSES_ARE_UNDELIVERABLE, StringResources.UNDELIVERABLE_MESSAGE, 2);
        }
        catch (GWCommandException e1) {
            frame.setVisible(true);
            ErrorDialog.processGWException(e1, this.getActionList().getOwnerComponent());
        }
    }

    public void setModify(boolean theModify) {
        this.modify = theModify;
    }
}

