/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.send;

import azcheck.ui.JSpellDialog;
import com.appframework.ActionList;
import com.appframework.ApplicationFrameActionList;
import com.appframework.components.htmleditor.HTMLTextPane;
import com.appframework.components.htmleditor.hyperlink.HTMLUtils;
import com.appframework.utils.OS;
import com.novell.gw.ab.UnresolvedAddressException;
import com.novell.gw.account.Account;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.actions.AbstractAddressBookAction;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.send.SendCallbackImpl;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.frames.compose.FrameCompose;
import com.novell.gw.jclient.application.frames.options.compose.send.SignatureAddPromtDialog;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.options.Signature;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class ActionSend
extends AbstractAddressBookAction {
    private static Logger logger = Logger.getLogger(ActionSend.class);
    private boolean disableSignature;

    public ActionSend(ApplicationFrameActionList theAppActionList) {
        super((ActionList)theAppActionList, ActionKey.SEND_ITEM, StringResources.ACTION_SEND, ImageResources.ICON_ACT_SEND);
        KeyStroke keyStroke = OS.isMacOS() ? KeyStroke.getKeyStroke(68, OS.getMetaKey()) : KeyStroke.getKeyStroke(68, 512);
        this.setAccelerator(keyStroke);
    }

    protected void performAction(ActionEvent e) {
        AbstractItem item;
        Account account;
        FrameCompose frame = (FrameCompose)this.getActionList().getOwnerComponent();
        frame.getItemEdit().hideTFPopups();
        if (frame.getRecipientList().isEmpty()) {
            JOptionPane.showMessageDialog(this.getActionList().getOwnerComponent(), StringResources.YOU_MUST_FILL_IN_THE_TO_C, StringResources.SEND, 0);
            return;
        }
        IDataStore dataStore = frame.getFromDataStore();
        boolean spellCheck = (Boolean)dataStore.getSettings().getCheckSpellingBeforeSend().getValue();
        if (spellCheck && !frame.isSpellCheckSuppressed()) {
            HTMLTextPane itemEditHTMLTextPane = frame.getItemEditHTMLTextPane();
            JTextField subject = frame.getSubject();
            try {
                String dictLanguage = OS.getDictLanguage();
                if (!JSpellDialog.check((JTextComponent)subject, (String)dictLanguage, (boolean)true)) {
                    JSpellDialog.check((JTextComponent)itemEditHTMLTextPane, (String)dictLanguage, (boolean)false);
                }
            }
            catch (Exception ex) {
                try {
                    if (!JSpellDialog.check((JTextComponent)subject, null, (boolean)true)) {
                        JSpellDialog.check((JTextComponent)itemEditHTMLTextPane, null, (boolean)false);
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
        }
        if ((account = (item = frame.getNewItem()).getNativeItem().getSendingAccount()) != null) {
            logger.debug((Object)("account name: " + account.getName()));
            logger.debug((Object)("account email address: " + account.getEmailAddress()));
            logger.debug((Object)("account user id: " + account.getUserId()));
        }
        logger.debug((Object)("datastore email address: " + dataStore.getUserFields().getEmailAddress()));
        logger.debug((Object)("datastore user id: " + dataStore.getUserId()));
        logger.debug((Object)("Conceal -  " + item.getNativeItem().getSendOptionConcealSubject()));
        int textLength = frame.getItemEditHTMLTextPane().getDocument().getLength();
        if (textLength == 0) {
            if (frame.getItemEdit().getMessageEditor().getMode() == 1) {
                item.getMessage().setHtmlText(HTMLUtils.getEmptyHTML());
            } else {
                item.getMessage().setRtfText("{\\rtf1\\ansi}");
            }
        }
        try {
            if (!this.addSignature(item, account)) {
                return;
            }
            SendCallbackImpl callback = new SendCallbackImpl(frame, (IMessage)item.getNativeItem());
            frame.stopTimer();
            GWCommandManager.getInstance(this.getUserGuid()).sendItem(item, account, dataStore, callback);
            if (!callback.isWasCalled()) {
                frame.setVisible(false);
            }
        }
        catch (UnresolvedAddressException e1) {
            frame.getItemEdit().setGWItemComposition(frame.getItemEdit().getGWItemComposition());
            frame.setVisible(true);
            frame.startTimer();
            JOptionPane.showMessageDialog(frame, StringResources.SOME_ADDRESSES_ARE_UNDELIVERABLE, StringResources.UNDELIVERABLE_MESSAGE, 2);
        }
        catch (GWCommandException e1) {
            EngineException ee;
            frame.getItemEdit().setGWItemComposition(frame.getItemEdit().getGWItemComposition());
            frame.setVisible(true);
            frame.startTimer();
            EngineException engineException = ee = e1.getCause() instanceof EngineException ? (EngineException)e1.getCause() : null;
            if (ee != null && ee.getErrorCode() == 55063) {
                String title = StringResources.GROUPWISE_ERROR + " [" + Integer.toHexString(ee.getErrorCode()).toUpperCase() + ']';
                JOptionPane.showMessageDialog(frame, ee.getMessage(), title, 2);
            }
            ErrorDialog.processGWException(e1, frame);
        }
    }

    private boolean addSignature(AbstractItem item, Account account) {
        Signature s = null;
        try {
            s = GWCommandManager.getInstance(this.getUserGuid()).getSignature(account);
        }
        catch (GWCommandException e) {
            e.printStackTrace();
        }
        if (s != null && (s.isUsedSignature() || s.isUsedCard()) && !this.disableSignature) {
            String vcardpath = "";
            String signature = "";
            boolean addSignature = false;
            boolean addVCard = false;
            if (s.isPromptOnAdd()) {
                SignatureAddPromtDialog.Result result = SignatureAddPromtDialog.showDialog(this.getActionList().getOwnerComponent(), account);
                if (result != null) {
                    if (result.getResultID() == 0) {
                        signature = result.getSignature();
                        vcardpath = result.getVCardPath();
                        addSignature = result.isAddSignature();
                        addVCard = result.isAddVCard();
                    } else if (result.getResultID() != 1 && result.getResultID() == 2) {
                        return false;
                    }
                }
            } else {
                signature = s.getSignatureText();
                vcardpath = s.getCardFileName();
                addSignature = true;
            }
            if (addSignature) {
                item.appendSignature(signature);
            }
            if (addVCard) {
                if (vcardpath.length() > 0) {
                    item.getNativeItem().addVCard(vcardpath);
                } else {
                    item.getNativeItem().addVCard(null);
                }
            }
        }
        return true;
    }

    public void setDisableSignature(boolean disableSignature) {
        this.disableSignature = disableSignature;
    }

    protected boolean checkAccess() {
        return true;
    }
}

