/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.view;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.components.ButtonList;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.view.AbstractViewAction;
import com.novell.gw.jclient.application.controls.itemlistview.ItemListView;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;

public abstract class ActionSetViewMode
extends AbstractViewAction {
    private ButtonList buttonList = new ButtonList();

    public ActionSetViewMode(ActionList theAppActionList, ActionKey aName, String aCaption) {
        super(theAppActionList, aName, aCaption);
        this.setType(AppAction.ActionType.RADIO);
    }

    public abstract int getViewMode();

    protected void performAction(ActionEvent e) {
        ItemListView itemListView = (ItemListView)this.getMVCModel();
        IFolder folder = this.getFolder();
        int viewMode = this.getViewMode();
        if (itemListView != null && viewMode != 8) {
            itemListView.getViewDisplaySettings().setViewMode(viewMode);
            itemListView.refresh();
        } else if (folder != null) {
            folder.getDisplaySettings().setViewMode(viewMode);
            this.getActionList().performAction(ActionKey.REFRESH);
        }
    }

    public JMenuItem getMenuItem() {
        JMenuItem menuItem = super.getMenuItem();
        this.buttonList.add(menuItem);
        return menuItem;
    }

    public JComponent getToolBarComponent() {
        JComponent component = super.getToolBarComponent();
        if (component instanceof AbstractButton) {
            this.buttonList.add((AbstractButton)component);
        }
        return component;
    }

    protected boolean isContacts() {
        ItemListView itemListView = (ItemListView)this.getMVCModel();
        IFolder folder = this.getFolder();
        if (itemListView != null && !itemListView.isDead()) {
            return itemListView.getFolder().isContactsFolder();
        }
        if (folder != null) {
            return folder.isContactsFolder();
        }
        return false;
    }

    protected void registerListeners() {
        super.registerListeners();
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 1090, new FOLDER_OPENED_Listener()));
    }

    protected void updateViewMode() {
        int viewMode;
        ItemListView itemListView = (ItemListView)this.getMVCModel();
        IFolder folder = this.getFolder();
        if (itemListView != null) {
            viewMode = itemListView.getViewDisplaySettings().getViewMode();
        } else if (folder != null) {
            viewMode = folder.getDisplaySettings().getViewMode();
        } else {
            return;
        }
        if (viewMode == 9) {
            viewMode = 1;
        }
        this.setSelected(viewMode == this.getViewMode());
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.buttonList.setSelected(selected);
    }

    public void setMVCModel(ItemListView theModel) {
        super.setMVCModel(theModel);
        this.updateViewMode();
    }

    protected class FOLDER_OPENED_Listener
    extends AppEventListener {
        protected FOLDER_OPENED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            AbstractFolder folder = (AbstractFolder)theEvent.getData();
            ActionSetViewMode.this.setFolder(folder == null ? null : folder.getNativeFolder());
            ActionSetViewMode.this.updateViewMode();
        }
    }
}

