/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls;

import com.appframework.ApplicationFrame;
import com.appframework.drag.DragManager;
import com.appframework.mvc.MVCController;
import com.novell.gw.engine.TransferItems;
import com.novell.gw.jclient.api.interfaces.message.INote;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.dialogs.ChangeToManageDialog;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.impl.dnd.GWFlavors;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.exceptions.GWException;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.DocumentFolder;
import com.novell.gw.jclient.bl.om.folders.QueryFolder;
import com.novell.gw.jclient.bl.om.folders.SentItemsFolder;
import com.novell.gw.jclient.bl.om.folders.UserFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.store.GWItemSerializer;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DnDUtils {
    public static final String LINUX_URL_DELIMITER = "\r\n";
    private static Logger logger = Logger.getLogger(DnDUtils.class);
    private static final Set<Class> NON_DROPABLE_FOLDER_TYPES = new HashSet<Class>(5);

    public static String getUrlFromFileList(List fileList) {
        int nSize = fileList.size();
        StringBuilder result = new StringBuilder(nSize * 80);
        for (int i = 0; i < nSize; ++i) {
            File file = (File)fileList.get(i);
            try {
                result.append(file.toURL().toString());
                result.append(LINUX_URL_DELIMITER);
                continue;
            }
            catch (MalformedURLException e) {
                logger.error((Object)e);
            }
        }
        return result.toString();
    }

    private static String getFileNameFromSubject(String subject) {
        if (subject.length() == 0) {
            subject = "Untitled Mail";
        } else {
            int brokenDash = 8211;
            subject = subject.replace('\u2013', '-');
            subject = subject.replaceAll(":", "_");
            subject = subject.replaceAll("/", "_");
        }
        return subject;
    }

    public static String saveItem(AbstractItem item) {
        String itemLocalDir = ControlsUtils.getItemLocalDir(item.getID()).getAbsolutePath();
        String fileName = DnDUtils.getFileNameFromSubject(item.getSubject());
        File file = new File(itemLocalDir = itemLocalDir + File.separator + fileName + '.' + "eml");
        if (!file.exists()) {
            try {
                GWItemSerializer.saveAs(itemLocalDir, "eml", item, false, true);
            }
            catch (GWException e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
            }
        }
        return itemLocalDir;
    }

    public static boolean isDropOnFolderAllowed(AbstractFolder targetFolder, Transferable transferable, MVCController controller) {
        block9: {
            if (targetFolder == null || transferable == null || controller == null) {
                throw new IllegalArgumentException();
            }
            if (NON_DROPABLE_FOLDER_TYPES.contains(targetFolder.getClass())) {
                return false;
            }
            try {
                if (transferable.isDataFlavorSupported(GWFlavors.transferItemsFlavor) && transferable.isDataFlavorSupported(GWFlavors.userGuidFlavor)) {
                    TransferItems transferItems = (TransferItems)transferable.getTransferData(GWFlavors.transferItemsFlavor);
                    int transferOptions = targetFolder.getNativeFolder().getTransferOptions(transferItems, false, false);
                    List<Integer> transferActions = DnDUtils.getTransferActions(transferOptions);
                    String userGuid = ControlsUtils.getUserGuid(controller);
                    if (transferActions.isEmpty() || transferActions.contains(0)) {
                        return false;
                    }
                    if (!DnDUtils.isSameUserGuid(transferable, userGuid)) {
                        return false;
                    }
                    if (targetFolder instanceof UserFolder) {
                        return transferable.isDataFlavorSupported(GWFlavors.foldersOnlyFlavor);
                    }
                    break block9;
                }
                return false;
            }
            catch (UnsupportedFlavorException e) {
                logger.error((Object)e);
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
        return true;
    }

    public static boolean isTransferFromDifferentFolder(AbstractFolder targetFolder, Transferable transferable) {
        if (targetFolder == null || transferable == null) {
            throw new IllegalArgumentException();
        }
        if (transferable.isDataFlavorSupported(GWFlavors.parentFolderFlavor)) {
            try {
                String transferSourceFolderId = (String)transferable.getTransferData(GWFlavors.parentFolderFlavor);
                return !targetFolder.getID().equals(transferSourceFolderId);
            }
            catch (UnsupportedFlavorException e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
            }
        }
        return true;
    }

    public static boolean performTransferToFolder(DropTargetDropEvent event, AbstractFolder targetFolder, MVCController controller) {
        if (event == null || targetFolder == null || controller == null) {
            throw new IllegalArgumentException();
        }
        boolean transferSucceeded = false;
        Transferable data = event.getTransferable();
        try {
            String transferFolderID;
            int action;
            TransferItems transferItems = (TransferItems)data.getTransferData(GWFlavors.transferItemsFlavor);
            if (transferItems == null) {
                return false;
            }
            List<Integer> transferActions = DnDUtils.getTransferActions(targetFolder.getTransferOptions(transferItems));
            String userGuid = ControlsUtils.getUserGuid(controller);
            if (event.getDropAction() == 1) {
                action = 8192;
                logger.debug((Object)"ACTION_LINK_TO_FOLDER");
            } else {
                action = 4;
                logger.debug((Object)"ACTION_MOVE_INTO_FOLDER");
            }
            if ("Trash".equals(targetFolder.getType())) {
                action = 16;
                logger.debug((Object)"ACTION_DELETE_AND_EMPTY_ITEMS");
            }
            boolean processChangeTo = true;
            if (data.isDataFlavorSupported(GWFlavors.folderFlavor) && (transferFolderID = (String)data.getTransferData(GWFlavors.folderFlavor)) != null) {
                AbstractFolder transferFolder = EngineCommandManager.getInstance(userGuid).getFolder(transferFolderID);
                logger.debug((Object)("transferFolder: " + transferFolder.getName()));
                logger.debug((Object)("targetFolder: " + targetFolder.getName()));
                if (transferFolder.getNativeFolder().isCalendarChildFolder() && data.isDataFlavorSupported(GWFlavors.foldersOnlyFlavor)) {
                    if (!targetFolder.getNativeFolder().isCalendarChildFolder() && targetFolder.getNativeFolder().isCalendarFolder()) {
                        action = 4;
                        logger.debug((Object)"ACTION_MOVE_INTO_FOLDER");
                    } else if (targetFolder.equals(DnDUtils.getRootFolder(userGuid))) {
                        action = 4;
                        logger.debug((Object)"ACTION_MOVE_INTO_FOLDER");
                    } else {
                        action = 2;
                        logger.debug((Object)"ACTION_MOVE_FOLDER_BELOW_FOLDER");
                    }
                }
                if (targetFolder.isCalendarFolder() && transferFolder.isCalendarFolder()) {
                    processChangeTo = false;
                }
            }
            AbstractItem abstractItem = DragManager.getInstance().getItem();
            if (transferActions.contains(16384) && processChangeTo && abstractItem != null && !(abstractItem.getNativeItem() instanceof INote)) {
                ApplicationFrame frame = (ApplicationFrame)SwingUtilities.getWindowAncestor((Component)controller.getMVCView());
                ChangeToManageDialog changeToManageDialog = new ChangeToManageDialog(abstractItem, frame, controller);
                changeToManageDialog.setDenyChangeToMail();
                changeToManageDialog.setVisible(true);
                return true;
            }
            if (targetFolder instanceof UserFolder && transferActions.contains(32)) {
                action = 32;
            }
            logger.debug((Object)("action: " + action));
            transferSucceeded = targetFolder.getNativeFolder().transfer(transferItems, action, false, false);
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return transferSucceeded;
    }

    private static AbstractFolder getRootFolder(String userGuid) {
        AbstractFolder rootFolder;
        try {
            rootFolder = GWCommandManager.getInstance(userGuid).getRootFolder();
        }
        catch (GWCommandException e) {
            logger.error((Object)"GWCommandException caught > rethrowing");
            throw new RuntimeException(e);
        }
        return rootFolder;
    }

    public static boolean isSameUserGuid(Transferable transferable, String userGuid) {
        if (transferable.isDataFlavorSupported(GWFlavors.userGuidFlavor)) {
            try {
                return userGuid.equals(transferable.getTransferData(GWFlavors.userGuidFlavor));
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public static List<Integer> getTransferActions(int transferOptions) {
        ArrayList<Integer> integers = new ArrayList<Integer>();
        int mask = 32768;
        if (transferOptions == 0) {
            integers.add(0);
            logger.debug((Object)"ACTION_NONE");
        }
        do {
            if (transferOptions / mask != 1) continue;
            integers.add(mask);
            transferOptions -= mask;
        } while ((mask /= 2) != 0);
        logger.debug(integers);
        if (integers.contains(16384)) {
            logger.debug((Object)"ACTION_CHANGE_TO_CALENDAR");
        }
        if (integers.contains(16)) {
            logger.debug((Object)"ACTION_DELETE_AND_EMPTY_ITEMS");
        }
        if (integers.contains(512)) {
            logger.debug((Object)"ACTION_DELETE_AUTO_DATE");
        }
        if (integers.contains(4096)) {
            logger.debug((Object)"ACTION_DELETE_DOCUMENT");
        }
        if (integers.contains(2048)) {
            logger.debug((Object)"ACTION_DELETE_DOCUMENT_REFERENCE");
        }
        if (integers.contains(32768)) {
            logger.debug((Object)"ACTION_DELETE_DOCUMENT_VERSION");
        }
        if (integers.contains(64)) {
            logger.debug((Object)"ACTION_DELETE_FOLDERS_AND_ITEMS");
        }
        if (integers.contains(-2147483392)) {
            logger.debug((Object)"ACTION_DELETE_FROM_ALL_CALENDARS");
        }
        if (integers.contains(-2147482624)) {
            logger.debug((Object)"ACTION_DELETE_FROM_ALL_MAILBOXES");
        }
        if (integers.contains(256)) {
            logger.debug((Object)"ACTION_DELETE_FROM_CALENDAR");
        }
        if (integers.contains(1024)) {
            logger.debug((Object)"ACTION_DELETE_FROM_MAILBOX");
        }
        if (integers.contains(0x40000100)) {
            logger.debug((Object)"ACTION_DELETE_FROM_RECIPIENT_CALENDAR");
        }
        if (integers.contains(0x40000400)) {
            logger.debug((Object)"ACTION_DELETE_FROM_RECIPIENTS_MAILBOX");
        }
        if (integers.contains(8)) {
            logger.debug((Object)"ACTION_DELETE_ITEMS");
        }
        if (integers.contains(128)) {
            logger.debug((Object)"ACTION_DELETE_ITEMS_ONLY");
        }
        if (integers.contains(8192)) {
            logger.debug((Object)"ACTION_LINK_TO_FOLDER");
        }
        if (integers.contains(1)) {
            logger.debug((Object)"ACTION_MOVE_FOLDER_ABOVE_FOLDER");
        }
        if (integers.contains(2)) {
            logger.debug((Object)"ACTION_MOVE_FOLDER_BELOW_FOLDER");
        }
        if (integers.contains(4)) {
            logger.debug((Object)"ACTION_MOVE_INTO");
        }
        if (integers.contains(4)) {
            logger.debug((Object)"ACTION_MOVE_INTO_FOLDER");
        }
        if (integers.contains(32)) {
            logger.debug((Object)"ACTION_UNDELETE_ITEMS");
        }
        return integers;
    }

    static {
        NON_DROPABLE_FOLDER_TYPES.add(SentItemsFolder.class);
        NON_DROPABLE_FOLDER_TYPES.add(QueryFolder.class);
        NON_DROPABLE_FOLDER_TYPES.add(DocumentFolder.class);
    }
}

