/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls;

import com.appframework.components.customizedbutton.EtchedSeparator;
import com.novell.gw.jclient.application.controls.ExtraPopup;
import com.novell.gw.jclient.application.controls.MenuSelectionList;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.Logger;

public class ExtraPopupImpl
implements ExtraPopup {
    private static Logger logger = Logger.getLogger(ExtraPopupImpl.class);
    private Popup popup;
    private JPopupMenu parentMenu;
    private JComponent content;
    private Action separator = new SeparatorAction();
    private List<Action> actionList = new ArrayList<Action>();

    public ExtraPopupImpl(JPopupMenu thePopupMenu) {
        if (thePopupMenu == null) {
            throw new NullPointerException();
        }
        this.parentMenu = thePopupMenu;
        this.parentMenu.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ExtraPopupImpl.this.hide();
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
                ExtraPopupImpl.this.hide();
            }
        });
    }

    public void show(int x, int y) {
        if (this.popup != null) {
            this.popup.hide();
        }
        this.build();
        int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        int width = this.content.getPreferredSize().width;
        if (screenWidth - (x += this.parentMenu.getLocationOnScreen().x) <= width) {
            x = screenWidth - width;
        }
        this.popup = PopupFactory.getSharedInstance().getPopup(this.parentMenu, this.content, x, this.parentMenu.getLocationOnScreen().y + y);
        this.popup.show();
    }

    public void hide() {
        if (this.popup != null) {
            this.popup.hide();
        }
    }

    private void build() {
        OrientableList list = new OrientableList();
        int nSize = this.actionList.size();
        Action[] names = new Action[nSize];
        for (int i = 0; i < nSize; ++i) {
            names[i] = this.actionList.get(i);
        }
        list.setBorder(BorderFactory.createLineBorder(Color.RED));
        list.setListData(names);
        list.setCellRenderer(new ListRenderer());
        list.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ExtraPopupImpl.this.performAction(e);
            }
        });
        this.content = new MenuSelectionList(list);
        this.content.setBorder(BorderFactory.createLineBorder(Color.RED));
        Border lineBorder = (Border)UIManager.getDefaults().get("PopupMenu.border");
        this.content.setBorder(lineBorder);
    }

    private void performAction(MouseEvent e) {
        int index = ((JList)e.getSource()).locationToIndex(e.getPoint());
        this.hide();
        this.actionList.get(index).actionPerformed(null);
    }

    public void add(Action theAction) {
        if (theAction == null) {
            throw new NullPointerException();
        }
        this.actionList.add(theAction);
    }

    public void addSeparator() {
        this.actionList.add(this.separator);
    }

    private class CustomLabel
    extends OrientableLabel {
        private boolean paintLines;

        private CustomLabel() {
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (this.paintLines) {
                Color color = (Color)UIManager.getDefaults().get("MenuItem.selectionBackground");
                if (color != null) {
                    g.setColor(color.darker());
                }
                g.drawLine(0, 0, this.getSize().width, 0);
                if (color != null) {
                    g.setColor(color.brighter());
                }
                g.drawLine(0, this.getSize().height - 1, this.getSize().width, this.getSize().height - 1);
            }
        }

        public void setPaintLines(boolean b) {
            this.paintLines = b;
        }
    }

    private static class SeparatorAction
    extends AbstractAction {
        private SeparatorAction() {
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    private class ListRenderer
    implements ListCellRenderer {
        CustomLabel lbContent;

        public ListRenderer() {
            this.lbContent = new CustomLabel();
            this.lbContent.setOpaque(true);
            this.lbContent.setBorder(BorderFactory.createEmptyBorder(2, 8, 2, 8));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.lbContent.setPaintLines(isSelected);
            this.lbContent.setText((String)((Action)value).getValue("Name"));
            if (value instanceof SeparatorAction) {
                EtchedSeparator pnlSeparator = new EtchedSeparator();
                pnlSeparator.setPreferredSize(new Dimension(2, 2));
                return pnlSeparator;
            }
            if (isSelected) {
                this.lbContent.setBackground((Color)UIManager.getDefaults().get("MenuItem.selectionBackground"));
                this.lbContent.setForeground((Color)UIManager.getDefaults().get("MenuItem.selectionForeground"));
            } else {
                this.lbContent.setBackground((Color)UIManager.getDefaults().get("MenuItem.background"));
                this.lbContent.setForeground((Color)UIManager.getDefaults().get("MenuItem.foreground"));
            }
            return this.lbContent;
        }
    }
}

