/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls;

import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import java.awt.Dimension;
import java.awt.LayoutManager;
import org.apache.log4j.Logger;

public class MinimumSizeKeepingPanel
extends OrientablePanel {
    private static Logger logger = Logger.getLogger(MinimumSizeKeepingPanel.class);
    public static final int UNSET = -1;
    private int minimalHeight = -1;
    private int minimalWidth = -1;

    public MinimumSizeKeepingPanel() {
    }

    public MinimumSizeKeepingPanel(LayoutManager layout) {
        super(layout);
    }

    public MinimumSizeKeepingPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public int getMinimalHeight() {
        return this.minimalHeight;
    }

    public void setMinimalHeight(int minimalHeight) {
        if (minimalHeight < -1) {
            throw new IllegalArgumentException("illegal minimalHeight value: " + minimalHeight);
        }
        logger.debug((Object)("setting minimal height: " + minimalHeight));
        this.minimalHeight = minimalHeight;
    }

    public int getMinimalWidth() {
        return this.minimalWidth;
    }

    public void setMinimalWidth(int minimalWidth) {
        if (minimalWidth < -1) {
            throw new IllegalArgumentException("illegal minimalWidth value: " + minimalWidth);
        }
        logger.debug((Object)("setting minimal width: " + minimalWidth));
        this.minimalWidth = minimalWidth;
    }

    public boolean isMinimalHeightSet() {
        return this.minimalHeight != -1;
    }

    public boolean isMinimalWidthSet() {
        return this.minimalWidth != -1;
    }

    public Dimension getMinimumSize() {
        return this.checkSize(super.getMinimumSize());
    }

    public Dimension getMaximumSize() {
        return this.checkSize(super.getMaximumSize());
    }

    public Dimension getPreferredSize() {
        return this.checkSize(super.getPreferredSize());
    }

    private Dimension checkSize(Dimension size) {
        int height = size.height;
        int width = size.width;
        if (this.isMinimalHeightSet() && height < this.minimalHeight) {
            height = this.minimalHeight;
        }
        if (this.isMinimalWidthSet() && width < this.minimalWidth) {
            width = this.minimalWidth;
        }
        if (height != size.height || width != size.width) {
            size = new Dimension(width, height);
        }
        return size;
    }
}

