/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook;

import com.appframework.ActionList;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.api.interfaces.ab.IGroupContact;
import com.novell.gw.jclient.api.interfaces.ab.IOrganizationContact;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.api.interfaces.ab.IResourceContact;
import com.novell.gw.jclient.api.interfaces.ab.IUserContact;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.GWMainAppFrameActionList;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import com.novell.gw.jclient.bl.om.directory.PersonalAddressBook;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.ContactsFolder;
import java.awt.Component;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ABUtils {
    private static Logger logger = Logger.getLogger(ABUtils.class);

    private ABUtils() {
    }

    public static void copyContacts(AbstractAddressBook addressBook, List<IContact> contacts, Component parentComponent) {
        int nSize = contacts.size();
        for (int i = 0; i < nSize; ++i) {
            IContact contact = contacts.get(i);
            try {
                ((PersonalAddressBook)addressBook).copyContact(contact);
                continue;
            }
            catch (EngineException e1) {
                if (e1.getErrorCode() == 59154 || e1.getErrorCode() == 59142) {
                    String errPrompt;
                    String string = errPrompt = contact instanceof IGroupContact ? StringResources.A_GROUP_WITH_THE_SAME_NAME : StringResources.AN_ENTRY_WITH_THE_SAME_NAME;
                    if (0 != JOptionPane.showConfirmDialog(parentComponent, errPrompt, StringResources.ADDRESS_BOOK_K_QUESTION, 0)) continue;
                    try {
                        int dupAction = contact instanceof IGroupContact ? 2 : 1;
                        ((PersonalAddressBook)addressBook).copyContact(contact, dupAction);
                    }
                    catch (EngineException e2) {
                        logger.error((Object)e1);
                        logger.debug((Object)e1, (Throwable)e1);
                    }
                    continue;
                }
                logger.error((Object)e1);
                logger.debug((Object)e1, (Throwable)e1);
            }
        }
    }

    public static boolean isSystemABAbstractFolder(AbstractFolder folder) {
        AbstractAddressBook ab;
        boolean isSystem = false;
        if (folder instanceof ContactsFolder && (ab = ((ContactsFolder)folder).getAddressBook(EngineCommandManager.getAddressBookManager())) != null) {
            isSystem = ab.isSystemAddressBook();
        }
        return isSystem;
    }

    public static boolean isSystemABAbstractFolder(ActionList actionList) {
        if (actionList instanceof GWMainAppFrameActionList) {
            AbstractFolder folder = ((GWMainAppFrame)((GWMainAppFrameActionList)actionList).getMVCView()).getFolder();
            return ABUtils.isSystemABAbstractFolder(folder);
        }
        return false;
    }

    public static ImageIcon getIcon(IAddressable addressable) {
        if (addressable instanceof IGroupContact) {
            return ImageResources.GROUP_TABLE_ITEM;
        }
        if (addressable instanceof IOrganizationContact) {
            return ImageResources.ORGANIZATION_TABLE_ITEM;
        }
        if (addressable instanceof IResourceContact) {
            return ImageResources.RESOURCE_TABLE_ITEM;
        }
        if (addressable instanceof IUserContact) {
            return ImageResources.CONTACT_TABLE_ITEM;
        }
        return ImageResources.CONTACT_TABLE_ITEM;
    }

    public static String getRecipientID(IRecipient theRecipient) {
        String id = theRecipient.getAddressable().getGuid();
        if (id == null || id.length() == 0) {
            id = theRecipient.getAddressable().getEmailAddress();
        }
        return id;
    }
}

