/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook;

import com.appframework.ActionList;
import com.appframework.mvc.LocalCommand;
import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.api.enums.RecipientCopyType;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.ColoredScrollPane;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.WrappedNativeListCellRenderer;
import com.novell.gw.jclient.application.controls.addressbook.AddressSelectorDialogActionList;
import com.novell.gw.jclient.application.controls.addressbook.list.RecipientsList;
import com.novell.gw.jclient.application.controls.addressbook.table.AbstractAddressBookTable;
import com.novell.gw.jclient.application.controls.filter.ComponentWithMenu;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButtonMenuItem;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.skinnable.SkinnableLabel;
import com.novell.gw.jclient.application.controls.skinnable.SkinnablePanel;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBar;
import com.novell.gw.jclient.application.dialogs.SaveableApplicationDialog;
import com.novell.gw.jclient.application.frames.addressbook.FilterOffAction;
import com.novell.gw.jclient.application.frames.addressbook.GroupFilterAction;
import com.novell.gw.jclient.application.frames.addressbook.OrganizationFilterAction;
import com.novell.gw.jclient.application.frames.addressbook.ResourceFilterAction;
import com.novell.gw.jclient.application.frames.addressbook.UserFilterAction;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import com.novell.gw.jclient.bl.om.options.GeneralOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.apache.log4j.Logger;

public abstract class AbstractAddressSelectorDialog
extends SaveableApplicationDialog {
    public static final int BUTTON_HEIGHT = 23;
    private static Logger logger = Logger.getLogger(AbstractAddressSelectorDialog.class);
    JTextField tfSearch = new GWTextField();
    JComboBox cbSearch;
    JComboBox cbDirectories = new OrientableComboBox();
    private JLabel lbFilter = new OrientableLabel(ImageResources.ICON_UNACTIVE_FILTER);
    RecipientsList listRecipients;
    AbstractAddressBookTable tableAddressList;
    AbstractAddressBook directory;
    JPanel pnlSaveGroup = new OrientablePanel(new FlowLayout(3));
    private JComponent btnSaveGroup;
    protected JPanel pnlRight = new OrientablePanel(new BorderLayout());
    private static AbstractAddressSelectorDialog lastInstance;

    AbstractAddressSelectorDialog(JFrame theFrame, MVCController theParentController) {
        super((Frame)theFrame, theParentController);
        lastInstance = this;
        MessageUtils.showBusyCursor(theFrame, true);
        this.init();
        MessageUtils.showBusyCursor(theFrame, false);
        this.setLocationRelativeTo(this.getParent());
    }

    AbstractAddressSelectorDialog(JDialog theDialog, MVCController theParentController) {
        super((Dialog)theDialog, theParentController);
        lastInstance = this;
        this.init();
        this.setLocationRelativeTo(this.getParent());
    }

    public static AbstractAddressSelectorDialog getLastInstance() {
        return lastInstance;
    }

    protected AddressSelectorDialogActionList createController(MVCController parentController) {
        return new AddressSelectorDialogActionList(this, parentController);
    }

    void init() {
        this.setTitle(StringResources.ADDRESS_SELECTOR);
        ActionList actionList = ((MVCController)this.getController()).getActionList();
        this.btnSaveGroup = ControlsUtils.setToSkinlessComponent(actionList.getAction(ActionKey.SAVE_GROUP).getToolBarComponent());
        actionList.getAction(ActionKey.MOVE_TO_RECIPIENTS_LIST).setMVCModel(RecipientCopyType.getTo());
        this.tfSearch.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    if (AbstractAddressSelectorDialog.this.tfSearch.getDocument().getLength() == 0) {
                        AbstractAddressSelectorDialog.this.processOkAction(null);
                    } else {
                        AbstractAddressSelectorDialog dialog = AbstractAddressSelectorDialog.this;
                        ((MVCController)dialog.getController()).getActionList().performAction(ActionKey.MOVE_TO_RECIPIENTS_LIST);
                        dialog.tfSearch.setText("");
                    }
                }
            }
        });
        actionList.addAction(new FilterOffAction(actionList, this.tableAddressList));
        actionList.addAction(new GroupFilterAction(actionList, this.tableAddressList));
        actionList.addAction(new OrganizationFilterAction(actionList, this.tableAddressList));
        actionList.addAction(new ResourceFilterAction(actionList, this.tableAddressList));
        actionList.addAction(new UserFilterAction(actionList, this.tableAddressList));
        this.buildUI();
        this.setData();
    }

    protected abstract JPanel buildToggleButtons();

    void buildUI() {
        this.cbDirectories.addItemListener(new DirectoriesItemListener());
        this.cbDirectories.setRenderer(new DirectoriesRenderer(this.cbDirectories.getRenderer()));
        this.cbSearch = new OrientableComboBox(new String[]{StringResources.NAME});
        this.cbSearch.setEnabled(false);
        this.cbSearch.setPreferredSize(new Dimension((int)this.cbSearch.getPreferredSize().getWidth(), 23));
        JPanel pnlContent = (JPanel)this.getContentPane();
        pnlContent.setComponentOrientation(UIUtils.getComponentOrientation());
        pnlContent.setLayout(new BorderLayout(12, 0));
        OrientablePanel buttonPanel = new OrientablePanel(new FlowLayout(3));
        GWToolBar toolBar = new GWToolBar();
        toolBar.setBorder(null);
        toolBar.add(ControlsUtils.setToSkinlessComponent(((MVCController)this.getController()).getActionList().getAction(ActionKey.NEW_CONTACT).getToolBarComponent()));
        buttonPanel.add(toolBar);
        toolBar = new GWToolBar();
        toolBar.setBorder(null);
        toolBar.add(ControlsUtils.setToSkinlessComponent(((MVCController)this.getController()).getActionList().getAction(ActionKey.VIEW_CONTACT_DETAILS).getToolBarComponent()));
        buttonPanel.add(toolBar);
        OrientablePanel pnlLeft = new OrientablePanel(new BorderLayout());
        pnlLeft.add((Component)this.buildTableTopPane(), "North");
        pnlLeft.add((Component)new ColoredScrollPane(this.tableAddressList), "Center");
        pnlLeft.add((Component)buttonPanel, "South");
        pnlContent.add((Component)pnlLeft, "Center");
        buttonPanel = new OrientablePanel(new FlowLayout(4));
        OS.addButtons(buttonPanel, this.getBtnOk(), this.getBtnCancel());
        pnlContent.add((Component)buttonPanel, "South");
        pnlContent.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    protected void processCancelAction(ActionEvent event) {
        super.processCancelAction(event);
        this.tableAddressList.dispose();
        this.dispose();
    }

    protected void processCloseAction(WindowEvent event) {
        super.processCloseAction(event);
        this.tableAddressList.dispose();
        this.dispose();
    }

    protected JPanel buildRightPane() {
        JPanel pnlToggle = this.buildToggleButtons();
        pnlToggle.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.pnlRight.add((Component)pnlToggle, "North");
        OrientableScrollPane scrollList = new OrientableScrollPane(this.listRecipients);
        scrollList.setPreferredSize(new Dimension(200, (int)scrollList.getPreferredSize().getHeight()));
        this.pnlRight.add((Component)scrollList, "Center");
        this.pnlSaveGroup.add(this.btnSaveGroup);
        GWToolBar toolBar = new GWToolBar();
        toolBar.setBorder(null);
        toolBar.add(ControlsUtils.setToSkinlessComponent(((MVCController)this.getController()).getActionList().getAction(ActionKey.REMOVE_ENTRY_FROM_RECIPIENTS_LIST).getToolBarComponent()));
        this.pnlSaveGroup.add(toolBar);
        this.pnlRight.add((Component)this.pnlSaveGroup, "South");
        this.tableAddressList.setRecipientsList(this.listRecipients);
        return this.pnlRight;
    }

    public void dispose() {
        if (this.getController() != null && ((MVCController)this.getController()).getParentController() != null && ((MVCController)this.getController()).getParentController().getMVCView() instanceof AbstractAddressSelectorDialog) {
            lastInstance = (AbstractAddressSelectorDialog)((MVCController)this.getController()).getParentController().getMVCView();
        } else if (this.getController() != null) {
            lastInstance = null;
        }
        super.dispose();
    }

    private JComponent buildTableTopPane() {
        OrientablePanel pnlTop = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridy = 0;
        constraints.gridx = 0;
        constraints.anchor = 21;
        constraints.fill = 0;
        constraints.insets.left = 0;
        pnlTop.add((Component)new OrientableLabel(StringResources.LOOK_IN_C), constraints);
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.gridwidth = 3;
        constraints.gridy = 0;
        constraints.gridx = 1;
        constraints.insets.left = 5;
        constraints.insets.right = 0;
        pnlTop.add((Component)this.cbDirectories, constraints);
        constraints.gridwidth = 1;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets.left = 0;
        constraints.insets.right = 5;
        pnlTop.add((Component)new OrientableLabel(StringResources.LOOK_FOR_C), constraints);
        constraints.weightx = 1.0;
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.fill = 2;
        constraints.insets.left = 5;
        constraints.insets.right = 0;
        constraints.gridwidth = 3;
        pnlTop.add((Component)this.tfSearch, constraints);
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.fill = 2;
        constraints.gridx = 3;
        constraints.gridy = 1;
        constraints.insets.left = 5;
        constraints.insets.right = 0;
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.insets.left = 0;
        constraints.insets.right = 0;
        constraints.gridwidth = 4;
        pnlTop.add((Component)this.buildHeader(), constraints);
        return pnlTop;
    }

    private JComponent buildHeader() {
        SkinnableLabel lbAddressList = new SkinnableLabel(StringResources.ADDRESS_LIST_C);
        ControlsUtils.prepareHeaderLabel(lbAddressList);
        SkinnablePanel pnlRightHeader = new SkinnablePanel(new BorderLayout());
        ControlsUtils.prepareHeaderPanel(pnlRightHeader);
        pnlRightHeader.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pnlRightHeader.add((Component)lbAddressList, "Before");
        pnlRightHeader.add((Component)new ComponentWithMenu(this.lbFilter, new FilterPopupMenu()), "After");
        return pnlRightHeader;
    }

    void removeSaveGroupButton() {
        this.pnlSaveGroup.remove(this.btnSaveGroup);
    }

    private void setData() {
        List<AbstractAddressBook> addressBooks = EngineCommandManager.getAddressBooks();
        this.cbDirectories.setModel(new DefaultComboBoxModel<Object>(addressBooks.toArray()));
        String id = OptionManager.getInstance().getGeneralOptions().getSelectedAddressSelectorBookID();
        AbstractAddressBook selectedAddressBook = addressBooks.get(0);
        if (id != null) {
            for (AbstractAddressBook addressBook : addressBooks) {
                if (!id.equals(addressBook.getID())) continue;
                selectedAddressBook = addressBook;
                break;
            }
        }
        this.cbDirectories.setSelectedIndex(-1);
        this.cbDirectories.setSelectedItem(selectedAddressBook);
    }

    private void directoryChanged(AbstractAddressBook theDirectory) {
        LocalCommand command = new LocalCommand(360, theDirectory, ((MVCController)this.getController()).getActionList());
        ((MVCController)this.getController()).processCommand(command);
        GeneralOptions generalOptions = OptionManager.getInstance().getGeneralOptions();
        generalOptions.setSelectedAddressSelectorBookID(theDirectory.getID());
        OptionManager.getInstance().setGeneralOptions(generalOptions);
    }

    void setCopyType(RecipientCopyType theType) {
        ((MVCController)this.getController()).getActionList().getAction(ActionKey.MOVE_TO_RECIPIENTS_LIST).setMVCModel(theType);
    }

    class FilterPopupMenu
    extends GWPopupMenu {
        ButtonGroup buttonGroup = new ButtonGroup();
        private ItemListener itemListener = new FilterItemListener();

        public FilterPopupMenu() {
            ActionList actionList = ((MVCController)AbstractAddressSelectorDialog.this.getController()).getActionList();
            OrientableRadioButtonMenuItem menuItem = new OrientableRadioButtonMenuItem(actionList.getAction(ActionKey.AB_FILTER_OFF));
            menuItem.setText(StringResources.ALL_ENTRIES);
            menuItem.setIcon(ImageResources.ICON_UNACTIVE_FILTER);
            this.add(menuItem);
            menuItem.setSelected(true);
            this.buttonGroup.add(menuItem);
            menuItem.addItemListener(this.itemListener);
            menuItem = new OrientableRadioButtonMenuItem(actionList.getAction(ActionKey.AB_FILTER_USER));
            menuItem.setText(StringResources.CONTACTS);
            menuItem.setIcon(ImageResources.ICON_ADDRESS_BOOK_USER);
            this.add(menuItem);
            this.buttonGroup.add(menuItem);
            menuItem.addItemListener(this.itemListener);
            menuItem = new OrientableRadioButtonMenuItem(actionList.getAction(ActionKey.AB_FILTER_GROUP));
            menuItem.setText(StringResources.GROUPS);
            menuItem.setIcon(ImageResources.ICON_ADDRESS_BOOK_GROUP);
            this.add(menuItem);
            this.buttonGroup.add(menuItem);
            menuItem.addItemListener(this.itemListener);
            menuItem = new OrientableRadioButtonMenuItem(actionList.getAction(ActionKey.AB_FILTER_RESOURCE));
            menuItem.setText(StringResources.RESOURCES);
            menuItem.setIcon(ImageResources.ICON_ADDRESS_BOOK_RESOURSE);
            this.add(menuItem);
            this.buttonGroup.add(menuItem);
            menuItem.addItemListener(this.itemListener);
        }
    }

    private class FilterItemListener
    implements ItemListener {
        private FilterItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                Action action = ((JMenuItem)e.getItem()).getAction();
                if (action instanceof FilterOffAction) {
                    AbstractAddressSelectorDialog.this.lbFilter.setIcon(ImageResources.ICON_UNACTIVE_FILTER);
                } else {
                    AbstractAddressSelectorDialog.this.lbFilter.setIcon(ImageResources.ICON_ACTIVE_FILTER);
                }
            }
        }
    }

    static class DirectoriesRenderer
    extends WrappedNativeListCellRenderer {
        public DirectoriesRenderer(ListCellRenderer renderer) {
            super(renderer);
            if (renderer instanceof JComponent) {
                ((JComponent)((Object)this.renderer)).setOpaque(true);
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component rendererComponent = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof AbstractAddressBook && rendererComponent instanceof JLabel) {
                ((JLabel)rendererComponent).setIcon(ControlsUtils.getIconForAddressBook((AbstractAddressBook)value));
            }
            return rendererComponent;
        }
    }

    class DirectoriesItemListener
    implements ItemListener {
        DirectoriesItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1 && e.getItem() instanceof AbstractAddressBook) {
                AbstractAddressSelectorDialog.this.directoryChanged((AbstractAddressBook)e.getItem());
            }
        }
    }
}

