/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook;

import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.addressbook.AbstractAddressSelectorDialog;
import com.novell.gw.jclient.application.controls.addressbook.list.ContactListRenderrer;
import com.novell.gw.jclient.application.controls.addressbook.list.RecipientsList;
import com.novell.gw.jclient.application.controls.addressbook.table.UserSelectorTable;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressSelectorDialog
extends AbstractAddressSelectorDialog {
    private static Logger logger = Logger.getLogger(AddressSelectorDialog.class);
    private static final String NAME = "Address Selector Dialog";

    public AddressSelectorDialog(JFrame theParentFrame, MVCController theParentController) {
        super(theParentFrame, theParentController);
    }

    public AddressSelectorDialog(JDialog theDialog, MVCController theParentController) {
        super(theDialog, theParentController);
    }

    @Override
    protected void init() {
        this.listRecipients = new RecipientsList((MVCController)this.getController());
        this.listRecipients.setCellRenderer(new ContactListRenderrer());
        this.tableAddressList = new UserSelectorTable((MVCController)this.getController(), this.tfSearch);
        super.init();
        if (this.tableAddressList.getRowCount() > 0) {
            this.tableAddressList.setRowSelectionInterval(0, 0);
        }
        this.buildRightPane();
        this.getContentPane().add((Component)this.pnlRight, "After");
        this.toggleSizeSaving(NAME);
        this.pack();
    }

    @Override
    protected void processOkAction(ActionEvent event) {
        super.processOkAction(event);
        Command command = new Command(100, this.listRecipients.getRecipientList());
        ((MVCController)this.getController()).processCommand(command);
        this.dispose();
    }

    @Override
    protected JPanel buildToggleButtons() {
        OrientablePanel pnlContent = new OrientablePanel(new BorderLayout());
        JButton btnSelect = new JButton(((MVCController)this.getController()).getActionList().getAction(ActionKey.MOVE_TO_RECIPIENTS_LIST));
        btnSelect.setText(StringResources.SELECT_ADDRESS);
        pnlContent.add(btnSelect);
        return pnlContent;
    }

    public List<IAddressable> getSelectedContacts() {
        ArrayList<IAddressable> result = new ArrayList<IAddressable>();
        int nSize = this.listRecipients.getRecipientList().size();
        for (int i = 0; i < nSize; ++i) {
            IRecipient recipient = this.listRecipients.getRecipientList().get(i);
            result.add(recipient.getAddressable());
        }
        return result;
    }
}

