/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook;

import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.apache.log4j.Logger;

class DirectoriesTreeModel
extends DefaultTreeModel {
    private static Logger logger = Logger.getLogger(DirectoriesTreeModel.class);

    public DirectoriesTreeModel() {
        super(new DefaultMutableTreeNode());
        this.buildTree();
    }

    public void buildTree() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        root.removeAllChildren();
        for (AbstractAddressBook addressBook : EngineCommandManager.getAddressBooks()) {
            root.add(new DefaultMutableTreeNode(addressBook));
        }
    }

    public static DefaultMutableTreeNode getDirectoryNode(DefaultMutableTreeNode node, String bookID) {
        AbstractAddressBook book = (AbstractAddressBook)node.getUserObject();
        if (book.getID().equals(bookID)) {
            return node;
        }
        int nCount = node.getChildCount();
        for (int i = 0; i < nCount; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            DefaultMutableTreeNode resultNode = DirectoriesTreeModel.getDirectoryNode(child, bookID);
            if (resultNode == null) continue;
            return resultNode;
        }
        return null;
    }

    public DefaultMutableTreeNode getDirectoryNode(String bookID) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        int nCount = root.getChildCount();
        for (int i = 0; i < nCount; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)root.getChildAt(i);
            DefaultMutableTreeNode resultNode = DirectoriesTreeModel.getDirectoryNode(child, bookID);
            if (resultNode == null) continue;
            return resultNode;
        }
        return null;
    }
}

