/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.dialogs;

import com.appframework.ApplicationFrame;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.GridBagAdapter;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class AddressBookListDialog
extends GWDialog {
    private static Logger logger = Logger.getLogger(AddressBookListDialog.class);
    private List addressBooks = null;
    private AbstractAddressBook selectedAddressBook;
    private JList listDirectories = new OrientableList();

    public AddressBookListDialog(ApplicationFrame theOwner) throws HeadlessException {
        super(theOwner, true);
        this.addressBooks = EngineCommandManager.getEditableAddressBooks();
        this.listDirectories.setSelectionMode(0);
        this.init();
    }

    public AddressBookListDialog(ApplicationFrame theOwner, List theAddressBooks) {
        super(theOwner, true);
        this.addressBooks = theAddressBooks;
        this.init();
    }

    private void init() {
        this.setTitle(StringResources.ADDRESS_BOOKS);
        this.buildUI();
        ((JPanel)this.getContentPane()).setPreferredSize(new Dimension(400, 182));
    }

    public static void main(String[] args) {
        AddressBookListDialog dialog = new AddressBookListDialog(null);
        dialog.showMe();
    }

    private void buildUI() {
        OrientablePanel pnlContent = new OrientablePanel(new GridBagLayout());
        GridBagAdapter gridBagAdapter = new GridBagAdapter(pnlContent);
        gridBagAdapter.setColumnCount(1);
        gridBagAdapter.setRowCount(2);
        gridBagAdapter.setInsets(new Insets(10, 5, 10, 5));
        gridBagAdapter.setFill(0);
        gridBagAdapter.setAnchor(21);
        gridBagAdapter.addComponent(new JMnemonicLabel(StringResources.AVAILABLE_ADDRESS_BOOKS, this.listDirectories));
        this.listDirectories.setListData(this.addressBooks.toArray());
        if (!this.addressBooks.isEmpty()) {
            this.listDirectories.setSelectedIndex(0);
        }
        OrientableScrollPane scrollPane = new OrientableScrollPane(this.listDirectories);
        gridBagAdapter.setWidthX(1);
        gridBagAdapter.setWidthY(1);
        gridBagAdapter.addComponent(scrollPane);
        this.getContentPane().add((Component)pnlContent, "Center");
        OrientablePanel pnlButtons = new OrientablePanel(new GridBagLayout());
        gridBagAdapter = new GridBagAdapter(pnlButtons);
        gridBagAdapter.setColumnCount(1);
        gridBagAdapter.setRowCount(2);
        gridBagAdapter.setInsets(new Insets(10, 5, 10, 5));
        this.btnOK = new JButton(new OkAction());
        this.setDefaultButton(this.btnOK);
        gridBagAdapter.addComponent(this.btnOK);
        gridBagAdapter.addComponent(this.btnCancel);
        OrientablePanel pnlTemp = new OrientablePanel(new BorderLayout());
        pnlTemp.add((Component)pnlButtons, "North");
        this.getContentPane().add((Component)pnlTemp, "After");
    }

    public AbstractAddressBook getSelectedAddressBook() {
        return this.selectedAddressBook;
    }

    public Object[] getSelectedDirectories() {
        return this.listDirectories.getSelectedValues();
    }

    class OkAction
    extends AbstractAction {
        public OkAction() {
            super(StringResources.OK);
        }

        public void actionPerformed(ActionEvent e) {
            AddressBookListDialog.this.selectedAddressBook = (AbstractAddressBook)AddressBookListDialog.this.listDirectories.getSelectedValue();
            AddressBookListDialog.this.setActionCompleteSuccessfully(true);
            AddressBookListDialog.this.setVisible(false);
        }
    }
}

