/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.dialogs;

import com.appframework.components.ComponentBorder;
import com.appframework.utils.OS;
import com.novell.gw.ab.AddressBook;
import com.novell.gw.ab.SystemAddressBook;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.ABListModel;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.dialogs.SaveableDialog;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class NCSearchOrderDialog
extends SaveableDialog {
    private static Logger logger = Logger.getLogger(NCSearchOrderDialog.class);
    private ABListModel modelAvailable = new ABListModel();
    private ABListModel modelSelected = new ABListModel();
    private JList listAvailBooks = new OrientableList((ListModel)this.modelAvailable);
    private JList listSelectedBooks = new OrientableList((ListModel)this.modelSelected);
    private JLabel lblAvailableBooks = new JMnemonicLabel(StringResources.AVAILABLE_BOOKS_C, this.listAvailBooks);
    private JLabel lblSelectedBooks = new JMnemonicLabel(StringResources.SELECTED_BOOKS_C, this.listSelectedBooks);
    private JLabel lblBookPosition = new OrientableLabel(StringResources.BOOK_POSITION);
    private JButton btnDown = new OrientableButton(new DownAction());
    private JButton btnUp = new OrientableButton(new UpAction());
    private JButton btnRemove = new OrientableButton(new RemoveAction());
    private JButton btnAdd = new OrientableButton(new AddAction());
    private JCheckBox cbDisableNameCompletion = new OrientableCheckBox(StringResources.DISABLE_NAME_COMPLETION);

    public NCSearchOrderDialog(JFrame owner) throws HeadlessException {
        super(owner, true);
        this.setTitle(StringResources.NAME_COMPLETION_SEARCH_ORDER);
        this.init();
        this.buildUI();
        this.pack();
    }

    private void buildUI() {
        OrientablePanel panel = new OrientablePanel(new GridLayout(1, 2));
        panel.add(this.buildAvailableBooksPane());
        panel.add(this.buildSelectedBooksPane());
        this.panCenterPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.panCenterPanel.add((Component)panel, "Center");
        this.panCenterPanel.add((Component)this.buildBottomPane(), "Last");
    }

    private JPanel buildAvailableBooksPane() {
        ArrayList<AddressBook> availableBooks = new ArrayList<AddressBook>();
        List<AddressBook> searchBooks = Arrays.asList(EngineCommandManager.getNCCSearchOrder());
        Iterator i = EngineCommandManager.getAddressBookManager().getPersonalAddressBooksIterator();
        while (i.hasNext()) {
            AddressBook addressBook = (AddressBook)i.next();
            if (searchBooks.contains(addressBook)) continue;
            availableBooks.add(addressBook);
        }
        this.modelAvailable.setData(availableBooks);
        this.listAvailBooks.getSelectionModel().setSelectionMode(0);
        if (this.listAvailBooks.getModel().getSize() > 0) {
            this.listAvailBooks.setSelectedIndex(0);
        }
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.insets = new Insets(0, 0, 5, 5);
        c.fill = 0;
        c.anchor = 23;
        panel.add((Component)this.lblAvailableBooks, c);
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 2;
        c.weightx = 1.0;
        c.insets.bottom = 0;
        c.fill = 1;
        OrientableScrollPane scrollPane = new OrientableScrollPane(this.listAvailBooks);
        scrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        panel.add((Component)scrollPane, c);
        ++c.gridx;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets.right = 0;
        c.insets.bottom = 5;
        c.fill = 2;
        panel.add((Component)this.btnAdd, c);
        ++c.gridy;
        c.weighty = 1.0;
        c.insets.bottom = 0;
        panel.add((Component)this.btnRemove, c);
        return panel;
    }

    private JPanel buildSelectedBooksPane() {
        this.modelSelected.setData(new ArrayList<AddressBook>(Arrays.asList(EngineCommandManager.getNCCSearchOrder())));
        this.listSelectedBooks.getSelectionModel().setSelectionMode(0);
        JButton btnCancel = new JButton(new CancelAction());
        this.setCancelButton(btnCancel);
        OrientablePanel pnlButtons = new OrientablePanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        pnlButtons.setBorder(new ComponentBorder(this.lblBookPosition));
        c.gridx = 0;
        c.gridy = 0;
        pnlButtons.add((Component)this.lblBookPosition, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.insets.right = 5;
        c.fill = 2;
        pnlButtons.add((Component)this.btnDown, c);
        ++c.gridx;
        c.insets.right = 0;
        pnlButtons.add((Component)this.btnUp, c);
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        c = new GridBagConstraints();
        c.anchor = 21;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.insets = new Insets(0, 5, 5, 0);
        panel.add((Component)this.lblSelectedBooks, c);
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 1;
        c.gridheight = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        OrientableScrollPane scrollPane = new OrientableScrollPane(this.listSelectedBooks);
        scrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        panel.add((Component)scrollPane, c);
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 11;
        c.fill = 2;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        panel.add((Component)new JButton(new OkAction()), c);
        c.gridy = 2;
        panel.add((Component)btnCancel, c);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 4;
        c.insets.bottom = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        panel.add((Component)pnlButtons, c);
        return panel;
    }

    private void init() {
        this.listSelectedBooks.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int index = NCSearchOrderDialog.this.listSelectedBooks.getSelectedIndex();
                if (index >= 0) {
                    NCSearchOrderDialog.this.btnUp.setEnabled(index != 0);
                    NCSearchOrderDialog.this.btnDown.setEnabled(index != NCSearchOrderDialog.this.listSelectedBooks.getModel().getSize() - 1);
                    NCSearchOrderDialog.this.btnRemove.setEnabled(!(NCSearchOrderDialog.this.modelSelected.getData().get(index) instanceof SystemAddressBook));
                } else {
                    NCSearchOrderDialog.this.btnRemove.setEnabled(false);
                }
            }
        });
        this.listSelectedBooks.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (NCSearchOrderDialog.this.modelSelected.getData().get(index) instanceof SystemAddressBook) {
                    component.setEnabled(false);
                }
                return component;
            }
        });
        this.listAvailBooks.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int index = NCSearchOrderDialog.this.listAvailBooks.getSelectedIndex();
                NCSearchOrderDialog.this.btnAdd.setEnabled(index >= 0);
            }
        });
        this.listAvailBooks.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (OS.isDoubleClick(e) && NCSearchOrderDialog.this.btnAdd.isEnabled()) {
                    NCSearchOrderDialog.this.btnAdd.getAction().actionPerformed(null);
                }
            }
        });
        this.listSelectedBooks.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (OS.isDoubleClick(e) && NCSearchOrderDialog.this.btnRemove.isEnabled()) {
                    NCSearchOrderDialog.this.btnRemove.getAction().actionPerformed(null);
                }
            }
        });
        Insets insets = this.btnAdd.getMargin();
        insets.left = 5;
        insets.right = 5;
        this.btnAdd.setMargin(insets);
        insets = this.btnRemove.getMargin();
        insets.left = 5;
        insets.right = 5;
        this.btnRemove.setMargin(insets);
        this.cbDisableNameCompletion.addItemListener(new DisableNameCompletion());
        boolean disableNameCompletion = OptionManager.getInstance().getGeneralOptions().isDisabledNameCompletion();
        this.cbDisableNameCompletion.setSelected(disableNameCompletion);
        this.toggleSizeSaving("NCSearch order Dialog");
    }

    private JPanel buildBottomPane() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets.top = 10;
        c.anchor = 23;
        panel.add((Component)this.cbDisableNameCompletion, c);
        GWTextArea taText = new GWTextArea();
        ((JTextComponent)taText).setEditable(false);
        taText.setOpaque(false);
        String systemABName = "";
        systemABName = EngineCommandManager.getGroupWiseAdressBook().getName();
        ((JTextComponent)taText).setText(StringResources.formatString(StringResources.THE_NOVELL_SYSTEM, systemABName));
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets.top = 5;
        c.fill = 1;
        OrientableScrollPane scrollPane = new OrientableScrollPane(taText);
        scrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        panel.add((Component)scrollPane, c);
        return panel;
    }

    private static void selectNearestIndex(int index, JList theList) {
        int size = theList.getModel().getSize();
        if (size == 0) {
            return;
        }
        int selectionIndex = index >= size ? size - 1 : index;
        theList.setSelectedIndex(selectionIndex);
    }

    private class DisableNameCompletion
    implements ItemListener {
        List<JComponent> list = new ArrayList<JComponent>();

        private DisableNameCompletion() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (((JToggleButton)e.getSource()).isSelected()) {
                this.disable();
            } else {
                this.enable();
            }
        }

        private void addComponent(JComponent component) {
            if (component.isEnabled()) {
                component.setEnabled(false);
                this.list.add(component);
            }
        }

        private void disable() {
            NCSearchOrderDialog dialog = NCSearchOrderDialog.this;
            this.list.clear();
            this.addComponent(dialog.lblAvailableBooks);
            this.addComponent(dialog.lblSelectedBooks);
            this.addComponent(dialog.lblBookPosition);
            this.addComponent(dialog.listAvailBooks);
            this.addComponent(dialog.listSelectedBooks);
            this.addComponent(dialog.btnAdd);
            this.addComponent(dialog.btnRemove);
            this.addComponent(dialog.btnUp);
            this.addComponent(dialog.btnDown);
        }

        private void enable() {
            for (JComponent component : this.list) {
                component.setEnabled(true);
            }
        }
    }

    private class UpAction
    extends AbstractAction {
        public UpAction() {
            super(StringResources.UP);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            int index = NCSearchOrderDialog.this.listSelectedBooks.getSelectedIndex();
            NCSearchOrderDialog.this.modelSelected.moveUp(index);
            NCSearchOrderDialog.this.listSelectedBooks.setSelectedIndex(--index);
        }
    }

    private class DownAction
    extends AbstractAction {
        public DownAction() {
            super(StringResources.DOWN);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            int index = NCSearchOrderDialog.this.listSelectedBooks.getSelectedIndex();
            NCSearchOrderDialog.this.modelSelected.moveDown(index);
            NCSearchOrderDialog.this.listSelectedBooks.setSelectedIndex(++index);
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(StringResources.CANCEL);
        }

        public void actionPerformed(ActionEvent e) {
            NCSearchOrderDialog.this.dispose();
        }
    }

    private class OkAction
    extends AbstractAction {
        public OkAction() {
            super(StringResources.OK);
        }

        public void actionPerformed(ActionEvent e) {
            AddressBook[] addressBook = new AddressBook[NCSearchOrderDialog.this.modelSelected.getSize()];
            for (int i = 0; i < addressBook.length; ++i) {
                addressBook[i] = (AddressBook)NCSearchOrderDialog.this.modelSelected.getData().get(i);
            }
            EngineCommandManager.setNCCSearchOrder(addressBook);
            OptionManager.getInstance().getGeneralOptions().setDisabledNameCompletion(NCSearchOrderDialog.this.cbDisableNameCompletion.isSelected());
            NCSearchOrderDialog.this.dispose();
        }
    }

    private class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            String app = "<<";
            this.putValue("Name", app + " " + StringResources.REMOVE + " " + app);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            int index = NCSearchOrderDialog.this.listSelectedBooks.getSelectedIndex();
            AddressBook addressBook = (AddressBook)NCSearchOrderDialog.this.modelSelected.getData().get(index);
            NCSearchOrderDialog.this.modelSelected.removeItem(addressBook);
            NCSearchOrderDialog.this.modelAvailable.addItem(addressBook);
            NCSearchOrderDialog.selectNearestIndex(index, NCSearchOrderDialog.this.listSelectedBooks);
        }
    }

    private class AddAction
    extends AbstractAction {
        public AddAction() {
            String app = " >>";
            this.putValue("Name", app + " " + StringResources.ADD + " " + app);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            int index = NCSearchOrderDialog.this.listAvailBooks.getSelectedIndex();
            AddressBook addressBook = (AddressBook)NCSearchOrderDialog.this.modelAvailable.getData().get(index);
            NCSearchOrderDialog.this.modelAvailable.removeItem(addressBook);
            NCSearchOrderDialog.this.modelSelected.addItem(addressBook);
            NCSearchOrderDialog.selectNearestIndex(index, NCSearchOrderDialog.this.listAvailBooks);
        }
    }
}

