/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.dialogs;

import com.appframework.ApplicationFrame;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.api.enums.ContactType;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.GridBagAdapter;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JList;
import org.apache.log4j.Logger;

public class SelectContactTypeDialog
extends GWDialog {
    private static Logger logger = Logger.getLogger(SelectContactTypeDialog.class);
    private JList listEntryType;
    private ContactType contactType = ContactType.USER;
    private JButton btnOK;

    public SelectContactTypeDialog(ApplicationFrame theOwner) {
        super(theOwner);
        this.setModal(true);
        this.setTitle(StringResources.NEW_ENTRY);
        this.buildUI();
    }

    public void showMe() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private void buildUI() {
        Object[] values = new String[]{StringResources.CONTACT, StringResources.RESOURCE, StringResources.ORGANIZATION, StringResources.GROUP};
        this.listEntryType = new OrientableList(values);
        this.getContentPane().setComponentOrientation(UIUtils.getComponentOrientation());
        OrientablePanel pnlList = new OrientablePanel(new GridBagLayout());
        GridBagAdapter gridBagAdapter = new GridBagAdapter(pnlList);
        gridBagAdapter.setColumnCount(1);
        gridBagAdapter.setRowCount(2);
        gridBagAdapter.setInsets(new Insets(10, 5, 10, 5));
        gridBagAdapter.setFill(0);
        gridBagAdapter.setAnchor(21);
        gridBagAdapter.addComponent(new JMnemonicLabel(StringResources.SELECT_THE_ENTRY_TYPE_C, this.listEntryType));
        this.listEntryType.setPreferredSize(new Dimension(200, this.listEntryType.getPreferredSize().height + 10));
        this.listEntryType.setBorder(BorderFactory.createEtchedBorder());
        this.listEntryType.setSelectionMode(0);
        this.listEntryType.setSelectedIndex(0);
        this.listEntryType.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (OS.isDoubleClick(e)) {
                    SelectContactTypeDialog.this.performOkAction();
                }
            }
        });
        gridBagAdapter.addComponent(this.listEntryType);
        this.getContentPane().add((Component)pnlList, "Center");
        OrientablePanel pnlButtons = new OrientablePanel(new GridBagLayout());
        gridBagAdapter = new GridBagAdapter(pnlButtons);
        gridBagAdapter.setColumnCount(1);
        gridBagAdapter.setRowCount(2);
        gridBagAdapter.setInsets(new Insets(10, 5, 10, 5));
        this.btnOK = new JButton(new OkAction());
        gridBagAdapter.addComponent(this.btnOK);
        gridBagAdapter.addComponent(this.btnCancel);
        this.setDefaultButton(this.btnOK);
        OrientablePanel pnlTemp = new OrientablePanel(new BorderLayout());
        pnlTemp.add((Component)pnlButtons, "North");
        this.getContentPane().add((Component)pnlTemp, "After");
    }

    public ContactType getContactType() {
        return this.contactType;
    }

    protected void performOkAction() {
        switch (this.listEntryType.getSelectedIndex()) {
            case 0: {
                this.contactType = ContactType.USER;
                break;
            }
            case 1: {
                this.contactType = ContactType.RESOURCE;
                break;
            }
            case 2: {
                this.contactType = ContactType.ORGANIZATION;
                break;
            }
            case 3: {
                this.contactType = ContactType.GROUP;
            }
        }
        super.performOkAction();
    }

    class OkAction
    extends AbstractAction {
        public OkAction() {
            super(StringResources.OK);
        }

        public void actionPerformed(ActionEvent e) {
            SelectContactTypeDialog.this.performOkAction();
        }
    }
}

