/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.properties;

import com.appframework.components.ComponentBorder;
import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.ab.AddressBookSharedList;
import com.novell.gw.jclient.application.ExtendedGWTable;
import com.novell.gw.jclient.application.controls.ColoredScrollPane;
import com.novell.gw.jclient.application.controls.addressbook.AddressSelectorDialog;
import com.novell.gw.jclient.application.controls.addressbook.SearchEvent;
import com.novell.gw.jclient.application.controls.addressbook.SearchResultListener;
import com.novell.gw.jclient.application.controls.addressbook.SearchTextField;
import com.novell.gw.jclient.application.controls.addressbook.properties.ShareListTableModel;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButton;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.om.directory.PersonalAddressBook;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class SharingPane
extends OrientablePanel {
    private AbstractButton rbNotShare = new OrientableRadioButton(new NotShareAction());
    private AbstractButton rbShare = new OrientableRadioButton(new ShareWithAction());
    private JButton btnAddUser = new JButton(new AddUserAction());
    private AbstractButton btnRemoveUser = new JButton(new RemoveUserAction());
    private AbstractButton btnViewAddressBook = new JButton(new ViewABAction());
    private SearchTextField tfName = new SearchTextField();
    private AbstractButton rbReadOnly = new OrientableRadioButton(new ReadOnlyAccessAction());
    private AbstractButton rbAll = new OrientableRadioButton(new AllAccessAction());
    private ShareListTableModel model;
    private JTable tableShareList = new ExtendedGWTable();
    private Component[] components = new Component[]{this.tfName, this.btnViewAddressBook, this.tableShareList};
    private PersonalAddressBook addressBook;
    private JDialog parentDialog;
    private MVCController parentController;
    private boolean readOnly;
    private JButton btnDefaultParentButton;

    public SharingPane(JDialog parentDialog, MVCController parentController, JButton defaultParentButton, PersonalAddressBook theAddressBook) {
        super(new BorderLayout());
        assert (defaultParentButton != null);
        this.parentDialog = parentDialog;
        this.parentController = parentController;
        this.btnDefaultParentButton = defaultParentButton;
        this.addressBook = theAddressBook;
        this.readOnly = this.addressBook.getNativeAddressBook().isSharedToMe();
        this.model = new ShareListTableModel(this.addressBook.getSharedList(), parentController);
        this.tableShareList.setModel(this.model);
        this.setName(StringResources.SHARING);
        this.setBorder(BorderFactory.createEmptyBorder(0, 15, 10, 15));
        this.add((Component)this.buildTopPane(), "North");
        this.add((Component)this.buildBottomPane(), "Center");
        this.btnAddUser.setEnabled(false);
        this.btnRemoveUser.setEnabled(false);
        this.tableShareList.setShowGrid(false);
        this.tableShareList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int itemDeleteKey = OptionManager.getInstance().getGeneralOptions().getItemDeleteKey();
                if (e.getKeyCode() == itemDeleteKey) {
                    SharingPane.this.btnRemoveUser.getAction().actionPerformed(null);
                }
            }
        });
        if (this.addressBook.getSharedList() == null) {
            this.rbNotShare.doClick();
        } else {
            this.rbShare.doClick();
        }
        this.tableShareList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                SharingPane.this.processUserSelection();
            }
        });
        this.tfName.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                SharingPane.this.enableAddButton();
            }

            public void removeUpdate(DocumentEvent e) {
                SharingPane.this.enableAddButton();
            }

            public void changedUpdate(DocumentEvent e) {
                SharingPane.this.enableAddButton();
            }
        });
        if (this.readOnly) {
            this.markControlsReadOnly();
        }
        this.tfName.setListener(new SearchResultListener(){

            public void searchFinished(SearchEvent e) {
                if (e.getFoundContact() != null) {
                    SharingPane.this.rbReadOnly.setSelected(true);
                    SharingPane.this.model.addContact(e.getFoundContact());
                    SharingPane.this.tfName.setText("");
                    SharingPane.this.selectLastEntry();
                }
            }
        });
    }

    private void markControlsReadOnly() {
        this.rbShare.setEnabled(false);
        this.rbNotShare.setEnabled(false);
        this.btnAddUser.setEnabled(false);
        this.btnRemoveUser.setEnabled(false);
        this.btnViewAddressBook.setEnabled(false);
        this.tfName.setEnabled(false);
        this.rbReadOnly.setEnabled(false);
        this.rbAll.setEnabled(false);
    }

    private void processUserSelection() {
        boolean isEmpty = this.tableShareList.getSelectedRowCount() == 0;
        boolean isMultiple = this.tableShareList.getSelectedRowCount() > 1;
        this.btnRemoveUser.setEnabled(!isEmpty && !this.readOnly);
        this.setAccessButtonsEnabled(!isEmpty && !this.readOnly && !isMultiple);
        if (!isEmpty) {
            int index = this.tableShareList.getSelectedRow();
            boolean allAccess = this.model.getAccessList().get(index).getAccessRights().hasAllAccess();
            if (allAccess) {
                this.rbAll.setSelected(true);
            } else {
                this.rbReadOnly.setSelected(true);
            }
        } else {
            this.rbReadOnly.setSelected(true);
        }
    }

    private void enableAddButton() {
        if (this.readOnly || this.tfName.getText().trim().length() == 0) {
            this.btnAddUser.setEnabled(false);
            ((JDialog)SwingUtilities.getWindowAncestor(this)).getRootPane().setDefaultButton(this.btnDefaultParentButton);
        } else {
            this.btnAddUser.setEnabled(true);
            ((JDialog)SwingUtilities.getWindowAncestor(this)).getRootPane().setDefaultButton(this.btnAddUser);
        }
    }

    protected JPanel buildTopPane() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbNotShare);
        buttonGroup.add(this.rbShare);
        this.rbShare.setSelected(true);
        OrientablePanel pnlContent = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.anchor = 23;
        constraints.insets = new Insets(10, 15, 0, 0);
        pnlContent.add((Component)this.rbNotShare, constraints);
        return pnlContent;
    }

    private JPanel buildBottomPane() {
        OrientablePanel pnlName = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = 0;
        constraints.insets.right = 5;
        constraints.anchor = 21;
        pnlName.add((Component)new OrientableLabel(StringResources.NAME_C), constraints);
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.fill = 1;
        pnlName.add((Component)this.tfName, constraints);
        constraints.weightx = 0.0;
        constraints.fill = 0;
        this.btnViewAddressBook.setPreferredSize(new Dimension(23, 23));
        pnlName.add((Component)this.btnViewAddressBook, constraints);
        OrientablePanel pnlButtons = new OrientablePanel(new GridLayout(2, 1, 0, 5));
        pnlButtons.add(this.btnAddUser);
        pnlButtons.add(this.btnRemoveUser);
        OrientablePanel pnlTop = new OrientablePanel(new BorderLayout());
        pnlTop.add((Component)pnlName, "Center");
        pnlTop.add((Component)pnlButtons, "After");
        OrientablePanel pnlContent = new OrientablePanel(new GridBagLayout());
        constraints = new GridBagConstraints();
        constraints.anchor = 21;
        constraints.gridy = 1;
        pnlContent.add((Component)this.rbShare, constraints);
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints.insets.top = 5;
        constraints.fill = 2;
        pnlContent.add((Component)pnlTop, constraints);
        constraints.gridy = 3;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        ColoredScrollPane scroll = new ColoredScrollPane(this.tableShareList);
        scroll.setPreferredSize(new Dimension(350, 200));
        pnlContent.add((Component)scroll, constraints);
        JPanel pnlCheckBoxes = this.buildAccessPanel();
        constraints.weighty = 0.0;
        constraints.gridy = 4;
        constraints.fill = 2;
        pnlContent.add((Component)pnlCheckBoxes, constraints);
        ComponentBorder componentBorder = new ComponentBorder(this.rbShare);
        pnlContent.setBorder(BorderFactory.createCompoundBorder(componentBorder, BorderFactory.createEmptyBorder(0, 10, 10, 10)));
        return pnlContent;
    }

    public void saveChanges() {
        if (!this.readOnly) {
            AddressBookSharedList sharedList = this.model.getAccessList();
            if (this.rbNotShare.isSelected() || sharedList.getSize() == 0) {
                sharedList = null;
            }
            GWEngineUtils.shareAddressBook(this.addressBook, sharedList);
        }
    }

    private JPanel buildAccessPanel() {
        this.rbReadOnly.setSelected(true);
        OrientablePanel pnlCheckBoxes = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        ButtonGroup buttonGroup = new ButtonGroup();
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 21;
        constraints.insets.left = 10;
        pnlCheckBoxes.add((Component)this.rbReadOnly, constraints);
        constraints.insets.left = 0;
        constraints.insets.right = 0;
        pnlCheckBoxes.add((Component)this.rbAll, constraints);
        buttonGroup.add(this.rbReadOnly);
        buttonGroup.add(this.rbAll);
        pnlCheckBoxes.setBorder(BorderFactory.createTitledBorder(StringResources.ACCESS));
        return pnlCheckBoxes;
    }

    private void setAccessButtonsEnabled(boolean b) {
        this.rbReadOnly.setEnabled(b);
        this.rbAll.setEnabled(b);
    }

    private void selectLastEntry() {
        int index = this.model.getRowCount() - 1;
        if (index >= 0) {
            this.tableShareList.setRowSelectionInterval(index, index);
        }
    }

    private class ViewABAction
    extends AbstractAction {
        public ViewABAction() {
            super("", ImageResources.ICON_ACT_VIEW_ADDRESS_SELECTOR);
        }

        public void actionPerformed(ActionEvent e) {
            AddressSelectorDialog selectorDialog = new AddressSelectorDialog(SharingPane.this.parentDialog, SharingPane.this.parentController);
            selectorDialog.setVisible(true);
            if (selectorDialog.isOkActionProcessed() && !selectorDialog.getSelectedContacts().isEmpty()) {
                SharingPane.this.model.addContacts(selectorDialog.getSelectedContacts());
            }
        }
    }

    private class AllAccessAction
    extends AbstractAction {
        public AllAccessAction() {
            super(StringResources.ALL_ACCESS);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            SharingPane.this.model.getAccessList().get(SharingPane.this.tableShareList.getSelectedRow()).getAccessRights().setAccess(true);
            SharingPane.this.repaint();
        }
    }

    private class ReadOnlyAccessAction
    extends AbstractAction {
        public ReadOnlyAccessAction() {
            super(StringResources.READ_ONLY);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            SharingPane.this.model.getAccessList().get(SharingPane.this.tableShareList.getSelectedRow()).getAccessRights().setAccess(false);
            SharingPane.this.repaint();
        }
    }

    private class RemoveUserAction
    extends AbstractAction {
        public RemoveUserAction() {
            super(StringResources.REMOVE_USER);
        }

        public void actionPerformed(ActionEvent e) {
            int selectedRow = SharingPane.this.tableShareList.getSelectedRow();
            if (selectedRow != -1) {
                SharingPane.this.model.removeUser(selectedRow);
                if (SharingPane.this.model.getRowCount() == 0) {
                    SharingPane.this.btnRemoveUser.setEnabled(false);
                    SharingPane.this.setAccessButtonsEnabled(false);
                }
            }
        }
    }

    private class AddUserAction
    extends AbstractAction {
        public AddUserAction() {
            super(StringResources.ADD_USER);
        }

        public void actionPerformed(ActionEvent e) {
            SharingPane.this.tfName.updateListener();
        }
    }

    private class ShareWithAction
    extends AbstractAction {
        public ShareWithAction() {
            super(StringResources.SHARED_WITH);
        }

        public void actionPerformed(ActionEvent e) {
            UIUtils.setComponentsEnabled(SharingPane.this.components, true);
        }
    }

    private class NotShareAction
    extends AbstractAction {
        public NotShareAction() {
            super(StringResources.NOT_SHARED);
        }

        public void actionPerformed(ActionEvent e) {
            UIUtils.setComponentsEnabled(SharingPane.this.components, false);
        }
    }
}

