/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.table;

import com.appframework.AppAction;
import com.appframework.event.AppEvent;
import com.appframework.listener.ListenerType;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.ab.AddressBookEvent;
import com.novell.gw.ab.AddressBookEventListener;
import com.novell.gw.ab.AddressBookItemListFilter;
import com.novell.gw.ab.PersonalAddressBook;
import com.novell.gw.engine.ItemListEvent;
import com.novell.gw.engine.ItemListFilter;
import com.novell.gw.engine.TransferItems;
import com.novell.gw.jclient.api.impl.APIWrapperManager;
import com.novell.gw.jclient.api.impl.ab.APIAbWrapperManager;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IItemListListener;
import com.novell.gw.jclient.api.interfaces.ab.IAddressBookItemList;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.CategoriesContactsEntryRenderer;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.GWTable;
import com.novell.gw.jclient.application.HeaderSortRenderer;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.addressbook.AddressSelectorDialogActionList;
import com.novell.gw.jclient.application.controls.addressbook.list.RecipientsList;
import com.novell.gw.jclient.application.controls.addressbook.table.AbstractAddressBookTableController;
import com.novell.gw.jclient.application.controls.addressbook.table.AddressBookTableModel;
import com.novell.gw.jclient.application.controls.addressbook.table.AddressSelectorEntriesTable;
import com.novell.gw.jclient.application.controls.addressbook.table.ContactNotFoundException;
import com.novell.gw.jclient.application.controls.addressbook.table.SortHeader;
import com.novell.gw.jclient.application.controls.addressbook.table.SortHeaderListener;
import com.novell.gw.jclient.application.controls.folderstree.MainGWFoldersTree;
import com.novell.gw.jclient.application.frames.addressbook.FrameAddressBook;
import com.novell.gw.jclient.application.frames.addressbook.FrameAddressBookActionList;
import com.novell.gw.jclient.application.impl.SelectedContactsInfoImpl;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.impl.dnd.GWFlavors;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import com.novell.gw.jclient.bl.om.directory.GroupWiseAddressBook;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.ContactsFolder;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListSelectionModel;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAddressBookTable<M extends AddressBookTableModel>
extends GWTable
implements MVCView,
SortHeaderListener {
    private static Logger logger = Logger.getLogger(AbstractAddressBookTable.class);
    private static final Color DEFAULT_BACKGROUND = Color.WHITE;
    protected MVCController controller;
    protected M abstractAddressBookTableModel;
    protected AbstractAddressBook selectedDirectory;
    protected List selectedEntries = new ArrayList();
    protected HeaderSortRenderer sortRenderer = new HeaderSortRenderer(ControlsUtils.getHeaderRendererSize());
    public int[] columnsIDs = new int[]{3, 9, 48, 28, 31, 11, 6, 4};
    private TimerAction timerAction = new TimerAction();
    private Timer timer = new Timer(400, this.timerAction);
    private StringBuffer searchText = new StringBuffer();
    public JTextField tfSearch;
    private MyDocumentListener documentListener = new MyDocumentListener();
    private ItemListFilter filter;
    private CategoriesContactsEntryRenderer cellRenderer = new CategoriesContactsEntryRenderer();
    private int searchField = 3;
    private boolean sortAscendingDisplayName = true;
    protected IItemListListener gwListDataListener;
    private AddressBookEventListener addressBookEventListener;
    protected IItemList addressBookItemList;
    private IItemList systemItemList;
    private boolean needRefreshSystemItemList = false;
    private int selectedContactId;
    private IItem selectedContact;
    private RecipientsList recipientsList;

    public AbstractAddressBookTable(MVCController theParentController, JTextField theTfSearch) {
        this.abstractAddressBookTableModel = this.createTableModel();
        this.setBackground(DEFAULT_BACKGROUND);
        this.controller = this.createController(theParentController);
        this.setShowGrid(false);
        this.setModel((TableModel)this.abstractAddressBookTableModel);
        this.tfSearch = theTfSearch;
        TableModel model = this.getModel();
        TableColumnModel colModel = this.getColumnModel();
        int nCount = colModel.getColumnCount();
        for (int i = 0; i < nCount; ++i) {
            if (model.getColumnClass(i) == Icon.class) continue;
            colModel.getColumn(i).setHeaderRenderer(this.sortRenderer);
        }
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectionListener());
        listSelectionModel.setValueIsAdjusting(true);
        this.setDefaultColumnSize();
        this.setTableHeader(new SortHeader(colModel, this));
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    AbstractAddressBookTable.this.performDefaultAction();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (OS.isDoubleClick(e)) {
                    AbstractAddressBookTable.this.performDefaultAction();
                }
            }
        });
        ControlsUtils.getListenerManager(this.controller).addListener(this, new ABFocusListener(), ListenerType.FOCUS_LISTENER);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 3, new DGListener());
        this.setDropTarget(new DropTarget(this, 3, new ETDTListener()));
        this.timer.setRepeats(false);
        if (this.tfSearch != null) {
            this.tfSearch.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (FocusManager.getCurrentManager().getPermanentFocusOwner() == null) {
                        if (AbstractAddressBookTable.this.tfSearch != null) {
                            AbstractAddressBookTable.this.tfSearch.setText("");
                        }
                        AbstractAddressBookTable.this.searchText.delete(0, AbstractAddressBookTable.this.searchText.length());
                    }
                }
            });
            this.tfSearch.getDocument().addDocumentListener(this.documentListener);
        }
        this.addKeyListener(new SearchKeyListener());
        this.filter = new AddressBookItemListFilter(false);
        ((AddressBookItemListFilter)this.filter).setContactType(15);
        this.setComponentOrientation(UIUtils.getComponentOrientation());
        this.setAutoResizeMode(0);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (AbstractAddressBookTable.this.getRowCount() > 0 && AbstractAddressBookTable.this.getSelectedRow() == -1) {
                    AbstractAddressBookTable.this.setRowSelectionInterval(0, 0);
                }
            }
        });
        this.gwListDataListener = new IItemListListener(){

            public void contentsChanged(ItemListEvent e) {
                AbstractAddressBookTable.this.updateSystemAddressBook();
            }

            public void moreResultsAvailable(ItemListEvent e) {
                AbstractAddressBookTable.this.updateSystemAddressBook();
            }

            public void queryResultsDone(ItemListEvent e) {
                AbstractAddressBookTable.this.updateSystemAddressBook();
            }

            public void notifyEmptyList(ItemListEvent e) {
                AbstractAddressBookTable.this.updateSystemAddressBook();
            }
        };
        this.addressBookEventListener = new AddressBookEventListener(){

            public void bookChanged(AddressBookEvent e) {
            }

            public void entryChanged(AddressBookEvent e) {
                AbstractAddressBookTable.this.update();
            }
        };
    }

    protected AbstractAddressBookTableController createController(MVCController parentController) {
        return new AbstractAddressBookTableController(this, parentController);
    }

    public void setRecipientsList(RecipientsList recipientsList) {
        this.recipientsList = recipientsList;
    }

    protected M createTableModel() {
        return (M)new AddressBookTableModel<AbstractAddressBookTable>(this);
    }

    public void dispose() {
        this.removeListeners();
        if (this.tfSearch != null) {
            this.tfSearch.getDocument().removeDocumentListener(this.documentListener);
            this.tfSearch = null;
        }
        this.documentListener = null;
        if (this.timer != null) {
            this.timer.stop();
            this.timer.removeActionListener(this.timerAction);
            this.timer = null;
        }
        this.timerAction = null;
        ((AddressBookTableModel)this.abstractAddressBookTableModel).dispose();
        this.addressBookItemList = null;
        this.systemItemList = null;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        boolean isVerticalScroll;
        Rectangle oldBounds = this.getBounds();
        boolean bl = isVerticalScroll = !oldBounds.isEmpty() && oldBounds.y != y;
        if (this.selectedDirectory instanceof GroupWiseAddressBook && isVerticalScroll) {
            ((IAddressBookItemList)this.systemItemList).sabPreScrollAction();
        }
        super.setBounds(x, y, width, height);
    }

    protected void addListeners() {
        if (this.selectedDirectory instanceof GroupWiseAddressBook) {
            if (this.systemItemList == null) {
                this.systemItemList = APIWrapperManager.getItemList(this.selectedDirectory.getNativeAddressBook().getContents());
            }
            this.systemItemList.removeItemListListener(this.gwListDataListener);
            this.systemItemList.addItemListListener(this.gwListDataListener);
        } else {
            ((PersonalAddressBook)this.selectedDirectory.getNativeAddressBook()).removeAddressBookEventListener(this.addressBookEventListener);
            ((PersonalAddressBook)this.selectedDirectory.getNativeAddressBook()).addAddressBookEventListener(this.addressBookEventListener);
        }
    }

    public void removeListeners() {
        if (this.selectedDirectory instanceof GroupWiseAddressBook) {
            if (this.systemItemList != null) {
                this.systemItemList.removeItemListListener(this.gwListDataListener);
            }
        } else if (this.selectedDirectory != null) {
            ((PersonalAddressBook)this.selectedDirectory.getNativeAddressBook()).removeAddressBookEventListener(this.addressBookEventListener);
        }
    }

    private void updateSystemAddressBook() {
        this.update();
    }

    protected void update() {
        if (this.selectedDirectory instanceof GroupWiseAddressBook) {
            if (this.systemItemList == null) {
                this.systemItemList = APIWrapperManager.getItemList(this.selectedDirectory.getNativeAddressBook().getContents());
            }
            ((AddressBookTableModel)this.abstractAddressBookTableModel).updateData(this.systemItemList);
        } else {
            ((AddressBookTableModel)this.abstractAddressBookTableModel).updateData(this.addressBookItemList);
        }
        this.clearSelection();
        if (this.selectedContact != null) {
            this.selectModifiedContact(this.selectedContactId);
        }
    }

    private void setStatusBarText(boolean searchFailed) {
        Window windowAncestor = SwingUtilities.getWindowAncestor(this);
        if (windowAncestor instanceof FrameAddressBook) {
            FrameAddressBook addressBook = (FrameAddressBook)windowAncestor;
            addressBook.setStatusText(searchFailed ? StringResources.SEARCH_FAILED_WAITING_FOR_USER_INPUT : StringResources.WAITING_FOR_USER_INPUT);
        }
    }

    private int getColumnIndexById(int theID) {
        int nCount = this.columnsIDs.length;
        for (int i = 0; i < nCount; ++i) {
            if (this.columnsIDs[i] != theID) continue;
            return i + 1;
        }
        return -1;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        return this.cellRenderer;
    }

    @Override
    public void columnSort(int column) {
        if ((column = this.convertColumnIndexToModel(column)) != 0) {
            boolean validSort = false;
            int sortField = this.columnsIDs[column - 1];
            IItemList itemList = this.selectedDirectory instanceof GroupWiseAddressBook ? this.systemItemList : ((AddressBookTableModel)this.abstractAddressBookTableModel).getItemList();
            boolean ascending = true;
            if (sortField == itemList.getSortField()) {
                boolean bl = ascending = !itemList.isSortAscending();
            }
            if (this.selectedDirectory instanceof GroupWiseAddressBook) {
                validSort = sortField == 3;
                int[] fields = this.selectedDirectory.getNativeAddressBook().getIndexedFields();
                for (int i = 0; i < fields.length && !validSort; ++i) {
                    validSort = fields[i] == sortField;
                }
                if (validSort) {
                    if (sortField == 3 && sortField == this.searchField) {
                        ascending = this.sortAscendingDisplayName = !this.sortAscendingDisplayName;
                    }
                    this.systemItemList = APIWrapperManager.getItemList(this.selectedDirectory.getNativeAddressBook().getContents(sortField, ascending));
                    ((AddressBookTableModel)this.abstractAddressBookTableModel).updateData(this.systemItemList);
                }
            } else {
                itemList.sort(sortField, ascending);
                validSort = true;
            }
            if (validSort) {
                this.searchField = sortField;
                this.paintSortIcon(sortField, ascending);
                this.clearSelection();
                this.selectItems();
            }
        }
    }

    @Override
    public void columnShowPopUpMenu(int theColumnIndex, MouseEvent e) {
    }

    @Override
    public void columnEndDrag(int theColumnIndex) {
    }

    @Override
    public void columnBeginDrag(int theColumnIndex) {
    }

    void paintSortIcon(int sortFIeld, boolean ascending) {
        int sortIndex = -1;
        if (this.abstractAddressBookTableModel != null && ((AddressBookTableModel)this.abstractAddressBookTableModel).getItemList() != null) {
            sortIndex = this.getColumnIndexById(sortFIeld);
        }
        if (sortIndex != -1) {
            this.sortRenderer.setSorted(this.convertColumnIndexToView(sortIndex), ascending);
        } else {
            this.sortRenderer.setClear();
        }
        this.repaint();
    }

    public AbstractAddressBook getSelectedDirectory() {
        return this.selectedDirectory;
    }

    public void filterTable(ItemListFilter theFilter) {
        this.filter = theFilter;
        this.filterTable();
    }

    public void setFilter(ItemListFilter filter) {
        this.filter = filter;
    }

    public void filterTable() {
        if (this.selectedDirectory instanceof GroupWiseAddressBook) {
            this.systemItemList = APIWrapperManager.getItemList(this.selectedDirectory.getNativeAddressBook().getContents(this.filter));
            this.needRefreshSystemItemList = !"".equals(this.filter.generateDescription());
            ((AddressBookTableModel)this.abstractAddressBookTableModel).updateData(this.systemItemList);
        } else if (((AddressBookTableModel)this.abstractAddressBookTableModel).getItemList() != null) {
            if (this.getController().getActionList() instanceof FrameAddressBookActionList || this.getController().getActionList() instanceof AddressSelectorDialogActionList) {
                IItemList itemList = ((AddressBookTableModel)this.abstractAddressBookTableModel).getItemList();
                itemList.setFilter(this.filter);
                ((AddressBookTableModel)this.abstractAddressBookTableModel).updateData(itemList);
            }
            ((AbstractTableModel)this.abstractAddressBookTableModel).fireTableDataChanged();
        }
    }

    protected abstract void performDefaultAction();

    protected List<IRecipient> getSelectedRecipients() {
        ArrayList<IRecipient> recipients = new ArrayList<IRecipient>();
        if (this.getSelectedRowCount() > 0) {
            IItemList itemList = ((AddressBookTableModel)this.abstractAddressBookTableModel).getItemList();
            int[] indexes = this.getSelectedRows();
            int nCount = indexes.length;
            for (int i = 0; i < nCount; ++i) {
                IItem item = itemList.getItemAt(indexes[i]);
                if (!(item instanceof IContact)) continue;
                IContact entry = (IContact)itemList.getItemAt(indexes[i]);
                recipients.add(APIAbWrapperManager.createRecipient(entry));
            }
        }
        return recipients;
    }

    protected int getFirstColumnWidth() {
        return 20;
    }

    protected void setDefaultColumnSize() {
        TableColumnModel model = this.getColumnModel();
        int count = model.getColumnCount();
        FontMetrics fm = this.getFontMetrics(new JLabel().getFont());
        block8: for (int i = 0; i < count; ++i) {
            TableColumn col = model.getColumn(i);
            if (i == 0) {
                col.setPreferredWidth(this.getFirstColumnWidth());
                col.setMaxWidth(this.getFirstColumnWidth());
                col.setMinWidth(this.getFirstColumnWidth());
                col.setResizable(false);
                continue;
            }
            switch (this.columnsIDs[i - 1]) {
                case 3: {
                    col.setPreferredWidth(fm.stringWidth("Firstname Lastname"));
                    continue block8;
                }
                case 9: {
                    col.setPreferredWidth(fm.stringWidth("first.lastname@internet.com"));
                    continue block8;
                }
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: {
                    col.setPreferredWidth(fm.stringWidth("(123) 456-7890"));
                    continue block8;
                }
                case 4: {
                    col.setPreferredWidth(fm.stringWidth("Firstname"));
                    continue block8;
                }
                case 6: {
                    col.setPreferredWidth(fm.stringWidth("Lastname"));
                    continue block8;
                }
                case 11: {
                    col.setPreferredWidth(fm.stringWidth("Username"));
                }
            }
        }
    }

    public void setController(MVCController theController) {
        if (!(theController instanceof AbstractAddressBookTableController)) {
            throw new IllegalArgumentException("Incorect passed controller type");
        }
        this.controller = theController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setSelectedEntry(IContact theContact) throws ContactNotFoundException {
        int index = ((AddressBookTableModel)this.abstractAddressBookTableModel).getItemList().indexOf(theContact);
        if (index == -1) {
            throw new ContactNotFoundException(theContact);
        }
        this.selectedEntries.add(theContact);
        this.selectItems();
    }

    public IItem getSelectedEntry() {
        int index = this.getSelectedRow();
        if (index == -1) {
            return null;
        }
        IItemList itemList = ((AddressBookTableModel)this.abstractAddressBookTableModel).getItemList();
        return itemList == null ? null : itemList.getItemAt(index);
    }

    public List<IAddressable> getSelectedContacts() {
        int[] selectedRows = this.getSelectedRows();
        ArrayList<IAddressable> result = new ArrayList<IAddressable>(selectedRows.length);
        int nCount = selectedRows.length;
        IItemList itemList = ((AddressBookTableModel)this.abstractAddressBookTableModel).getItemList();
        if (itemList == null) {
            return result;
        }
        for (int i = 0; i < nCount; ++i) {
            int nSelectedRow = selectedRows[i];
            IItem item = itemList.getItemAt(nSelectedRow);
            if (!(item instanceof IContact)) continue;
            result.add((IAddressable)((Object)item));
        }
        return result;
    }

    public void setMVCModel(Object theModel) {
        this.cellRenderer.clearCache();
        if (theModel instanceof AbstractAddressBook) {
            this.clearSelection();
            if (theModel.equals(this.selectedDirectory)) {
                return;
            }
            this.selectedEntries.clear();
            if (theModel instanceof GroupWiseAddressBook) {
                this.updateItemList((AbstractAddressBook)theModel, this.needRefreshSystemItemList);
                this.needRefreshSystemItemList = false;
            } else {
                this.updateItemList((AbstractAddressBook)theModel, false);
            }
            this.controller.processCommand(new Command(1160, this));
        }
    }

    protected void updateItemList(AbstractAddressBook addressBook, boolean updateSystemList) {
        this.removeListeners();
        this.selectedDirectory = addressBook;
        if (this.selectedDirectory instanceof GroupWiseAddressBook) {
            if (this.systemItemList == null || updateSystemList) {
                this.systemItemList = APIWrapperManager.getItemList(this.selectedDirectory.getNativeAddressBook().getContents());
            }
            ((AddressBookTableModel)this.abstractAddressBookTableModel).updateData(this.systemItemList);
        } else {
            this.addressBookItemList = APIWrapperManager.getItemList(this.selectedDirectory.getNativeAddressBook().getContents());
            ((AddressBookTableModel)this.abstractAddressBookTableModel).updateData(this.addressBookItemList);
        }
        this.addListeners();
    }

    private void selectItems() {
        for (Object selectedEntry : this.selectedEntries) {
            IContact entry = (IContact)selectedEntry;
            int index = ((AddressBookTableModel)this.abstractAddressBookTableModel).getEntryIndex(entry);
            if (index < 0) continue;
            this.addRowSelectionInterval(index, index);
        }
    }

    public void scrollToVisible(int row) {
        this.scrollToVisible(row, 0);
    }

    public void scrollToVisible(int row, int col) {
        if (this.getParent() instanceof JViewport) {
            JViewport viewport = (JViewport)this.getParent();
            Rectangle rect = this.getCellRect(row, col, true);
            Point pt = viewport.getViewPosition();
            rect.setLocation(rect.x - pt.x, rect.y - pt.y);
            viewport.scrollRectToVisible(rect);
        }
    }

    public Object getMVCModel() {
        return null;
    }

    public void refreshAddressBook(AbstractAddressBook addressBook) {
        if (this.abstractAddressBookTableModel == null || ((AddressBookTableModel)this.abstractAddressBookTableModel).getItemList() == null) {
            return;
        }
        int selectedRow = this.getSelectedRow();
        if (selectedRow != -1) {
            this.selectedContact = this.getSelectedEntry();
        }
        int n = this.selectedContactId = this.selectedContact != null ? this.selectedContact.getId() : -1;
        if (this.recipientsList != null && this.selectedContact instanceof IContact) {
            this.recipientsList.updateList((IContact)this.selectedContact);
        }
        this.updateItemList(addressBook, true);
        this.selectNearestRow(selectedRow);
        this.cellRenderer.clearCache();
    }

    private int[] getSelectedIndices() {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i : this.getSelectedRows()) {
            if (!(((AddressBookTableModel)this.abstractAddressBookTableModel).getItemAt(i) instanceof IContact)) continue;
            indices.add(i);
        }
        int[] result = new int[indices.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)indices.get(i);
        }
        return result;
    }

    public DropTargetListener createDropTargetListener() {
        return new ETDTListener();
    }

    protected void selectNearestRow(int theRow) {
        int index = theRow;
        int size = this.getRowCount();
        index = index >= size ? size - 1 : theRow;
        if (index != -1) {
            this.setRowSelectionInterval(index, index);
        }
    }

    public int getContactPosByContactId(int id) {
        int index = 0;
        IItemList itemList = ((AddressBookTableModel)this.abstractAddressBookTableModel).getItemList();
        for (int i = 0; i < itemList.getSize(); ++i) {
            IItem item = itemList.getItemAt(i);
            if (!(item instanceof IContact) || item.getId() != id) continue;
            index = i;
            break;
        }
        return index;
    }

    protected void selectModifiedContact(int contactId) {
        int index = contactId != -1 ? this.getContactPosByContactId(contactId) : 0;
        this.setRowSelectionInterval(index, index);
    }

    public void handle_REMOVE_ENTRY_FROM_RECIPIENTS_LIST(AppEvent theEvent) {
        List recipients = (List)theEvent.getData();
        int nCount = recipients.size();
        if (this.getController().getMVCView() instanceof AddressSelectorEntriesTable) {
            Set<String> movedEntries = ((AddressSelectorEntriesTable)this.getController().getMVCView()).getMovedEntries();
            for (int i = 0; i < nCount; ++i) {
                IRecipient recipient = (IRecipient)recipients.get(i);
                IAddressable addressable = recipient.getAddressable();
                if (!(addressable instanceof IContact)) continue;
                IContact contact = (IContact)addressable;
                String contactID = String.valueOf(contact.getId());
                movedEntries.remove(contactID);
                this.repaint();
            }
        }
    }

    public void handle_FOLDER_SELECTED(AbstractFolder folder) {
        MainGWFoldersTree tree = ((GWMainAppFrame)this.controller.getActionList().getMVCView()).getFoldersTree();
        if (!tree.isEditing()) {
            if (folder instanceof ContactsFolder) {
                this.setMVCModel(folder);
            } else {
                this.dispose();
            }
        }
    }

    protected void fireSelectionCommand(int selectedCount) {
        Command command = new Command(1050, selectedCount);
        this.getController().processCommand(command);
    }

    private class ABFocusListener
    extends FocusAdapter {
        private ABFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            Command command;
            AbstractAddressBookTable.this.controller.processCommand(new Command(1160, AbstractAddressBookTable.this));
            List<IAddressable> selectedContacts = AbstractAddressBookTable.this.getSelectedContacts();
            if (selectedContacts.size() > 0) {
                IItemList itemList = ((AddressBookTableModel)AbstractAddressBookTable.this.abstractAddressBookTableModel).getItemList();
                AbstractAddressBookTable.this.selectedEntries.clear();
                AbstractAddressBookTable.this.selectedEntries.addAll(selectedContacts);
                itemList.setSelection(MessageUtils.getItemsAsArray(selectedContacts));
                command = new Command(240, new SelectedContactsInfoImpl(itemList, selectedContacts));
            } else {
                command = new Command(270);
            }
            AbstractAddressBookTable.this.controller.processCommand(command);
        }
    }

    public class ABSelectionListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            List<IRecipient> selectedRecipients = AbstractAddressBookTable.this.getSelectedRecipients();
            int selectedCount = selectedRecipients.size();
            AbstractAddressBookTable.this.fireSelectionCommand(selectedCount);
            if (selectedCount > 0) {
                Command command = new Command(1930, selectedRecipients);
                AbstractAddressBookTable.this.getController().processCommand(command);
            }
        }
    }

    private class SearchKeyListener
    extends KeyAdapter {
        private SearchKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (Character.isLetterOrDigit(e.getKeyChar()) && !e.isAltDown()) {
                if (AbstractAddressBookTable.this.tfSearch == null) {
                    AbstractAddressBookTable.this.searchText.append(e.getKeyChar());
                    if (AbstractAddressBookTable.this.timer == null) {
                        AbstractAddressBookTable.this.timerAction = new TimerAction();
                        AbstractAddressBookTable.this.timer = new Timer(400, AbstractAddressBookTable.this.timerAction);
                        AbstractAddressBookTable.this.timer.setRepeats(false);
                    }
                    if (e.getKeyChar() != 'a' || e.getModifiers() != 2) {
                        AbstractAddressBookTable.this.timer.restart();
                    }
                } else {
                    try {
                        AbstractAddressBookTable.this.tfSearch.getDocument().insertString(AbstractAddressBookTable.this.tfSearch.getText().length(), String.valueOf(e.getKeyChar()), null);
                    }
                    catch (BadLocationException e1) {
                        logger.error((Object)e1);
                        logger.debug((Object)e1, (Throwable)e1);
                    }
                }
            }
        }
    }

    private class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            AbstractAddressBookTable.this.searchText.replace(0, AbstractAddressBookTable.this.searchText.length(), AbstractAddressBookTable.this.tfSearch.getText().substring(0, e.getOffset() + e.getLength()));
            if (AbstractAddressBookTable.this.searchText.length() > 0) {
                AbstractAddressBookTable.this.timer.restart();
            } else {
                AbstractAddressBookTable.this.timer.stop();
            }
        }

        public void removeUpdate(DocumentEvent e) {
            boolean isSelectedTextDeleted;
            AbstractAddressBookTable.this.searchText.replace(0, AbstractAddressBookTable.this.searchText.length(), AbstractAddressBookTable.this.tfSearch.getText().substring(0, e.getOffset()));
            int selectedTextLength = AbstractAddressBookTable.this.tfSearch.getSelectionEnd() - AbstractAddressBookTable.this.tfSearch.getSelectionStart();
            boolean bl = isSelectedTextDeleted = selectedTextLength == e.getLength() && AbstractAddressBookTable.this.tfSearch.getSelectionStart() == e.getOffset();
            if (AbstractAddressBookTable.this.searchText.length() > 0 && !isSelectedTextDeleted) {
                AbstractAddressBookTable.this.timer.restart();
            } else {
                AbstractAddressBookTable.this.timer.stop();
            }
        }

        public void changedUpdate(DocumentEvent e) {
        }
    }

    private class TimerAction
    implements ActionListener {
        private TimerAction() {
        }

        public void actionPerformed(ActionEvent e) {
            IItemList itemList = ((AddressBookTableModel)AbstractAddressBookTable.this.abstractAddressBookTableModel).getItemList();
            if (itemList != null && itemList.getSize() > 0) {
                int index = itemList.indexOf(AbstractAddressBookTable.this.searchText.toString(), 0);
                AbstractAddressBookTable.this.setStatusBarText(index == -1);
                if (index > itemList.getSize() - 1) {
                    index = itemList.getSize() - 1;
                }
                if (index >= 0 && itemList.getSize() > 0) {
                    IContact contact = (IContact)itemList.getItemAt(index);
                    String text = AbstractAddressBookTable.this.searchText.toString();
                    String match = contact.getStringValue(AbstractAddressBookTable.this.searchField);
                    int searchLen = AbstractAddressBookTable.this.searchText.length();
                    int matchLen = match.length();
                    AbstractAddressBookTable.this.setRowSelectionInterval(index, index);
                    AbstractAddressBookTable.this.scrollToVisible(index);
                    AbstractAddressBookTable.this.scrollToVisible(index);
                    if (matchLen >= searchLen && text.equalsIgnoreCase(match.substring(0, searchLen))) {
                        if (AbstractAddressBookTable.this.tfSearch != null) {
                            AbstractAddressBookTable.this.tfSearch.getDocument().removeDocumentListener(AbstractAddressBookTable.this.documentListener);
                            AbstractAddressBookTable.this.tfSearch.requestFocus();
                            AbstractAddressBookTable.this.tfSearch.setText(match);
                            AbstractAddressBookTable.this.tfSearch.select(searchLen, matchLen);
                            AbstractAddressBookTable.this.tfSearch.getDocument().addDocumentListener(AbstractAddressBookTable.this.documentListener);
                        } else {
                            AbstractAddressBookTable.this.searchText.delete(0, searchLen);
                        }
                    }
                }
            }
        }
    }

    private class ETDTListener
    extends DropTargetAdapter {
        private ETDTListener() {
        }

        public void dragOver(DropTargetDragEvent dtde) {
            if (!dtde.isDataFlavorSupported(GWFlavors.recipientsFlavor)) {
                dtde.rejectDrag();
            }
        }

        public void drop(DropTargetDropEvent dtde) {
            try {
                if (dtde.getTransferable().getTransferData(GWFlavors.recipientsFlavor) instanceof IRecipient[]) {
                    AppAction action = AbstractAddressBookTable.this.controller.getActionList().getAction(ActionKey.REMOVE_ENTRY_FROM_RECIPIENTS_LIST);
                    if (action != null) {
                        AbstractAddressBookTable.this.controller.getActionList().performAction(ActionKey.REMOVE_ENTRY_FROM_RECIPIENTS_LIST);
                    }
                } else {
                    dtde.rejectDrop();
                }
            }
            catch (UnsupportedFlavorException e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
            }
        }
    }

    private class TransferableData
    implements Transferable {
        private String userGuid;
        TransferItems transferItems;
        private DataFlavor[] dataFlavors = new DataFlavor[]{GWFlavors.contactsFlavor, GWFlavors.userGuidFlavor, GWFlavors.transferItemsFlavor, DataFlavor.stringFlavor};

        private TransferableData(TransferItems transferItems) {
            this.userGuid = ControlsUtils.getUserGuid(AbstractAddressBookTable.this.controller);
            this.transferItems = transferItems;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this.dataFlavors;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return Arrays.asList(this.dataFlavors).contains(flavor);
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!(AbstractAddressBookTable.this.getSelectedEntry() instanceof IContact)) {
                return null;
            }
            if (flavor.equals(DataFlavor.stringFlavor)) {
                return ((IContact)AbstractAddressBookTable.this.getSelectedEntry()).getDisplayName();
            }
            if (flavor.equals(GWFlavors.userGuidFlavor)) {
                return this.userGuid;
            }
            if (flavor.equals(GWFlavors.transferItemsFlavor)) {
                return this.transferItems;
            }
            List<IAddressable> contacts = AbstractAddressBookTable.this.getSelectedContacts();
            return SelectedContactsInfoImpl.getContacts(contacts).toArray(new IContact[contacts.size()]);
        }
    }

    private static class DSListener
    extends DragSourceAdapter {
        private int userAction;

        private DSListener() {
        }

        public void dragOver(DragSourceDragEvent dsde) {
            this.userAction = dsde.getUserAction();
            if (this.userAction == 1) {
                dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
            } else if (this.userAction == 2) {
                dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
            }
        }

        public void dropActionChanged(DragSourceDragEvent dsde) {
            this.userAction = dsde.getUserAction();
        }

        public void dragExit(DragSourceEvent dse) {
            if (this.userAction == 1) {
                dse.getDragSourceContext().setCursor(DragSource.DefaultCopyNoDrop);
            } else if (this.userAction == 2) {
                dse.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
            }
        }
    }

    private class DGListener
    implements DragGestureListener {
        private DGListener() {
        }

        public void dragGestureRecognized(DragGestureEvent dge) {
            if (dge.getTriggerEvent() instanceof MouseEvent && ((MouseEvent)dge.getTriggerEvent()).getButton() == 2) {
                return;
            }
            if ((dge.getDragAction() & 3) > 0) {
                TransferItems transferItems = ((AddressBookTableModel)AbstractAddressBookTable.this.abstractAddressBookTableModel).getItemList().getTransferItems(AbstractAddressBookTable.this.getSelectedIndices());
                dge.startDrag(DragSource.DefaultMoveNoDrop, new TransferableData(transferItems), new DSListener());
            }
        }
    }

    private class SelectionListener
    implements ListSelectionListener {
        private SelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            Command command;
            DefaultListSelectionModel selectionModel = (DefaultListSelectionModel)e.getSource();
            if (selectionModel.isSelectionEmpty()) {
                command = new Command(270);
            } else {
                List<IAddressable> selectedContacts = AbstractAddressBookTable.this.getSelectedContacts();
                if (selectedContacts == null || selectedContacts.size() == 0) {
                    command = new Command(270);
                } else {
                    IItemList itemList = ((AddressBookTableModel)AbstractAddressBookTable.this.abstractAddressBookTableModel).getItemList();
                    AbstractAddressBookTable.this.selectedEntries.clear();
                    AbstractAddressBookTable.this.selectedEntries.addAll(selectedContacts);
                    itemList.setSelection(MessageUtils.getItemsAsArray(selectedContacts));
                    command = new Command(240, new SelectedContactsInfoImpl(itemList, selectedContacts));
                }
            }
            AbstractAddressBookTable.this.getController().processCommand(command);
        }
    }
}

