/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.attachmentlist;

import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class TableViewModel
extends AbstractTableModel {
    private List items = new ArrayList();
    private String[] columnsName = new String[]{StringResources.NAME, StringResources.SIZE, StringResources.TYPE, StringResources.MODIFIED, ""};

    TableViewModel() {
    }

    public String getColumnName(int column) {
        return this.columnsName[column];
    }

    public int getRowCount() {
        return this.items.size();
    }

    public int getColumnCount() {
        return 4;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Object item = this.items.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return item;
            }
            case 1: {
                if (item instanceof GWAttachment) {
                    return String.valueOf(((GWAttachment)item).getNativeAttachment().getDisplaySize());
                }
                if (item instanceof AbstractItem) {
                    return String.valueOf(((AbstractItem)item).getNativeItem().getDisplaySize());
                }
            }
            case 2: {
                if (item instanceof GWAttachment) {
                    GWAttachment attachment = (GWAttachment)item;
                    if (attachment.getNativeAttachment() != null) {
                        return attachment.getNativeAttachment().getDisplayType();
                    }
                    return "";
                }
                if (item instanceof AbstractItem) {
                    AbstractItem attachment = (AbstractItem)item;
                    return attachment.getDisplayType();
                }
            }
            case 3: {
                if (item instanceof GWAttachment) {
                    GWAttachment attachment = (GWAttachment)item;
                    Date modified = attachment.getModified();
                    return modified != null ? OptionManager.getInstance().getDateTimeOptions().getGeneralDateString(modified) : "";
                }
                if (!(item instanceof AbstractItem)) break;
                AbstractItem attachment = (AbstractItem)item;
                Date modified = attachment.getDate();
                return modified != null ? OptionManager.getInstance().getDateTimeOptions().getGeneralDateString(modified) : "";
            }
        }
        return null;
    }

    public List getItems() {
        return this.items;
    }
}

