/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.busysearch;

import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.application.controls.busysearch.AvailableTimeGrid;
import com.novell.gw.jclient.application.controls.busysearch.BSScrollPane;
import com.novell.gw.jclient.application.controls.busysearch.BusySearchFrame;
import com.novell.gw.jclient.application.controls.busysearch.GWBusySearch;
import com.novell.gw.jclient.application.controls.busysearch.InfoPanel;
import com.novell.gw.jclient.application.controls.busysearch.RecipientDescription;
import com.novell.gw.jclient.application.controls.busysearch.RecipientTree;
import com.novell.gw.jclient.application.controls.gwcalendar.AbstractCalendarView;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AvailableWithTreePanel
extends AbstractCalendarView
implements MVCView {
    private AvailableTimeGrid.DayLabels busyDayLabels;
    private int daysCount = 7;
    private GWBusySearch busySearch;
    private RecipientTree recipientsTree;
    private AvailableTimeGrid availableTime;
    private JButton inviteButton = new OrientableButton();
    private MVCController controller;

    public AvailableWithTreePanel(GWBusySearch theBusySearch, JButton theInviteButton, MVCController theParentController) {
        this.busySearch = theBusySearch;
        this.inviteButton = theInviteButton;
        this.controller = theParentController;
        this.buildUI();
    }

    protected void refreshView() {
        if (!this.isShowing()) {
            this.wasViewRefreshed = true;
            return;
        }
        this.availableTime.setMVCModel(this.busySearch);
    }

    private void buildUI() {
        this.setLayout(new BorderLayout());
        this.availableTime = new AvailableTimeGrid(this.busySearch, this.controller);
        AvailableTimeGrid.HourLabels busyHourLabels = new AvailableTimeGrid.HourLabels();
        this.busyDayLabels = new AvailableTimeGrid.DayLabels(this.daysCount);
        this.busyDayLabels.setMinimumCellWidth(26);
        this.availableTime.setPreferredSize(new Dimension(Short.MAX_VALUE, this.availableTime.getPreferredSize().height));
        BSScrollPane sp = new BSScrollPane(this.availableTime);
        sp.setPreferredSize(new Dimension(550, this.availableTime.getPreferredSize().height));
        CompoundBorder border = BorderFactory.createCompoundBorder(BusySearchFrame.sideBorder, BusySearchFrame.lineBorder);
        sp.setBorder(BusySearchFrame.sideBorder);
        sp.setHorizontalScrollBarPolicy(32);
        sp.setRowHeaderView(busyHourLabels);
        sp.setColumnHeaderView(this.busyDayLabels);
        this.add((Component)sp, "Center");
        this.add((Component)this.buildRecipientTreePanel(), "After");
        InfoPanel infoAvailablePanel = new InfoPanel(this.controller);
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)infoAvailablePanel, "South");
        pnl.setBorder(border);
        this.add((Component)pnl, "South");
    }

    public void selectDefaultComponent() {
        this.availableTime.requestFocusInWindow();
    }

    public JComponent getDefaultComponent() {
        return this.availableTime;
    }

    public DefaultMutableTreeNode nodeForRecipient(RecipientDescription recipientDescription, TreeNode parent) {
        if (parent instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode mutableTreeNode = (DefaultMutableTreeNode)parent;
            if (recipientDescription.equals(mutableTreeNode.getUserObject())) {
                return mutableTreeNode;
            }
            Enumeration<? extends TreeNode> enumeration = parent.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode node = this.nodeForRecipient(recipientDescription, enumeration.nextElement());
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    public void removeRecipient(RecipientDescription recipientDescription) {
        TreeNode root = (TreeNode)this.recipientsTree.getModel().getRoot();
        DefaultMutableTreeNode node = this.nodeForRecipient(recipientDescription, root);
        if (node != null) {
            int count;
            DefaultTreeModel model = (DefaultTreeModel)this.recipientsTree.getModel();
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            int row = this.recipientsTree.getRowForPath(new TreePath(node.getPath()));
            model.removeNodeFromParent(node);
            if (parent.getChildCount() == 0) {
                row = this.recipientsTree.getRowForPath(new TreePath(parent.getPath()));
                model.removeNodeFromParent(parent);
            }
            if ((count = this.recipientsTree.getRowCount()) > 0) {
                if (row >= count) {
                    --row;
                }
                this.recipientsTree.setSelectionRow(row);
            }
        }
    }

    private JComponent buildRecipientTreePanel() {
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 3));
        this.recipientsTree = new RecipientTree(this.controller);
        this.recipientsTree.setBorder(BusySearchFrame.lineBorder);
        this.recipientsTree.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), "remove");
        this.recipientsTree.getActionMap().put("remove", new ActionRemoveRecipient());
        OrientableScrollPane scrollPane = new OrientableScrollPane(this.recipientsTree);
        this.inviteButton.setAlignmentX(0.5f);
        scrollPane.setAlignmentX(0.5f);
        result.add(this.inviteButton);
        result.add(Box.createRigidArea(new Dimension(10, 10)));
        result.add(scrollPane);
        result.setBorder(BusySearchFrame.sideBorder);
        return result;
    }

    public void setController(MVCController theController) {
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object theModel) {
        if (theModel instanceof GWBusySearch) {
            this.busySearch = (GWBusySearch)theModel;
            this.busyDayLabels.setDaysCount(this.busySearch.getDaysCount());
            this.busyDayLabels.setTitles(this.busySearch.getSearchStartTime(), null);
            this.refreshView();
        } else if (theModel instanceof TimeInterval) {
            this.busySearch.setAppointmentTime((TimeInterval)theModel);
            this.refreshView();
        }
    }

    public Object getMVCModel() {
        return null;
    }

    private class ActionRemoveRecipient
    extends AbstractAction {
        private ActionRemoveRecipient() {
        }

        public void actionPerformed(ActionEvent e) {
            Object userObject;
            Object o = AvailableWithTreePanel.this.recipientsTree.getLastSelectedPathComponent();
            if (o instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)o).getUserObject()) instanceof RecipientDescription) {
                RecipientDescription recipientDescription = (RecipientDescription)userObject;
                AvailableWithTreePanel.this.busySearch.removeRecipient(recipientDescription, AvailableWithTreePanel.this);
            }
        }
    }
}

