/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.busysearch;

import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.application.controls.busysearch.InfoPanelController;
import com.novell.gw.jclient.application.controls.busysearch.TimeBlockInfo;
import com.novell.gw.jclient.application.controls.gwcalendar.DateAndTimeFormattingUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.options.DateTimeOptions;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class InfoPanel
extends OrientablePanel
implements MVCView {
    private InfoPanelController infoPanelController;
    private Calendar gcStartDate = GWCalendarUtils.getToday();
    private JLabel lbStartDate;
    private JLabel lbStartTime;
    private JLabel lbDuration;
    private JLabel lbAvailable;
    private StringBuffer durationText = new StringBuffer();
    private String timeBlockInfoReasonText = "";
    private boolean isBusyShowing = false;

    public InfoPanel(MVCController theParentController) {
        super(new GridBagLayout());
        this.infoPanelController = new InfoPanelController(this, theParentController);
        this.buildUI();
        this.refreshView();
    }

    private void buildUI() {
        GridBagConstraints c = new GridBagConstraints();
        this.lbStartDate = new OrientableLabel();
        this.lbStartTime = new OrientableLabel();
        this.lbDuration = new OrientableLabel();
        this.lbAvailable = new OrientableLabel(StringResources.AVAILABLE);
        c.gridy = 0;
        c.anchor = 21;
        c.insets = new Insets(2, 10, 2, 10);
        this.add((Component)new OrientableLabel(StringResources.START_DATE_C), c);
        this.add((Component)this.lbStartDate, c);
        this.add((Component)new OrientableLabel(StringResources.START_TIME_C), c);
        this.add((Component)this.lbStartTime, c);
        c.gridy = 1;
        this.add((Component)new OrientableLabel(StringResources.DURATION_C), c);
        this.add((Component)this.lbDuration, c);
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.add((Component)this.lbAvailable, c);
        Border outside = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        TitledBorder inside = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), StringResources.DESIRED_TIME);
        this.setBorder(BorderFactory.createCompoundBorder(outside, inside));
    }

    protected void refreshView() {
        DateTimeOptions dateTimeOptions = OptionManager.getInstance().getDateTimeOptions();
        String date = DateAndTimeFormattingUtils.formatDate(this.gcStartDate.getTime(), dateTimeOptions.getDateFormat());
        this.lbDuration.setText(this.durationText.toString());
        String time = DateAndTimeFormattingUtils.formatDate(this.gcStartDate.getTime(), dateTimeOptions.getTimeFormat());
        this.lbStartTime.setText(time);
        this.lbStartDate.setText(date);
        this.lbAvailable.setText(this.timeBlockInfoReasonText);
    }

    public void setBusyShowing(boolean busyShowing) {
        this.isBusyShowing = busyShowing;
    }

    public void setAvailableTimeInterval(TimeBlockInfo theTimeBlockInfo) {
        this.gcStartDate.setTime(theTimeBlockInfo.getTimeInterval().getStartDateAsDate());
        long dur = (theTimeBlockInfo.getTimeInterval().getEndDate() - theTimeBlockInfo.getTimeInterval().getStartDate()) / 60000L;
        this.durationText.delete(0, this.durationText.length());
        if (dur >= 60L && dur < 120L) {
            this.durationText.append("1 ").append(StringResources.HOUR);
        } else if (dur >= 120L) {
            this.durationText.append(String.valueOf(dur / 60L)).append(' ').append(StringResources.HOURS);
        }
        if (dur % 60L != 0L) {
            this.durationText.append(" ").append(dur % 60L).append(' ').append(StringResources.MINUTES);
        }
        this.timeBlockInfoReasonText = theTimeBlockInfo.getReason().length() == 0 ? StringResources.AVAILABLE : (this.isBusyShowing ? theTimeBlockInfo.getReason() : "");
        this.refreshView();
    }

    public void setController(MVCController theController) {
        this.infoPanelController = (InfoPanelController)theController;
    }

    public MVCController getController() {
        return this.infoPanelController;
    }

    public void setMVCModel(Object theModel) {
        if (theModel instanceof TimeBlockInfo) {
            this.setAvailableTimeInterval((TimeBlockInfo)theModel);
        }
    }

    public Object getMVCModel() {
        return null;
    }
}

