/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.components;

import com.appframework.Tested;
import com.novell.gw.jclient.application.controls.components.ComponentInfluence;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.HashMap;

public class ComponentUtils {
    @Tested
    public static void propagateForeground(Color fg, Component component) {
        if (fg == null) {
            throw new IllegalArgumentException("fg is null");
        }
        if (component == null) {
            throw new IllegalArgumentException("component is null");
        }
        component.setForeground(fg);
        if (component instanceof Container) {
            Component[] children;
            for (Component child : children = ((Container)component).getComponents()) {
                ComponentUtils.propagateForeground(fg, child);
            }
        }
    }

    @Tested(completely=false)
    public static void changeComponent(Component component, ComponentInfluence influence) {
        if (component == null) {
            throw new IllegalArgumentException("component is null");
        }
        if (influence == null) {
            throw new IllegalArgumentException("influence is null");
        }
        switch (influence) {
            case FONT_UNDERLINED_ON: {
                HashMap<TextAttribute, Integer> attributes = new HashMap<TextAttribute, Integer>();
                attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                Font underlinedFont = component.getFont().deriveFont(attributes);
                component.setFont(underlinedFont);
                break;
            }
            case FONT_UNDERLINED_OFF: {
                HashMap<TextAttribute, Object> attributes = new HashMap<TextAttribute, Object>();
                attributes.put(TextAttribute.UNDERLINE, null);
                Font underlinedFont = component.getFont().deriveFont(attributes);
                component.setFont(underlinedFont);
                break;
            }
            default: {
                throw new IllegalStateException("unexpected influence encountered: " + (Object)((Object)influence));
            }
        }
    }
}

