/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.contactsearch;

import com.novell.gw.jclient.api.impl.ab.APIAbWrapperManager;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.controls.contactsearch.AddressSerializable;
import com.novell.gw.jclient.application.controls.contactsearch.AddressesTransferrable;
import com.novell.gw.jclient.application.controls.contactsearch.ContactSearchComboField;
import com.novell.gw.jclient.application.controls.contactsearch.ContactUtils;
import com.novell.gw.jclient.application.controls.contactsearch.RecipientList;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractAddressTransferHandler
extends TransferHandler {
    private final ContactSearchComboField comboField;
    private final RecipientList recipientList;

    public AbstractAddressTransferHandler(ContactSearchComboField comboField, RecipientList recipientList) {
        this.comboField = comboField;
        this.recipientList = recipientList;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        List<DataFlavor> flavors = Arrays.asList(transferFlavors);
        return flavors.contains(DataFlavor.stringFlavor) || flavors.contains(AddressesTransferrable.addressFlavor);
    }

    protected List<IRecipient> getRecipients(Transferable transferable) throws IOException, UnsupportedFlavorException {
        ArrayList<IRecipient> recipients;
        block3: {
            block2: {
                AddressSerializable[] addressSerializableList;
                recipients = new ArrayList<IRecipient>();
                if (!transferable.isDataFlavorSupported(AddressesTransferrable.addressFlavor)) break block2;
                for (AddressSerializable addressSerializable : addressSerializableList = (AddressSerializable[])transferable.getTransferData(AddressesTransferrable.addressFlavor)) {
                    recipients.add(APIAbWrapperManager.createRecipient(addressSerializable.getAddressable(), this.getComboField().getCopyType()));
                }
                break block3;
            }
            if (!transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) break block3;
            String text = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            List<String> names = ContactUtils.parse(text);
            for (String name : names) {
                recipients.add(APIAbWrapperManager.createRecipient(ContactUtils.getAddressForName(name), this.getComboField().getCopyType()));
            }
        }
        return recipients;
    }

    public ContactSearchComboField getComboField() {
        return this.comboField;
    }

    public RecipientList getRecipientList() {
        return this.recipientList;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return this.getComboField().isEditable() ? 3 : 1;
    }
}

