/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.contactsearch;

import com.novell.gw.ab.AddressBook;
import com.novell.gw.jclient.api.impl.ab.APIAbWrapperManager;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.application.controls.addressbook.SearchEvent;
import com.novell.gw.jclient.application.controls.addressbook.SearchResultListener;
import com.novell.gw.jclient.application.controls.components.TimerTextField;
import com.novell.gw.jclient.application.controls.contactsearch.ContactUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.gwcomponent.GWCutCopyPasteUndoPopup;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class ContactSearchTextField
extends TimerTextField {
    private static final Logger logger = Logger.getLogger(ContactSearchTextField.class);
    private static final int TOOL_TIP_SHOW_TIME = 1500;
    private Timer toolTipTimer;
    private JPopupMenu toolTipPopup;
    private JToolTip toolTip;
    private List<SearchResultListener> searchListeners = new LinkedList<SearchResultListener>();
    protected List<IContact> foundContacts = new ArrayList<IContact>();
    protected List<AddressBook> addressBooksForFind = new ArrayList<AddressBook>();
    protected String searchText;
    private int navigateIndex = 0;
    protected String initialValue = "";
    private boolean initialValueSet = false;

    public ContactSearchTextField() {
        this.iniToolTip();
        this.addKeyListener(new CSTFKeyListener());
        this.addFocusListener(new CSTFFocusListener());
        this.addMouseListener(new CSTFMouseListener());
        this.setDragEnabled(true);
    }

    private void iniToolTip() {
        Color color = ColorConstants.YELLOW;
        this.toolTip = this.createToolTip();
        this.toolTip.setBackground(color);
        this.toolTip.setBorder(null);
        this.toolTipTimer = new Timer(1500, new ToolTipAction());
        this.toolTipTimer.setRepeats(false);
        this.toolTipPopup = new JPopupMenu();
        this.toolTipPopup.setBorderPainted(false);
        this.toolTipPopup.add(this.toolTip);
        this.toolTipPopup.setFocusable(false);
        this.toolTipPopup.setBackground(color);
    }

    public void addSearchListener(SearchResultListener listener) {
        this.searchListeners.add(listener);
    }

    private void clearLastSearch() {
        this.searchText = null;
        this.foundContacts.clear();
        this.addressBooksForFind.clear();
        this.addressBooksForFind.addAll(Arrays.asList(EngineCommandManager.getAddressBookManager().getSearchOrder()));
        this.navigateIndex = 0;
    }

    protected void processTimerAction() {
        if (OptionManager.getInstance().getGeneralOptions().isDisabledNameCompletion()) {
            return;
        }
        if (this.getText().endsWith("@")) {
            return;
        }
        List<String> names = ContactUtils.parse(this.getText());
        if (names.isEmpty()) {
            return;
        }
        String text = names.get(0);
        IAddressable addressable = this.search(text);
        if (addressable != null && addressable instanceof IContact) {
            this.showToolTip(addressable);
            int startIndex = this.getCaretPosition();
            this.setText(ContactSearchTextField.getDisplayName(addressable));
            int endInxdex = this.getText().length();
            this.select(startIndex, endInxdex);
        }
    }

    public IContact getFoundContact() {
        if (this.foundContacts != null && !this.foundContacts.isEmpty()) {
            return this.foundContacts.get(this.navigateIndex);
        }
        return null;
    }

    public static String getDisplayName(IAddressable addressable) {
        String result = addressable.getDisplayName();
        if (result == null || result.equals("")) {
            result = addressable.getUserName();
        }
        if (result == null || result.equals("")) {
            result = addressable.getEmailAddress();
        }
        if (result == null || result.equals("")) {
            result = addressable.getFirstName();
        }
        return result != null ? result : "";
    }

    public static boolean isLastFirstNameFormat() {
        return EngineCommandManager.getAddressBookManager().getSystemAddressBook().getNameFormat() == 50093;
    }

    protected boolean isValidString(String str) {
        for (String delimeters : ContactUtils.DELIMETERS) {
            if (!delimeters.equals(str)) continue;
            return false;
        }
        String text = this.getText();
        if (text == null || text.equals("")) {
            return !str.equals(" ");
        }
        if (str.equals(",")) {
            String name = text + str;
            if (ContactSearchTextField.isLastFirstNameFormat()) {
                IContact contact = this.getFoundContact();
                if (contact == null) {
                    contact = ContactUtils.findContactByName(name);
                }
                return contact != null && contact.getDisplayName().startsWith(name);
            }
            return false;
        }
        return super.isValidString(str);
    }

    protected boolean isAcceptableContact(IContact contact) {
        return contact != null;
    }

    protected IAddressable search(String searchText) {
        IAddressable result;
        this.clearLastSearch();
        this.searchText = searchText;
        if (searchText.equals("*")) {
            result = APIAbWrapperManager.createAddress("*", "*");
        } else {
            IContact contact = ContactUtils.findContactByName(searchText);
            if (this.isAcceptableContact(contact)) {
                this.foundContacts.add(contact);
            }
            result = this.foundContacts != null && !this.foundContacts.isEmpty() ? (IAddressable)this.foundContacts.get(0) : ContactUtils.findContactByEmail(searchText);
        }
        if (result == null) {
            result = APIAbWrapperManager.createAddress(searchText, searchText);
        }
        return result;
    }

    protected void processSearchEvent(IAddressable addressable) {
        for (SearchResultListener listener : this.searchListeners) {
            listener.searchFinished(new SearchEvent(addressable));
        }
    }

    public void addRecipient() {
        String text = this.getText();
        if (!this.foundContacts.isEmpty()) {
            this.processSearchEvent(this.foundContacts.get(this.navigateIndex));
        } else {
            int length = text.length();
            this.select(length, length);
            List<String> strings = ContactUtils.parse(text);
            if (!strings.isEmpty()) {
                for (String s : strings) {
                    this.processSearchEvent(ContactUtils.getAddressForName(s));
                }
            }
        }
        this.clearLastSearch();
    }

    public boolean isDirty() {
        return !this.initialValue.equals(this.getText());
    }

    public String getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(String initialValue) {
        if (!this.initialValueSet) {
            this.initialValue = initialValue;
            this.initialValueSet = true;
        }
    }

    private void findContactsInNextAddressBook() {
        if (this.searchText == null || this.searchText.equals("")) {
            return;
        }
        boolean found = false;
        for (AddressBook addressBook : this.addressBooksForFind.toArray(new AddressBook[this.addressBooksForFind.size()])) {
            logger.debug((Object)("addressBook: " + addressBook.getName()));
            for (IContact contact : ContactUtils.findContactsByName(this.searchText, addressBook)) {
                if (this.foundContacts.contains(contact)) continue;
                logger.debug((Object)("contact: " + contact.getDisplayName()));
                this.foundContacts.add(contact);
                found = true;
            }
            this.addressBooksForFind.remove(addressBook);
            if (found) break;
        }
    }

    private IContact getNextContact() {
        if (this.navigateIndex >= this.foundContacts.size() - 1) {
            if (this.foundContacts.isEmpty()) {
                this.navigateIndex = 0;
            } else {
                this.findContactsInNextAddressBook();
                this.navigateIndex = this.navigateIndex >= this.foundContacts.size() - 1 ? 0 : ++this.navigateIndex;
            }
        } else {
            ++this.navigateIndex;
        }
        return this.foundContacts.get(this.navigateIndex);
    }

    private IContact getPrevContact() {
        this.navigateIndex = this.navigateIndex <= 0 ? this.foundContacts.size() - 1 : --this.navigateIndex;
        return this.foundContacts.get(this.navigateIndex);
    }

    private void showToolTip(IAddressable addressable) {
        String email;
        boolean isDisableQuickInfo = OptionManager.getInstance().getGeneralOptions().isDisableQuickInfo();
        if (!this.foundContacts.isEmpty() && !isDisableQuickInfo && this.isFocusOwner() && (email = addressable.getEmailAddress()) != null && !email.equals("")) {
            this.toolTip.setTipText(" " + StringResources.EMAIL_ADDRESS_C + " " + email + " ");
            this.toolTipPopup.show(this, 0, this.getHeight() + 2);
            this.toolTipTimer.restart();
        }
    }

    private void hideToolTip() {
        this.toolTipPopup.setVisible(false);
    }

    private class CSTFMouseListener
    extends MouseAdapter {
        private CSTFMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            ContactSearchTextField.this.hideToolTip();
        }
    }

    private class CSTFFocusListener
    extends FocusAdapter {
        private CSTFFocusListener() {
        }

        public void focusLost(FocusEvent e) {
            ContactSearchTextField.this.stopTimer();
            ContactSearchTextField.this.hideToolTip();
            if (!ContactSearchTextField.this.equals(GWCutCopyPasteUndoPopup.getInstance().getCutCopyPasteUndoable())) {
                ContactSearchTextField.this.select(0, 0);
            }
        }
    }

    private class ToolTipAction
    implements ActionListener {
        private ToolTipAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ContactSearchTextField.this.hideToolTip();
        }
    }

    private class CSTFKeyListener
    extends KeyAdapter {
        private CSTFKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            ContactSearchTextField.this.hideToolTip();
            String text = ContactSearchTextField.this.getText();
            if (text != null && !text.equals("")) {
                int key = e.getKeyCode();
                int selectionStart = ContactSearchTextField.this.getSelectionStart();
                String selectedText = ContactSearchTextField.this.getSelectedText();
                if (key == 10) {
                    ContactSearchTextField.this.addRecipient();
                    e.consume();
                }
                if (!ContactSearchTextField.this.foundContacts.isEmpty()) {
                    if (key == 38) {
                        IContact contact = ContactSearchTextField.this.getPrevContact();
                        String name = contact.getDisplayName();
                        ContactSearchTextField.this.showToolTip(contact);
                        ContactSearchTextField.this.setText(name);
                        ContactSearchTextField.this.select(selectionStart, name.length());
                    } else if (key == 40) {
                        IContact contact = ContactSearchTextField.this.getNextContact();
                        String name = contact.getDisplayName();
                        ContactSearchTextField.this.showToolTip(contact);
                        ContactSearchTextField.this.setText(name);
                        ContactSearchTextField.this.select(selectionStart, name.length());
                    } else {
                        ContactSearchTextField.this.clearLastSearch();
                    }
                    if (selectedText != null && !selectedText.equals("")) {
                        if (key == 127) {
                            ContactSearchTextField.this.setIgnoreNextTimerEvent();
                        }
                        if (key == 8) {
                            text = text.substring(0, selectionStart);
                            ContactSearchTextField.this.setText(text);
                        }
                    }
                }
            }
        }
    }
}

