/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.contactsearch;

import com.novell.gw.jclient.api.enums.ContactType;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.application.controls.contactsearch.ContactSearchTextField;

public class FilteredContactSearchTextField
extends ContactSearchTextField {
    private final ContactType typeForFiltering;
    private IContact initialContact;

    public FilteredContactSearchTextField(ContactType typeForFiltering) {
        if (typeForFiltering == null) {
            throw new IllegalArgumentException();
        }
        this.typeForFiltering = typeForFiltering;
    }

    protected boolean isAcceptableContact(IContact contact) {
        return super.isAcceptableContact(contact) && contact.getType().equals((Object)this.typeForFiltering);
    }

    public ContactType getTypeForFiltering() {
        return this.typeForFiltering;
    }

    public IContact getContact() {
        if (this.isDirty()) {
            return this.getFoundContact();
        }
        return this.initialContact;
    }

    public void setInitialValue(IContact initialValue) {
        if (initialValue == null) {
            return;
        }
        if (!this.isAcceptableContact(initialValue)) {
            throw new IllegalArgumentException("not acceptable initial value");
        }
        this.initialContact = initialValue;
        String name = initialValue.getDisplayName();
        this.setInitialValue(name);
        this.setText(name);
    }
}

