/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.contactsearch;

import com.novell.gw.jclient.api.impl.ab.APIAbWrapperManager;
import com.novell.gw.jclient.api.interfaces.ab.IAddress;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.api.interfaces.ab.IOrganizationContact;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.controls.contactsearch.ContactUtils;
import com.novell.gw.jclient.application.controls.contactsearch.RecipientListChangeListener;
import com.novell.gw.jclient.application.controls.popedit.DisambiguationDialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JDialog;
import javax.swing.JFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecipientListModel
extends AbstractListModel {
    private List<IRecipient> recipients = new ArrayList<IRecipient>();
    private Comparator<IRecipient> comparator = new RecipientComparator();
    private List<RecipientListChangeListener> recipientListChangeListeners = new LinkedList<RecipientListChangeListener>();
    private Window parentWindow;

    public RecipientListModel(Window window) {
        this.parentWindow = window;
    }

    @Override
    public int getSize() {
        return this.recipients.size();
    }

    @Override
    public Object getElementAt(int index) {
        if (index >= 0 && index < this.recipients.size()) {
            return this.recipients.get(index);
        }
        return null;
    }

    void addRecipientListChangeListener(RecipientListChangeListener listener) {
        this.recipientListChangeListeners.add(listener);
    }

    void removeRecipientListChangeListener(RecipientListChangeListener listener) {
        this.recipientListChangeListeners.remove(listener);
    }

    public int getIndexOf(IRecipient recipient) {
        return this.recipients.indexOf(recipient);
    }

    public void setRecipients(List<IRecipient> recipients) {
        this.recipients.clear();
        this.recipients.addAll(recipients);
        Collections.sort(this.recipients, this.comparator);
        this.fireContentsChanged(this, 0, recipients.size());
    }

    private void fireRecipientListChanged() {
        for (RecipientListChangeListener listener : this.recipientListChangeListeners) {
            listener.recipientListChanged(this.recipients);
        }
    }

    @Override
    protected void fireIntervalAdded(Object source, int index0, int index1) {
        super.fireIntervalAdded(source, index0, index1);
        this.fireRecipientListChanged();
    }

    @Override
    protected void fireIntervalRemoved(Object source, int index0, int index1) {
        super.fireIntervalRemoved(source, index0, index1);
        this.fireRecipientListChanged();
    }

    @Override
    protected void fireContentsChanged(Object source, int index0, int index1) {
        super.fireContentsChanged(source, index0, index1);
        this.fireRecipientListChanged();
    }

    public int addRecipients(List<IRecipient> recipients) {
        for (IRecipient recipient : recipients) {
            if (this.containsRecipient(recipient)) continue;
            this.recipients.add(recipient);
        }
        Collections.sort(this.recipients, this.comparator);
        int selectedIndex = -1;
        if (!recipients.isEmpty() && (selectedIndex = this.recipients.indexOf(recipients.get(recipients.size() - 1))) >= 0) {
            this.fireIntervalAdded(this, selectedIndex, selectedIndex + 1);
        }
        return selectedIndex;
    }

    public int addRecipient(IRecipient recipient) {
        if (!DisambiguationDialog.isOneVisibled()) {
            if (recipient == null) {
                throw new NullPointerException();
            }
            this.addRecipientsCheckSame(recipient);
            Collections.sort(this.recipients, this.comparator);
            int selectedIndex = this.recipients.indexOf(recipient);
            if (selectedIndex < 0 && this.recipients.size() > 0) {
                selectedIndex = 0;
            }
            if (selectedIndex >= 0) {
                this.fireIntervalAdded(this, selectedIndex, selectedIndex + 1);
            }
            return selectedIndex;
        }
        return 0;
    }

    private void addRecipientsCheckSame(IRecipient recipient) {
        String s = recipient.getAddressable().getDisplayName();
        List<IContact> contactsList = ContactUtils.findContactsByName(s);
        if (contactsList.size() > 1) {
            IContact contact;
            ArrayList<IContact> sameContacts = new ArrayList<IContact>();
            sameContacts.add(contactsList.get(0));
            String name = contactsList.get(0).getDisplayName();
            for (int i = 1; i < contactsList.size() && !((contact = contactsList.get(i)) instanceof IOrganizationContact) && name.equals(contactsList.get(i).getDisplayName()); ++i) {
                sameContacts.add(contactsList.get(i));
            }
            if (sameContacts.size() < 2) {
                if (!this.containsRecipient(recipient)) {
                    this.recipients.add(recipient);
                }
                return;
            }
            DisambiguationDialog dialog = this.parentWindow instanceof Frame ? new DisambiguationDialog((JFrame)this.parentWindow, sameContacts) : new DisambiguationDialog((JDialog)this.parentWindow, sameContacts);
            dialog.showMe();
            if (dialog.isActionCompleteSuccessfully()) {
                List res = dialog.getSelectedContacts();
                for (Object o : res) {
                    if (this.containsRecipient(APIAbWrapperManager.createRecipient((IContact)o, recipient.getCopyType()))) continue;
                    this.recipients.add(APIAbWrapperManager.createRecipient((IContact)o, recipient.getCopyType()));
                }
            }
        } else if (!this.containsRecipient(recipient)) {
            this.recipients.add(recipient);
        }
    }

    private boolean containsRecipient(IRecipient theRecipient) {
        int nSize = this.recipients.size();
        for (int i = 0; i < nSize; ++i) {
            IAddressable addressable;
            IRecipient recipient = this.recipients.get(i);
            if (!recipient.isSameAddress(addressable = theRecipient.getAddressable())) continue;
            if (recipient.getAddressable() instanceof IAddress && addressable instanceof IContact) {
                this.recipients.remove(recipient);
                return false;
            }
            return true;
        }
        return false;
    }

    public int removeRecipients(List<IRecipient> recipients) {
        int index = this.recipients.indexOf(recipients.get(0));
        if (this.recipients.removeAll(recipients)) {
            this.fireIntervalRemoved(this, 0, this.recipients.size());
            return index;
        }
        return -1;
    }

    public int removeRecipient(IRecipient recipient) {
        int index = this.recipients.indexOf(recipient);
        this.recipients.remove(recipient);
        this.fireIntervalRemoved(this, 0, this.getSize());
        return index;
    }

    public void removeAllRecipients() {
        this.recipients.clear();
        this.fireIntervalRemoved(this, 0, this.getSize());
    }

    public List<IRecipient> getRecipients() {
        return this.recipients;
    }

    public boolean isEmpty() {
        return this.recipients.isEmpty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RecipientComparator
    implements Comparator<IRecipient> {
        private RecipientComparator() {
        }

        @Override
        public int compare(IRecipient recipient1, IRecipient recipient2) {
            return recipient1.getAddressable().getDisplayName().compareTo(recipient2.getAddressable().getDisplayName());
        }
    }
}

