/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.filter;

import com.appframework.ApplicationFrame;
import com.appframework.mvc.MVCController;
import com.novell.gw.engine.Filter;
import com.novell.gw.engine.ItemListFilter;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.GWMainAppFrameActionList;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialog;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import org.apache.log4j.Logger;

public abstract class AbstractViewFiltersDialog
extends GWDialog {
    private static Logger logger = Logger.getLogger(AbstractViewFiltersDialog.class);
    protected MVCController parentController;
    protected JList listFilters = new JList(new FilterListModel());
    protected JTextArea talistDescription;
    protected JCheckBox cbPutOnMenu;
    protected ArrayList<ItemListFilter> arrFilter;
    protected ArrayList<Boolean> arrShowOn;
    protected IDataStore dataStore;

    public AbstractViewFiltersDialog() {
        this.init();
    }

    public AbstractViewFiltersDialog(ApplicationDialog dialog) {
        super(dialog);
        this.parentController = dialog.getController();
        this.init();
    }

    public AbstractViewFiltersDialog(GWDialog theDialog) {
        super(theDialog);
        this.parentController = theDialog.getController();
        this.init();
    }

    public AbstractViewFiltersDialog(ApplicationFrame frame) {
        super(frame);
        this.parentController = frame.getController();
        this.init();
    }

    private void init() {
        this.btnOK = new JButton(new OkAction());
        this.setDefaultButton(this.btnOK);
        this.talistDescription = new JTextArea(1, 4);
        this.talistDescription.setEditable(false);
        this.talistDescription.setBackground(this.getBackground());
        this.talistDescription.setLineWrap(true);
        this.talistDescription.setWrapStyleWord(true);
        this.arrFilter = new ArrayList();
        this.arrShowOn = new ArrayList();
        this.dataStore = EngineCommandManager.getInstance(EngineCommandManager.getUserGuid()).getCurrentDataStore();
        boolean isContact = false;
        if (this.parentController.getActionList() instanceof GWMainAppFrameActionList) {
            isContact = ((GWMainAppFrame)((GWMainAppFrameActionList)this.parentController.getActionList()).getMVCView()).getFolder().isContactsFolder();
        }
        int filterType = isContact ? 2 : 0;
        int count = this.dataStore.getSavedFilterCount(filterType);
        for (int i = 0; i < count; ++i) {
            ItemListFilter itemfilter = this.dataStore.getSavedFilter(filterType, i);
            this.arrFilter.add(itemfilter);
            this.arrShowOn.add(itemfilter.getShowOnMenu());
        }
        ((FilterListModel)this.listFilters.getModel()).setFilters(this.arrFilter);
        this.listFilters.setSelectionMode(0);
        this.cbPutOnMenu = new OrientableCheckBox(StringResources.PUT_ON_MENU);
        this.updateFilterList();
    }

    protected abstract void performOkAction();

    void updateFilterList() {
        ((FilterListModel)this.listFilters.getModel()).setFilters(this.arrFilter);
        this.listFilters.revalidate();
        this.listFilters.repaint();
    }

    JCheckBox getPutOnMenuButton() {
        return this.cbPutOnMenu;
    }

    protected JButton getBtnOk() {
        return this.btnOK;
    }

    public void valueChanged(boolean changeCbPutOn) {
        if (this.listFilters.getModel().getSize() != 0 && this.listFilters.getSelectedIndex() < this.listFilters.getModel().getSize() && this.listFilters.getSelectedValue() instanceof String) {
            this.talistDescription.selectAll();
            int selIndex = this.listFilters.getSelectedIndex();
            ItemListFilter itemfilter = this.arrFilter.get(selIndex);
            if (changeCbPutOn) {
                this.cbPutOnMenu.setSelected(this.arrShowOn.get(selIndex));
            }
            this.talistDescription.setText(new Filter(this.dataStore.getNativeDataStore(), itemfilter, false).generateDescription());
        }
    }

    private static class FilterListModel
    implements ListModel {
        private Collection filters = new ArrayList();

        public void setFilters(Collection theFilters) {
            this.filters = theFilters;
        }

        public int getSize() {
            return this.filters.size();
        }

        public Object getElementAt(int index) {
            return ((ItemListFilter)this.filters.toArray()[index]).getName();
        }

        public void addListDataListener(ListDataListener l) {
        }

        public void removeListDataListener(ListDataListener l) {
        }
    }

    private class OkAction
    extends AbstractAction {
        public OkAction() {
            super(StringResources.OK);
        }

        public void actionPerformed(ActionEvent e) {
            AbstractViewFiltersDialog.this.setActionCompleteSuccessfully(true);
            AbstractViewFiltersDialog.this.performOkAction();
            GWDialog.disposeDialog(AbstractViewFiltersDialog.this);
        }
    }
}

