/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.filter;

import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.commands.AttributeKey;
import com.novell.gw.jclient.application.controls.addressbook.ABUtils;
import com.novell.gw.jclient.application.controls.filter.QuickFilter;
import com.novell.gw.jclient.application.controls.panelviews.ILVPPanelContent;
import com.novell.gw.jclient.application.controls.panelviews.PanelView;
import com.novell.gw.jclient.bl.om.filter.Filter;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.ContactsFolder;
import org.apache.log4j.Logger;

public class QuickFilterPanelModel {
    private static Logger logger = Logger.getLogger(QuickFilterPanelModel.class);
    private AbstractFolder folder = null;
    private Filter filter = null;
    private MVCController controller;
    private PanelView panel = null;

    public QuickFilterPanelModel(MVCController controller) {
        if (controller == null) {
            throw new IllegalArgumentException("controller is null");
        }
        this.controller = controller;
    }

    public AbstractFolder getFolder() {
        return this.folder;
    }

    void setFolder(AbstractFolder folder) {
        logger.debug((Object)("----- folder: " + folder));
        this.panel = null;
        boolean clearFilter = false;
        if (this.folder == null) {
            clearFilter = false;
        } else if (folder == null) {
            clearFilter = true;
        } else if (folder.getDisplaySettings().getViewMode() == 8 || this.folder.getDisplaySettings().getViewMode() == 8) {
            clearFilter = true;
        } else if (folder instanceof ContactsFolder != this.folder instanceof ContactsFolder) {
            clearFilter = true;
        }
        if (clearFilter) {
            this.setFilter(null);
        }
        this.folder = folder;
    }

    public Filter getFilter() {
        return this.filter;
    }

    void setFilter(Filter filter) {
        logger.debug((Object)("----- filter: " + filter));
        this.filter = filter;
    }

    void panelSelected(PanelView panel) {
        assert (panel != null) : "panel is null";
        this.panel = panel;
        this.filter = this.panel.getPanelContent() instanceof ILVPPanelContent ? ((ILVPPanelContent)this.panel.getPanelContent()).getFilter() : null;
    }

    void quickFilterTextChanged(String text) {
        if (Utils.isNullOrEmpty(text)) {
            if (this.filter instanceof QuickFilter) {
                ((QuickFilter)this.filter).setText(text);
                if (this.filter.isEmpty()) {
                    this.filter = null;
                }
            }
        } else {
            AbstractFolder filteredFolder = this.folder;
            if (this.panel != null) {
                if (!this.panel.getPanelContent().hasItemList()) {
                    return;
                }
                filteredFolder = this.panel.getPanelFolder();
            }
            boolean isContactFolder = filteredFolder instanceof ContactsFolder;
            if (this.filter instanceof QuickFilter) {
                ((QuickFilter)this.filter).setText(text);
            } else {
                this.filter = new QuickFilter(text, isContactFolder);
            }
            if (isContactFolder) {
                ((QuickFilter)this.filter).setSystem(ABUtils.isSystemABAbstractFolder(filteredFolder));
            }
        }
        this.fireFilterChangedEvent();
    }

    void clearFilter() {
        this.filter = null;
        this.fireFilterChangedEvent();
    }

    private void fireFilterChangedEvent() {
        Command command = new Command(400, this.filter);
        command.setAttribute((Object)AttributeKey.SOURCE, this);
        this.controller.processCommand(command);
    }
}

