/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.folderstree;

import com.appframework.ApplicationFrame;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.actions.componentrelated.ActionFoldersTree;
import com.novell.gw.jclient.application.controls.folderstree.GWFoldersTree;
import com.novell.gw.jclient.application.controls.folderstree.MainGWFoldersTree;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.SubCalendarFolder;
import java.awt.Component;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GWFoldersTreeController<T extends GWFoldersTree>
extends MVCController<T> {
    private static Logger logger = Logger.getLogger(GWFoldersTreeController.class);

    public GWFoldersTreeController(T view, MVCController theParentController) {
        super(view, theParentController, ActionFoldersTree.class);
    }

    public T getGWFoldersTree() {
        return (T)((GWFoldersTree)this.getMVCView());
    }

    @Override
    protected void initListeners() {
        Level level = this.getFrameLevel();
        AppEventListener listener = new RELOAD_TREE_listener();
        AppEventListenerDescriptor descriptor = new AppEventListenerDescriptor(level, 810, listener);
        this.addListenerDescriptor(descriptor);
        listener = new REFRESH_TREE_listener();
        descriptor = new AppEventListenerDescriptor(level, 200, listener);
        this.addListenerDescriptor(descriptor);
        listener = new FOLDER_CREATED_listener();
        descriptor = new AppEventListenerDescriptor(level, 1470, listener);
        this.addListenerDescriptor(descriptor);
        listener = new FOLDER_DOUBLE_CLICKED_listener();
        descriptor = new AppEventListenerDescriptor(level, 40, listener);
        this.addListenerDescriptor(descriptor);
        listener = new REPAINT_FOLDERS_TREE_listener();
        descriptor = new AppEventListenerDescriptor(level, 540, listener);
        this.addListenerDescriptor(descriptor);
        listener = new WINDOW_CLOSED_Listener();
        descriptor = new AppEventListenerDescriptor(level, 490, listener);
        this.addListenerDescriptor(descriptor);
    }

    private class WINDOW_CLOSED_Listener
    extends AppEventListener {
        private WINDOW_CLOSED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            Object tree;
            ApplicationFrame frame = (ApplicationFrame)theEvent.getData();
            if (frame.getController() == null) {
                return;
            }
            Level frameLevel = frame.getController().getLevel();
            Level myFrameLevel = GWFoldersTreeController.this.getFrameLevel();
            if (myFrameLevel.equals(frameLevel) && (tree = GWFoldersTreeController.this.getGWFoldersTree()) != null) {
                ((GWFoldersTree)tree).clear();
            }
        }
    }

    private class REPAINT_FOLDERS_TREE_listener
    extends AppEventListener {
        private REPAINT_FOLDERS_TREE_listener() {
        }

        public void handle(AppEvent theEvent) {
            ((Component)GWFoldersTreeController.this.getGWFoldersTree()).repaint();
        }
    }

    private class FOLDER_DOUBLE_CLICKED_listener
    extends AppEventListener {
        private FOLDER_DOUBLE_CLICKED_listener() {
        }

        public void handle(AppEvent theEvent) {
            Object commandObject = theEvent.getData();
            if (commandObject instanceof AbstractFolder) {
                AbstractFolder folder = (AbstractFolder)commandObject;
                ((GWFoldersTree)GWFoldersTreeController.this.getGWFoldersTree()).selectFolder(folder);
            }
        }
    }

    private class FOLDER_CREATED_listener
    extends AppEventListener {
        private FOLDER_CREATED_listener() {
        }

        public void handle(AppEvent theEvent) {
            Object commandObject = theEvent.getData();
            if (commandObject instanceof AbstractFolder) {
                ((GWFoldersTree)GWFoldersTreeController.this.getGWFoldersTree()).expandFolder(((AbstractFolder)commandObject).getParent());
                if (commandObject instanceof SubCalendarFolder && GWFoldersTreeController.this.getGWFoldersTree() instanceof MainGWFoldersTree) {
                    ((GWFoldersTree)GWFoldersTreeController.this.getGWFoldersTree()).selectFolder((AbstractFolder)commandObject);
                }
            }
        }
    }

    private class REFRESH_TREE_listener
    extends AppEventListener {
        private REFRESH_TREE_listener() {
        }

        public void handle(AppEvent theEvent) {
            ((GWFoldersTree)GWFoldersTreeController.this.getGWFoldersTree()).refreshTree(false);
        }
    }

    private class RELOAD_TREE_listener
    extends AppEventListener {
        private RELOAD_TREE_listener() {
        }

        public void handle(AppEvent theEvent) {
            ((GWFoldersTree)GWFoldersTreeController.this.getGWFoldersTree()).refreshTree(true);
        }
    }
}

