/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.folderstree;

import com.appframework.resources.GWIcons;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.LookAndFeelManager;
import com.novell.gw.jclient.application.controls.folderstree.GWFoldersTreeOrientablePanelRenderer;
import com.novell.gw.jclient.application.controls.folderstree.TextTreeRenderer;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.CalendarFolder;
import com.novell.gw.jclient.bl.om.folders.SentItemsFolder;
import com.novell.gw.jclient.bl.om.folders.SubCalendarFolder;
import com.novell.gw.jclient.bl.om.folders.TrashFolder;
import com.novell.gw.jclient.bl.om.folders.UserFolder;
import com.novell.gw.jclient.bl.om.folders.WorkinProgressFolder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class GWFoldersTreeRendererColor
extends DefaultTreeCellRenderer
implements TextTreeRenderer {
    private boolean treeHasFocus = false;
    private boolean selected;
    protected boolean selectDragedFolder;
    protected boolean selectPopupFolder;
    private OrientableLabel lbName;
    private OrientableLabel lbCount;
    private OrientableLabel lbUnOpenedItems;
    private OrientableLabel lbbefore;
    private Color activeSelectionBackground = UIManager.getColor("Tree.selectionBackground");
    private Color activeSelectionForeground = UIManager.getColor("Tree.selectionForeground");
    private Color inactiveSelectionBackground;
    private static final Color DEFAULT_BACKGROUND = Color.WHITE;
    private static final Color DEFAULT_FOREGROUND = Color.BLACK;
    private static final Color COMMON_COUNT_COLOR = new Color(0, 178, 180);
    private static final Color TRASH_AND_WIP_COUNT_COLOR = new Color(180, 0, 0);
    public static final Color BOX_COLOR = new Color(8, 36, 106);
    protected GWFoldersTreeOrientablePanelRenderer panel;

    public GWFoldersTreeRendererColor() {
        this.lbName = new SelectionLabel();
        this.lbCount = new OrientableLabel();
        this.lbUnOpenedItems = new OrientableLabel();
        this.panel = new GWFoldersTreeOrientablePanelRenderer();
        this.lbName.setBorder(BorderFactory.createEmptyBorder());
        this.lbCount.setBorder(BorderFactory.createEmptyBorder());
        if (LookAndFeelManager.isGtkLookAndFeel()) {
            this.lbCount.setOpaque(true);
            this.lbUnOpenedItems.setOpaque(true);
        }
        this.lbbefore = new OrientableLabel();
        this.lbbefore.setOpaque(true);
        this.lbUnOpenedItems.setBorder(BorderFactory.createEmptyBorder());
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = 0;
        constraints.weighty = 1.0;
        constraints.fill = 3;
        if (LookAndFeelManager.isGtkLookAndFeel()) {
            this.panel.add((Component)this.lbbefore, constraints);
        }
        this.panel.add((Component)this.lbUnOpenedItems, constraints);
        this.panel.add((Component)this.lbName, constraints);
        this.panel.add((Component)this.lbCount, constraints);
        this.inactiveSelectionBackground = UIManager.getColor("Tree.textBackground");
    }

    public int getTextX() {
        int width = 20;
        if (this.lbUnOpenedItems.getIcon() != null) {
            width += 16;
        }
        return width;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.treeHasFocus = hasFocus;
        this.panel.setForeground(DEFAULT_FOREGROUND);
        this.panel.setBackground(DEFAULT_BACKGROUND);
        Object userobject = ((DefaultMutableTreeNode)value).getUserObject();
        if (userobject instanceof AbstractFolder) {
            Font font;
            AbstractFolder folder = (AbstractFolder)userobject;
            String name = folder.getName() + ' ';
            if (!folder.isExist()) {
                font = this.lbName.getFont().deriveFont(1);
                this.lbName.setFont(font);
            } else {
                font = this.lbName.getFont().deriveFont(0);
                this.lbName.setFont(font);
            }
            this.lbName.setText(name);
            this.updateCountLabel(folder);
            Icon emptyIcon = null;
            if (!PLAFChanger.isCustomFolderTreeUIUsed()) {
                emptyIcon = GWIcons.EMPTY_ICON;
            }
            if (folder instanceof SentItemsFolder) {
                if (folder.hasUnreadItems(!expanded)) {
                    this.lbUnOpenedItems.setIcon(ImageResources.ICON_UNSENT_ITEMS);
                } else {
                    this.lbUnOpenedItems.setIcon(emptyIcon);
                }
            } else if (folder instanceof CalendarFolder) {
                if (folder.hasUnreadItems(!expanded)) {
                    this.lbUnOpenedItems.setIcon(ImageResources.ICON_CLOCK_CAL_ITEMS);
                } else {
                    this.lbUnOpenedItems.setIcon(emptyIcon);
                }
            } else if (folder.hasUnreadItems(!expanded) && !(folder instanceof TrashFolder) && !(folder instanceof SubCalendarFolder) && !(folder instanceof UserFolder)) {
                this.lbUnOpenedItems.setIcon(ImageResources.ICON_UNOPENED_ITEMS);
            } else {
                this.lbUnOpenedItems.setIcon(emptyIcon);
                if (LookAndFeelManager.isGtkLookAndFeel() && folder instanceof SubCalendarFolder) {
                    this.lbUnOpenedItems.setIcon(null);
                }
            }
            if (LookAndFeelManager.isGtkLookAndFeel()) {
                if (this.lbUnOpenedItems.getIcon() != null) {
                    int widthUnOpen = this.lbUnOpenedItems.getIcon().getIconWidth();
                    if (widthUnOpen > 15) {
                        this.lbbefore.setPreferredSize(new Dimension(0, 0));
                    } else {
                        this.lbbefore.setPreferredSize(new Dimension(16 - widthUnOpen, 0));
                    }
                } else {
                    this.lbbefore.setPreferredSize(new Dimension(0, 0));
                }
            }
        } else {
            this.lbName.setText(userobject.toString());
        }
        if (LookAndFeelManager.isGtkLookAndFeel()) {
            if (isSelected) {
                this.lbCount.setBackground(UIManager.getColor("Tree.selectionBackground"));
                this.lbUnOpenedItems.setBackground(UIManager.getColor("Tree.selectionBackground"));
                this.lbName.setForeground(UIManager.getColor("Tree.selectionForeground"));
                this.lbbefore.setBackground(UIManager.getColor("Tree.selectionBackground"));
            } else {
                this.lbUnOpenedItems.setBackground(DEFAULT_BACKGROUND);
                this.lbCount.setBackground(DEFAULT_BACKGROUND);
                this.lbbefore.setBackground(DEFAULT_BACKGROUND);
                this.lbName.setForeground(UIManager.getColor("Label.foreground"));
            }
        }
        if (hasFocus) {
            this.lbName.setBackground(this.activeSelectionBackground);
            this.lbName.setForeground(this.activeSelectionForeground);
        } else {
            this.lbName.setBackground(DEFAULT_BACKGROUND);
            this.lbName.setForeground(DEFAULT_FOREGROUND);
        }
        this.selected = isSelected;
        Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
        if (userObject instanceof AbstractFolder) {
            this.setNodeIcon(ControlsUtils.getImageForFolder((AbstractFolder)userObject, false));
        }
        if (this.lbUnOpenedItems.getIcon() != null) {
            this.panel.setWidthUnOpen(this.lbUnOpenedItems.getIcon().getIconWidth());
        }
        return this.panel;
    }

    public void setNodeIcon(ImageIcon theIcon) {
        this.lbName.setIcon(theIcon);
    }

    public void setTreeFocused(boolean b) {
        this.treeHasFocus = b;
    }

    private void updateCountLabel(AbstractFolder theFolder) {
        this.lbCount.setForeground(theFolder instanceof TrashFolder | theFolder instanceof WorkinProgressFolder ? TRASH_AND_WIP_COUNT_COLOR : COMMON_COUNT_COLOR);
        this.lbCount.setText(theFolder.getDisplayCountString());
    }

    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        preferredSize.height = PLAFChanger.getTreeRowHeight();
        return preferredSize;
    }

    private class SelectionLabel
    extends OrientableLabel {
        public SelectionLabel() {
            this.setBorder(BorderFactory.createLineBorder(Color.red));
        }

        public void paint(Graphics g) {
            boolean isLeftToRight = this.getComponentOrientation().isLeftToRight();
            GWFoldersTreeRendererColor r = GWFoldersTreeRendererColor.this;
            Color background = DEFAULT_BACKGROUND;
            if (r.selected) {
                Color color = background = r.treeHasFocus ? r.activeSelectionBackground : r.inactiveSelectionBackground;
            }
            if (LookAndFeelManager.isGtkLookAndFeel()) {
                background = UIManager.getColor("Tree.selectionBackground");
            }
            int iconOffset = 0;
            Icon icon = this.getIcon();
            if (icon != null && !LookAndFeelManager.isGtkLookAndFeel()) {
                iconOffset = icon.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
            }
            g.setColor(background);
            if (r.selected) {
                g.fillRect(isLeftToRight ? iconOffset : 0, 0, this.getWidth() - iconOffset, this.getHeight());
                if (!LookAndFeelManager.isGtkLookAndFeel()) {
                    g.setColor(BOX_COLOR);
                    this.paintBox(g, isLeftToRight, iconOffset);
                }
            }
            if (r.hasFocus() && GWFoldersTreeRendererColor.this.treeHasFocus || r.selectPopupFolder) {
                g.setColor(background.darker());
                this.paintBox(g, isLeftToRight, iconOffset);
            }
            super.paint(g);
        }

        private void paintBox(Graphics g, boolean leftToRight, int iconOffset) {
            g.drawRect(leftToRight ? iconOffset : 0, 0, this.getWidth() - 1 - iconOffset, this.getHeight() - 1);
        }
    }
}

