/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.folderstree;

import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.folderstree.TextTreeRenderer;
import com.novell.gw.jclient.application.controls.folderstree.TreeUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class GWTree
extends JTree
implements Autoscroll {
    private Popup popupTip = null;
    private String toolTipText;
    private JLabel tip;
    protected int row_height = this.getRowHeight();
    protected int lastSelectedRow = -1;
    private boolean popupContainerCloseDisabled = false;

    public String getUIClassID() {
        if (OS.isNimbusLAF()) {
            return GWTree.class.getSimpleName();
        }
        return super.getUIClassID();
    }

    public GWTree() {
        this.initToolTips();
    }

    private void initToolTips() {
        this.tip = new OrientableLabel();
        this.tip.setOpaque(true);
        this.tip.setVerticalTextPosition(0);
        this.tip.setHorizontalTextPosition(0);
        this.tip.setBackground(ColorConstants.YELLOW);
        this.tip.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.tip.addMouseListener(new MouseAdapter(){

            private void dispatchEventToTree(MouseEvent e) {
                GWTree tree = GWTree.this;
                tree.processMouseEvent(e);
            }

            private MouseEvent convertToTree(MouseEvent e) {
                GWTree tree = GWTree.this;
                Point p = new Point(e.getX(), e.getY());
                SwingUtilities.convertPointToScreen(p, (Component)e.getSource());
                SwingUtilities.convertPointFromScreen(p, tree);
                int row = GWTree.this.getRowForLocation(e.getX(), e.getY());
                Point treeLoc = new Point(0, 0);
                if (row < 0) {
                    JPopupMenu popup;
                    treeLoc = tree.isShowing() ? tree.getLocationOnScreen() : ((popup = (JPopupMenu)SwingUtilities.getAncestorOfClass(JPopupMenu.class, tree)) != null ? popup.getInvoker().getLocationOnScreen() : tree.getParent().getLocationOnScreen());
                }
                return new MouseEvent(tree, e.getID(), e.getWhen(), e.getModifiers(), p.x - treeLoc.x, p.y - treeLoc.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
            }

            public void mousePressed(MouseEvent e) {
                GWTree.this.setPopupContainerCloseDisabled(e.isPopupTrigger());
                this.dispatchEventToTree(this.convertToTree(e));
                if (!e.isPopupTrigger()) {
                    GWTree.this.checkClosingParentPopup();
                }
            }

            public void mouseClicked(MouseEvent e) {
                GWTree.this.setPopupContainerCloseDisabled(e.isPopupTrigger());
                this.dispatchEventToTree(this.convertToTree(e));
                if (!e.isPopupTrigger()) {
                    GWTree.this.hideTipPopup();
                    GWTree.this.checkClosingParentPopup();
                }
            }

            public void mouseReleased(MouseEvent e) {
                GWTree.this.setPopupContainerCloseDisabled(e.isPopupTrigger());
                this.dispatchEventToTree(this.convertToTree(e));
                if (!e.isPopupTrigger()) {
                    GWTree.this.checkClosingParentPopup();
                }
            }

            public void mouseExited(MouseEvent e) {
                GWTree.this.hideTipPopup();
            }
        });
        this.addMouseMotionListener(new ToolTipListener());
    }

    private void checkClosingParentPopup() {
        JPopupMenu parent = (JPopupMenu)SwingUtilities.getAncestorOfClass(JPopupMenu.class, this);
        if (parent != null) {
            parent.setVisible(false);
        }
    }

    protected void doPopup(MouseEvent e) {
    }

    public void hideTipPopup() {
        if (this.popupTip != null) {
            this.popupTip.hide();
        }
        this.popupTip = null;
        this.toolTipText = null;
        this.popupContainerCloseDisabled = false;
    }

    public Insets getAutoscrollInsets() {
        Insets insets = new Insets(0, 0, 0, 0);
        Rectangle rect = this.getVisibleRect();
        if (rect != null) {
            insets.top = rect.y + this.row_height;
            insets.left = rect.x + this.row_height;
            insets.bottom = this.getHeight() - (rect.y + rect.height) + this.row_height;
            insets.right = this.getWidth() - (rect.x + rect.width) + this.row_height;
        }
        return insets;
    }

    public void autoscroll(Point cursorLocn) {
        UIUtils.scrollComponent(cursorLocn, this, this.row_height);
        this.repaintDragFolder(cursorLocn);
    }

    private int getRowAt(int y) {
        return Math.max(0, Math.min(this.getRowCount() - 1, y / this.row_height));
    }

    public void repaintDragFolder(Point cursorPos) {
        int rowAt = this.getRowAt(cursorPos.y);
        if (this.lastSelectedRow != rowAt) {
            int last = this.lastSelectedRow;
            this.lastSelectedRow = rowAt;
            if (last != -1) {
                this.repaint(last);
            }
            this.repaint(rowAt);
        }
    }

    private void repaint(int rowNumber) {
        Rectangle rowBounds = this.getRowBounds(rowNumber);
        if (rowBounds != null) {
            this.repaint(rowBounds);
        }
    }

    protected void setToolTipFont(Font font) {
        this.tip.setFont(font);
    }

    private void showTipPopup(Dimension size, int x, int y) {
        this.hideTipPopup();
        try {
            Point p = this.getLocationOnScreen();
            this.tip.setPreferredSize(size);
            this.popupTip = PopupFactory.getSharedInstance().getPopup(this, this.tip, p.x + x, p.y + y);
            this.popupTip.show();
            this.popupContainerCloseDisabled = true;
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public boolean isPopupContainerCloseDisabled() {
        return this.popupContainerCloseDisabled;
    }

    private void setPopupContainerCloseDisabled(boolean popupContainerCloseDisabled) {
        this.popupContainerCloseDisabled = popupContainerCloseDisabled;
    }

    public void expandAll() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    public void collapseAll() {
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            this.collapseRow(i);
        }
    }

    static {
        UIManager.put(GWTree.class.getSimpleName(), BasicTreeUI.class.getName());
    }

    private class ToolTipListener
    implements MouseMotionListener {
        private ToolTipListener() {
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            GWTree tree = GWTree.this;
            Container parent = tree.getParent();
            Point point = e.getPoint();
            TreePath path = tree.getPathForLocation(point.x, point.y);
            if (path != null) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object userObject = node.getUserObject();
                String nodeString = userObject.toString();
                if (nodeString.equals(GWTree.this.toolTipText)) {
                    return;
                }
                GWTree.this.hideTipPopup();
                Rectangle rect = tree.getPathBounds(path);
                Rectangle visibleRect = tree.getVisibleRect();
                int pathX1 = rect.x + ((TextTreeRenderer)((Object)tree.getCellRenderer())).getTextX();
                if (visibleRect.width > rect.width + rect.x - TreeUtils.getShift(GWTree.this, path)) {
                    GWTree.this.toolTipText = null;
                    return;
                }
                GWTree.this.toolTipText = nodeString;
                GWTree.this.tip.setText(GWTree.this.toolTipText);
                FontMetrics fontMetrics = GWTree.this.tip.getFontMetrics(GWTree.this.tip.getFont());
                Dimension preferredSize = new Dimension(fontMetrics.stringWidth(GWTree.this.toolTipText) + 2, fontMetrics.getHeight() + 2);
                int pathY = rect.y;
                if (parent instanceof JViewport) {
                    JViewport viewport = (JViewport)parent;
                    Point viewPosition = viewport.getViewPosition();
                    if (viewPosition.x > pathX1) {
                        pathX1 = viewport.getLocation().x;
                    }
                }
                GWTree.this.showTipPopup(preferredSize, pathX1 - 1, pathY);
            }
        }
    }
}

