/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar;

import com.appframework.level.LevelManager;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.OS;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.ActiveItemLabelController;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarController;
import com.novell.gw.jclient.application.controls.gwcalendar.StaticItemLabel;
import com.novell.gw.jclient.application.controls.menus.AbstractActionsPopupMenu;
import com.novell.gw.jclient.application.controls.menus.PopupMenuFactory;
import com.novell.gw.jclient.bl.om.categories.CategoryUtils;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.ItemAndItemListInfo;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import org.apache.log4j.Logger;

public class ActiveItemLabel
extends StaticItemLabel
implements MVCView {
    private static Logger logger = Logger.getLogger(ActiveItemLabel.class);
    private ActiveItemLabelController controller;
    protected boolean paintSelectionBorder = false;
    protected String itemType;

    public ActiveItemLabel(boolean isMultiLine, ItemAndItemListInfo itemAndItemListInfo, Color backColor, MVCController theParentController, boolean doCheckAlignIcons) {
        super(isMultiLine, itemAndItemListInfo, backColor, doCheckAlignIcons);
        this.controller = new ActiveItemLabelController(this, theParentController);
        this.initItemType();
        this.addMouseListener(new GWItemLabelMouseListener());
    }

    private void initItemType() {
        this.itemType = this.getItem().getNativeItem().isAllDayEvent() ? "AllDayEvent" : this.getItem().getType();
    }

    public void setController(MVCController theController) {
        if (this.controller != null) {
            LevelManager.release(this.controller.getLevel());
        }
        this.controller = (ActiveItemLabelController)theController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object theModel) {
    }

    public Object getMVCModel() {
        return this.getItem();
    }

    public void select() {
        GWCalendarController gwCalendarController = ControlsUtils.getParentGWCalendarController(this.getController());
        assert (gwCalendarController != null);
        gwCalendarController.itemSelected((IItem)this.getItem().getNativeItem());
    }

    public boolean isPaintSelectionBorder() {
        return this.paintSelectionBorder;
    }

    public void setPaintSelectionBorder(boolean paintSelectionBorder) {
        this.paintSelectionBorder = paintSelectionBorder;
    }

    protected void paintSelectionBorder(Graphics2D g2D) {
        if (this.paintSelectionBorder) {
            g2D.setColor(Color.BLACK);
            g2D.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
    }

    public Color getForeground() {
        AbstractItem item = this.getItem();
        if (item == null) {
            return super.getForeground();
        }
        Color primaryTextColor = CategoryUtils.getPrimaryTextColor(item.getCategories());
        if (primaryTextColor != null) {
            return primaryTextColor;
        }
        if (item.getFolder().getCalendarColor() == null) {
            return super.getForeground();
        }
        Color backgroundColor = item.getCalendarDisplayColor();
        int max = Math.max(backgroundColor.getBlue(), backgroundColor.getGreen());
        max = Math.max(max, backgroundColor.getRed());
        int min = Math.min(backgroundColor.getBlue(), backgroundColor.getGreen());
        int lum = (max + (min = Math.min(min, backgroundColor.getRed()))) / 2;
        int wAnchor = lum > 200 ? lum * 40 / 100 : lum * 60 / 100;
        Color cTextColor = backgroundColor.getGreen() > 200 ? new Color(backgroundColor.getRed() * wAnchor / lum, backgroundColor.getGreen() * wAnchor / lum, backgroundColor.getBlue() * wAnchor / lum) : (backgroundColor.getBlue() > 245 || backgroundColor.getRed() > 245 ? (lum - wAnchor <= 60 ? Color.WHITE : new Color(backgroundColor.getRed() * wAnchor / lum, backgroundColor.getGreen() * wAnchor / lum, backgroundColor.getBlue() * wAnchor / lum)) : (wAnchor >= lum * 45 / 100 ? Color.WHITE : new Color(backgroundColor.getRed() * wAnchor / lum, backgroundColor.getGreen() * wAnchor / lum, backgroundColor.getBlue() * wAnchor / lum)));
        return cTextColor;
    }

    private class GWItemLabelMouseListener
    extends MouseAdapter {
        private GWItemLabelMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            ActiveItemLabel activeItemLabel = ActiveItemLabel.this;
            activeItemLabel.select();
            this.doPopup(e);
        }

        public void mouseClicked(MouseEvent e) {
            ActiveItemLabel label = ActiveItemLabel.this;
            if (OS.isDoubleClick(e)) {
                label.getController().getActionList().performAction(ActionKey.OPEN_ITEM);
            }
        }

        private void doPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                AbstractFolder folder = GWClient.getGWMainAppFrame().getFolder();
                ActiveItemLabel label = ActiveItemLabel.this;
                AbstractActionsPopupMenu popup = PopupMenuFactory.createCalendarViewGWItemPopupMenu(label.getController().getActionList(), folder, ActiveItemLabel.this.getItemList(), label.getItem(), ActiveItemLabel.this.itemType);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.doPopup(e);
        }
    }
}

