/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar;

import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.application.actions.componentrelated.ActionCalendar;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendar;
import com.novell.gw.jclient.application.controls.gwcalendar.TypingWindow;
import com.novell.gw.jclient.application.frames.calendar.FrameCalendar;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import java.util.Calendar;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GWCalendarController
extends MVCController<GWCalendar> {
    public GWCalendarController(GWCalendar theView, MVCController parentController) {
        super(theView, parentController, ActionCalendar.class);
    }

    @Override
    protected void initListeners() {
        Level level = this.getFrameLevel();
        AppEventListener listener = new CALENDAR_ITEMS_REFRESH_listener();
        AppEventListenerDescriptor descriptor = new AppEventListenerDescriptor(level, 80, listener);
        this.addListenerDescriptor(descriptor);
        listener = new QUICK_CREATE_POSTED_CALENDAR_ITEM_listener();
        descriptor = new AppEventListenerDescriptor(level, 1310, listener);
        this.addListenerDescriptor(descriptor);
        listener = new CALENDAR_TIME_ZONE_CHANGED_listener();
        descriptor = new AppEventListenerDescriptor(level, 86, listener);
        this.addListenerDescriptor(descriptor);
        listener = new FOLDERS_SETTINGS_CHANGED_listener();
        descriptor = new AppEventListenerDescriptor(level, 1210, listener);
        this.addListenerDescriptor(descriptor);
        listener = new WORKSTATION_TIME_ZONE_CHANGED_listener();
        descriptor = new AppEventListenerDescriptor(level, 87, listener);
        this.addListenerDescriptor(descriptor);
        listener = new SELECTED_DATE_CHANGED_listener();
        descriptor = new AppEventListenerDescriptor(level, 70, listener);
        this.addListenerDescriptor(descriptor);
        descriptor = new AppEventListenerDescriptor(level, 85, new CALENDAR_REBUILD_listener());
        this.addListenerDescriptor(descriptor);
    }

    public void itemSelected(IItem item) {
        ((GWCalendar)this.getMVCView()).processItemSelectionChangedEvent(item);
    }

    private class CALENDAR_REBUILD_listener
    extends AppEventListener {
        private CALENDAR_REBUILD_listener() {
        }

        public void handle(AppEvent theEvent) {
            ((GWCalendar)GWCalendarController.this.getMVCView()).refreshUIOptins();
        }
    }

    private class WORKSTATION_TIME_ZONE_CHANGED_listener
    extends AppEventListener {
        private WORKSTATION_TIME_ZONE_CHANGED_listener() {
        }

        public void handle(AppEvent theEvent) {
            ((GWCalendar)GWCalendarController.this.getMVCView()).notifyRefresh(null);
        }
    }

    private class SELECTED_DATE_CHANGED_listener
    extends AppEventListener {
        private SELECTED_DATE_CHANGED_listener() {
        }

        public void handle(AppEvent event) {
            ((GWCalendar)GWCalendarController.this.getMVCView()).setCurrentDay((Calendar)((Calendar)event.getData()).clone());
        }
    }

    private class FOLDERS_SETTINGS_CHANGED_listener
    extends AppEventListener {
        private FOLDERS_SETTINGS_CHANGED_listener() {
        }

        public void handle(AppEvent theEvent) {
            GWCalendar calendar = (GWCalendar)GWCalendarController.this.getMVCView();
            if (!(SwingUtilities.getWindowAncestor(calendar) instanceof FrameCalendar)) {
                calendar.refresh();
            }
        }
    }

    private class CALENDAR_TIME_ZONE_CHANGED_listener
    extends AppEventListener {
        private CALENDAR_TIME_ZONE_CHANGED_listener() {
        }

        public void handle(AppEvent theEvent) {
            ((GWCalendar)GWCalendarController.this.getMVCView()).rebuildHoursPanels();
        }
    }

    private class QUICK_CREATE_POSTED_CALENDAR_ITEM_listener
    extends AppEventListener {
        private QUICK_CREATE_POSTED_CALENDAR_ITEM_listener() {
        }

        public void handle(AppEvent event) {
            if (event.getData() instanceof TypingWindow.PostedItemInformation && ((GWCalendar)GWCalendarController.this.getMVCView()).isVisible() && event.getSource() instanceof MVCController && ((MVCController)event.getSource()).isChildOf(GWCalendarController.this)) {
                TypingWindow.PostedItemInformation itemInfo = (TypingWindow.PostedItemInformation)event.getData();
                ((GWCalendar)GWCalendarController.this.getMVCView()).postNewPostedCalendarItem(itemInfo.getType(), itemInfo.getCurrentTime(), itemInfo.getSubject());
            }
        }
    }

    private class CALENDAR_ITEMS_REFRESH_listener
    extends AppEventListener {
        private CALENDAR_ITEMS_REFRESH_listener() {
        }

        public void handle(AppEvent theEvent) {
            ((GWCalendar)GWCalendarController.this.getMVCView()).notifyRefresh((TimeInterval)theEvent.getData());
        }
    }
}

