/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar;

import com.appframework.AppAction;
import com.appframework.Tested;
import com.appframework.mvc.MVCController;
import com.appframework.utils.Day;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.engine.EngineLocale;
import com.novell.gw.jclient.api.enums.AppointmentAcceptLevel;
import com.novell.gw.jclient.api.enums.CalendarViewType;
import com.novell.gw.jclient.api.enums.ItemType;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.message.IAppointment;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.api.interfaces.message.INote;
import com.novell.gw.jclient.api.interfaces.message.ITask;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.gwcalendar.DateAndTimeFormattingUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GwCalendarUtilFactory;
import com.novell.gw.jclient.application.controls.gwcalendar.ToolBarProperties.PropertiesViewList;
import com.novell.gw.jclient.application.controls.gwcalendar.ToolBarProperties.PropertiesViewListItem;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.AppointmentPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.menus.GWMenu;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.eng_impl.GWItemFactory;
import com.novell.gw.jclient.bl.eng_impl.displaysettings.FolderDisplaySettings;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.items.AbstractCalendarItem;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import com.novell.gw.jclient.bl.om.items.TimeDuration;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import java.awt.Color;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GWCalendarUtils {
    private static Logger logger = Logger.getLogger(GWCalendarUtils.class);
    public static String[] dayNames = new String[]{StringResources.SUNDAY, StringResources.MONDAY, StringResources.TUESDAY, StringResources.WEDNESDAY, StringResources.THURSDAY, StringResources.FRIDAY, StringResources.SATURDAY};
    public static String[] dayMediumNames = new String[]{StringResources.SUNDAY_SHORT, StringResources.MONDAY_SHORT, StringResources.TUESDAY_SHORT, StringResources.WEDNESDAY_SHORT, StringResources.THURSDAY_SHORT, StringResources.FRIDAY_SHORT, StringResources.SATURDAY_SHORT};
    public static String[] dayShortestNames = new String[]{StringResources.SUNDAY_SHORTEST, StringResources.MONDAY_SHORTEST, StringResources.TUESDAY_SHORTEST, StringResources.WEDNESDAY_SHORTEST, StringResources.THURSDAY_SHORTEST, StringResources.FRIDAY_SHORTEST, StringResources.SATURDAY_SHORTEST};
    public static String[] monthNames = new String[]{StringResources.JANUARY, StringResources.FEBRUARY, StringResources.MARCH, StringResources.APRIL, StringResources.MAY, StringResources.JUNE, StringResources.JULY, StringResources.AUGUST, StringResources.SEPTEMBER, StringResources.OCTOBER, StringResources.NOVEMBER, StringResources.DECEMBER};
    public static String[] monthShortNames = new String[]{StringResources.JANUARY_SHORT, StringResources.FEBRUARY_SHORT, StringResources.MARCH_SHORT, StringResources.APRIL_SHORT, StringResources.MAY_SHORT, StringResources.JUNE_SHORT, StringResources.JULY_SHORT, StringResources.AUGUST_SHORT, StringResources.SEPTEMBER_SHORT, StringResources.OCTOBER_SHORT, StringResources.NOVEMBER_SHORT, StringResources.DECEMBER_SHORT};
    private static DateFormat dateFormat;
    private static DateFormat dateFormatFull;
    private static DateFormat timeFormatHMMA;
    private static DateFormat dateTimeFormat;
    private static DateFormat dateTimeFormatWithDayOfWeek;
    public static final int ONE_MINUTE_MILISECS = 60000;
    public static final int ONE_HOUR_MILISECS = 3600000;
    public static final int ONE_HOUR_MINUTES = 60;
    public static final int ONE_HALFHOUR_MILISECS = 1800000;
    public static final int ONE_DAY_MILISECS = 86400000;
    public static final int ONE_DAY_MINUTES = 1440;
    public static final int ONE_DAY_HOURS = 24;
    protected static DateFormatSymbols dateFormatSymbols;
    private static DateFormat timeFormatDDMM;
    private static PropertiesViewList calendarPopertiesViewList;
    public static final String LIST_NAME = "CalendarToolBar_itemList";

    public static Calendar getToday() {
        TimeZone timeZone = OptionManager.getInstance().getDateTimeOptions().getTimeZone();
        return Calendar.getInstance(timeZone, EngineCommandManager.getLocale());
    }

    public static Calendar getTodayWithoutTimeFraction() {
        Calendar today = GwCalendarUtilFactory.getInstance().getProvider().getToday();
        GWCalendarUtils.clearTime(today);
        return today;
    }

    public static Calendar getTodayUTC() {
        Calendar gc = Calendar.getInstance(EngineCommandManager.getLocale());
        gc.setTimeZone(TimeZone.getTimeZone("GMT"));
        return gc;
    }

    public static int getZoneOffset() {
        TimeZone tz = OptionManager.getInstance().getDateTimeOptions().getTimeZone();
        Calendar gcTodaySelZone = Calendar.getInstance(tz);
        return tz.getOffset(gcTodaySelZone.getTimeInMillis());
    }

    public static int getAlternateZoneOffset() {
        TimeZone tz = OptionManager.getInstance().getDateTimeOptions().getAlternateTimeZone();
        Calendar gcTodaySelZone = Calendar.getInstance(tz);
        return tz.getOffset(gcTodaySelZone.getTimeInMillis());
    }

    public static String calendarToString(Calendar theCalendar) {
        return GWCalendarUtils.calendarToString(theCalendar.getTime());
    }

    public static String calendarToString(Date theDate) {
        DateFormat df = DateAndTimeFormattingUtils.getDateFormat("yyyyMMdd");
        return df.format(theDate);
    }

    public static Calendar getDateForDayOfWeek(Calendar theDay, int theDayOfWeek) {
        Calendar day = (Calendar)theDay.clone();
        day.set(theDay.get(1), theDay.get(2), theDay.get(5), 0, 0, 0);
        int firstDay = 1;
        int offset = day.get(7);
        if (offset == 1 && firstDay == 1) {
            offset = 8;
        }
        day.add(5, -offset + theDayOfWeek + firstDay);
        return day;
    }

    public static Calendar getPreviousMondayDate(Calendar theDay) {
        Calendar day = (Calendar)theDay.clone();
        while (day.get(7) != 2) {
            day.add(5, -1);
        }
        return day;
    }

    public static TimeInterval getDayTimeInterval(Date theDate) {
        Calendar gcBegin = GWCalendarUtils.getToday();
        gcBegin.setTime(theDate);
        gcBegin.set(11, 0);
        gcBegin.set(12, 0);
        gcBegin.set(13, 0);
        gcBegin.set(14, 0);
        Calendar gcEnd = (Calendar)gcBegin.clone();
        gcEnd.set(11, 23);
        gcEnd.set(12, 59);
        gcEnd.set(13, 59);
        gcEnd.set(14, 999);
        return new TimeInterval(gcBegin.getTimeInMillis(), gcEnd.getTimeInMillis());
    }

    public static TimeInterval getDayTimeInterval(Date theBeginDate, Date theEndDate) {
        Calendar gcBegin = GWCalendarUtils.getToday();
        gcBegin.setTime(theBeginDate);
        gcBegin.set(11, 0);
        gcBegin.set(12, 0);
        gcBegin.set(13, 0);
        gcBegin.set(14, 0);
        Calendar gcEnd = GWCalendarUtils.getToday();
        gcEnd.setTime(theEndDate);
        gcEnd.set(11, 23);
        gcEnd.set(12, 59);
        gcEnd.set(13, 59);
        gcEnd.set(14, 999);
        return new TimeInterval(gcBegin.getTimeInMillis(), gcEnd.getTimeInMillis());
    }

    public static TimeInterval getMonthTimeInterval(Date theDate) {
        Calendar gcBegin = GWCalendarUtils.getToday();
        gcBegin.setTime(theDate);
        gcBegin.set(5, 1);
        gcBegin.set(11, 0);
        gcBegin.set(12, 0);
        gcBegin.set(13, 0);
        gcBegin.set(14, 0);
        Calendar gcEnd = (Calendar)gcBegin.clone();
        gcEnd.set(5, gcEnd.getActualMaximum(5));
        gcEnd.set(11, 23);
        gcEnd.set(12, 59);
        gcEnd.set(13, 59);
        gcEnd.set(14, 999);
        return new TimeInterval(gcBegin.getTimeInMillis(), gcEnd.getTimeInMillis());
    }

    @Deprecated
    public static DateFormat getTimeFormat() {
        return GWCalendarUtils.getTimeFormatHMMA();
    }

    @Deprecated
    public static DateFormat getTimeFormatHMMA() {
        if (timeFormatHMMA == null) {
            timeFormatHMMA = Locale.JAPANESE.equals(EngineLocale.getCurrent().getLocale()) ? new SimpleDateFormat("a h:mm", GWCalendarUtils.getDateFormatSymbols()) : DateFormat.getTimeInstance(3, EngineCommandManager.getLocale());
            if (timeFormatHMMA instanceof SimpleDateFormat) {
                ((SimpleDateFormat)timeFormatHMMA).setDateFormatSymbols(GWCalendarUtils.getDateFormatSymbols());
            }
            timeFormatHMMA.setTimeZone(OptionManager.getInstance().getDateTimeOptions().getTimeZone());
        }
        return timeFormatHMMA;
    }

    private static DateFormatSymbols getDateFormatSymbols() {
        if (dateFormatSymbols == null) {
            dateFormatSymbols = new DateFormatSymbols(EngineCommandManager.getLocale());
            dateFormatSymbols.setAmPmStrings(new String[]{StringResources.AM, StringResources.PM});
        }
        return dateFormatSymbols;
    }

    public static DateFormat getDateFormatFull() {
        if (dateFormatFull == null) {
            String defaultFormat = "EEEEE, MMMMM d, yyyy";
            try {
                dateFormatFull = new SimpleDateFormat(StringResources.DATE_FORMAT_FULL.equals(StringResources.getUNDEFINED_RESOURCE()) ? defaultFormat : StringResources.DATE_FORMAT_FULL, EngineCommandManager.getLocale());
            }
            catch (Exception e) {
                logger.warn((Object)("Incorrect date format received from resources. Date format:" + StringResources.DATE_FORMAT_FULL));
                logger.error((Object)e, (Throwable)e);
                dateFormatFull = new SimpleDateFormat(defaultFormat);
            }
        }
        return dateFormatFull;
    }

    public static DateFormat getDateFormatMMDD() {
        if (timeFormatDDMM == null) {
            timeFormatDDMM = new SimpleDateFormat("MM/dd", EngineCommandManager.getLocale());
            timeFormatDDMM.setTimeZone(OptionManager.getInstance().getDateTimeOptions().getTimeZone());
        }
        return timeFormatDDMM;
    }

    public static long getDifferenceInSeconds(Date date1, Date date2) {
        return (date1.getTime() - date2.getTime()) / 1000L;
    }

    public static long getDifferenceInMinutes(Date date1, Date date2) {
        return (date1.getTime() - date2.getTime()) / 60000L;
    }

    public static long getDifferenceInHours(Date date1, Date date2) {
        return (date1.getTime() - date2.getTime()) / 3600000L;
    }

    public static long getDifferenceInDays(Date date1, Date date2) {
        return (date1.getTime() - date2.getTime()) / 86400000L;
    }

    @Tested
    public static boolean isSameDate(Calendar calendar1, Calendar calendar2) {
        if (calendar1 == null || calendar2 == null) {
            return false;
        }
        if (!calendar1.getTimeZone().equals(calendar2.getTimeZone())) {
            calendar2 = (Calendar)calendar2.clone();
            calendar2.setTimeZone(calendar1.getTimeZone());
        }
        calendar1 = (Calendar)calendar1.clone();
        GWCalendarUtils.clearTime(calendar1);
        long startTime = calendar1.getTimeInMillis();
        calendar1.add(6, 1);
        long endTime = calendar1.getTimeInMillis();
        long time2 = calendar2.getTimeInMillis();
        return time2 >= startTime && time2 < endTime;
    }

    @Deprecated
    public static boolean isSameDate(Date theDate1, Date theDate2) {
        if (theDate1 == null || theDate2 == null) {
            return false;
        }
        return theDate1.getYear() == theDate2.getYear() && theDate1.getMonth() == theDate2.getMonth() && theDate1.getDate() == theDate2.getDate();
    }

    public static String getDurationText(long durationMls) {
        long days = durationMls / 86400000L;
        long hours = (durationMls - days * 86400000L) / 3600000L;
        long minutes = (durationMls - days * 86400000L - hours * 3600000L) / 60000L;
        StringBuilder result = new StringBuilder(80);
        if (days > 0L) {
            result.append(days);
            result.append(' ');
            result.append(days == 1L ? StringResources.DAY : StringResources.DAYS);
        }
        if (hours > 0L) {
            if (result.length() > 0) {
                result.append(' ');
            }
            result.append(hours);
            result.append(' ');
            result.append(hours == 1L ? StringResources.HOUR : StringResources.HOURS);
        }
        if (minutes > 0L) {
            if (result.length() > 0) {
                result.append(' ');
            }
            result.append(minutes);
            result.append(' ');
            result.append(minutes == 1L ? StringResources.MINUTE : StringResources.MINUTES);
        }
        return '(' + result.toString() + ')';
    }

    public static Calendar initCalendar(Calendar currentDay) {
        Calendar gcDay = GWCalendarUtils.getTodayWithoutTimeFraction();
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        int i = (Integer)dataStoreSettings.getMonthCalendarFirstDay().getValue();
        gcDay.set(1, currentDay.get(1));
        gcDay.set(2, currentDay.get(2));
        gcDay.set(5, 1);
        int day_of_week = gcDay.get(7);
        if (day_of_week > 7) {
            day_of_week -= 7;
        }
        int firstDayOfWeek = (Integer)dataStoreSettings.getMonthCalendarFirstDay().getValue() + 1;
        int movement = 1;
        while (firstDayOfWeek != day_of_week) {
            firstDayOfWeek = firstDayOfWeek == 7 ? 1 : ++firstDayOfWeek;
            ++movement;
        }
        gcDay.add(5, -movement);
        return gcDay;
    }

    public static List<? extends AbstractItem> getCalendarItems(IItemList itemList, Date date, String itemType) {
        List<AbstractItem> calendarItems;
        if (itemList == null) {
            return new ArrayList();
        }
        Calendar calendar = GWCalendarUtils.getToday();
        calendar.setTime(date);
        if (itemType.equals("Task")) {
            calendarItems = GWCalendarUtils.getTasks(itemList, new Day(calendar));
        } else if (itemType.equals("Note")) {
            calendarItems = GWCalendarUtils.getNotes(itemList, new Day(calendar));
        } else if (itemType.equals("Appointment")) {
            calendarItems = GWCalendarUtils.getAppointments(itemList, new Day(calendar));
        } else if (itemType.equals("AllDayEvent")) {
            calendarItems = GWCalendarUtils.getAllDayEvents(itemList, date);
        } else if (itemType.equals("AppointmentAndAllDayEvent")) {
            calendarItems = GWCalendarUtils.getCalendarItems(itemList, new Day(calendar), ItemType.APPT);
        } else {
            calendarItems = new ArrayList<AbstractItem>();
            logger.warn((Object)("unexpected item type: " + itemType));
            assert (false) : "unexpected item type: " + itemType;
        }
        return calendarItems;
    }

    public static void fillCalendarItems(IItemList theItemList, Date theDate, List<AbstractCalendarItem> appointments, List<AbstractItem> tasks, List<AbstractCalendarItem> notes) {
        if (theItemList == null || theDate == null) {
            return;
        }
        IItem[] calendarItems = theItemList.getCalendarItems(theDate);
        try {
            for (IItem item : calendarItems) {
                if (item instanceof ITask || item instanceof IMessage && ((IMessage)item).isInChecklist()) {
                    tasks.add(GWItemFactory.gwObjectToItem((IMessage)item));
                    continue;
                }
                if (item instanceof IAppointment) {
                    appointments.add((AbstractCalendarItem)GWItemFactory.gwObjectToItem((IAppointment)item));
                    continue;
                }
                if (item instanceof INote) {
                    notes.add((AbstractCalendarItem)GWItemFactory.gwObjectToItem((INote)item));
                    continue;
                }
                logger.warn((Object)("Invalid calendar item received: [" + item + ']'));
                assert (false) : "Invalid calendar item received: [" + item + ']';
            }
        }
        catch (GWCommandException e) {
            ErrorDialog.processGWException(e);
        }
    }

    public static List<AbstractCalendarItem> getCalendarItems(IItemList itemList, Day date, ItemType itemType) {
        if (itemList == null) {
            return new ArrayList<AbstractCalendarItem>();
        }
        Calendar calendar = GWCalendarUtils.convertDayToCalendar(date);
        calendar.set(11, 12);
        return MessageUtils.convertToAbstractCalendarItemsList(itemList.getCalendarItems(calendar.getTime(), itemType));
    }

    public static List<AbstractCalendarItem> getAppointments(IItemList itemList, Day date) {
        if (itemList == null) {
            return new ArrayList<AbstractCalendarItem>();
        }
        Calendar calendar = GWCalendarUtils.convertDayToCalendar(date);
        calendar.set(11, 12);
        return MessageUtils.convertToAbstractCalendarItemsList(itemList.getAppointments(calendar.getTime()));
    }

    public static List<AbstractItem> getTasks(IItemList itemList, Day date) {
        if (itemList == null) {
            return new ArrayList<AbstractItem>();
        }
        Calendar calendar = GWCalendarUtils.convertDayToCalendar(date);
        calendar.set(11, 12);
        return MessageUtils.convertToAbstractItemsList(itemList.getTasks(calendar.getTime()));
    }

    public static List<AbstractCalendarItem> getNotes(IItemList itemList, Day date) {
        if (itemList == null) {
            return new ArrayList<AbstractCalendarItem>();
        }
        Calendar calendar = GWCalendarUtils.convertDayToCalendar(date);
        calendar.set(11, 12);
        return MessageUtils.convertToAbstractCalendarItemsList(itemList.getNotes(calendar.getTime()));
    }

    public static List<AbstractCalendarItem> getAllDayEvents(IItemList itemList, Date date) {
        if (itemList == null) {
            return new ArrayList<AbstractCalendarItem>();
        }
        return MessageUtils.convertToAbstractCalendarItemsList(itemList.getAllDayEvents(date));
    }

    public static List<AbstractCalendarItem> getAllDayEvents(IItemList itemList, Date startDate, Date endDate) {
        if (itemList == null) {
            return new ArrayList<AbstractCalendarItem>();
        }
        return MessageUtils.convertToAbstractCalendarItemsList(itemList.getAllDayEvents(startDate, endDate));
    }

    private static Date checkDate(Date date) {
        Calendar gc = GWCalendarUtils.getToday();
        gc.setTime(date);
        if (gc.get(11) == 0 && gc.get(12) == 0) {
            gc.set(11, 12);
        }
        return gc.getTime();
    }

    public static int getClockPosition() {
        Calendar today = GWCalendarUtils.getToday();
        int hours = today.get(11);
        int minute = today.get(12);
        int now = hours * 60 + minute;
        now = (int)((float)now * AppointmentPanel.PX_PER_MINUTE);
        return now;
    }

    public static boolean isToday(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("calendar is null");
        }
        return GWCalendarUtils.isSameDate(calendar.getTime(), GWCalendarUtils.getToday().getTime());
    }

    public static boolean isToday(Date theTime) {
        return GWCalendarUtils.isSameDate(theTime, GWCalendarUtils.getToday().getTime());
    }

    public static int getMinutes(Calendar theDate) {
        return theDate.get(11) * 60 + theDate.get(12);
    }

    public static int getDuration(Calendar calendar1, Calendar calendar2) {
        assert (calendar1.getTimeZone().equals(calendar2.getTimeZone()));
        int cal1 = calendar1.get(6) * 24 * 60 + calendar1.get(11) * 60 + calendar1.get(12);
        int cal2 = calendar2.get(6) * 24 * 60 + calendar2.get(11) * 60 + calendar2.get(12);
        return Math.abs(cal1 - cal2);
    }

    public static boolean inMonthRange(Calendar theCurrent, Calendar theMonth) {
        return theCurrent.get(2) == theMonth.get(2) && theCurrent.get(1) == theMonth.get(1);
    }

    public static int getChangeMask(Calendar oldData, Calendar newDate) {
        if (oldData == null) {
            return 7;
        }
        int oldDay = oldData.get(5);
        int oldMonth = oldData.get(2);
        int oldYear = oldData.get(1);
        int newDay = newDate.get(5);
        int newMonth = newDate.get(2);
        int newYear = newDate.get(1);
        int theChangeMask = 0;
        if (oldDay != newDay) {
            theChangeMask |= 1;
        }
        if (oldMonth != newMonth) {
            theChangeMask |= 2;
        }
        if (oldYear != newYear) {
            theChangeMask |= 4;
        }
        return theChangeMask;
    }

    public static Date[] CalendarToDate(Calendar[] theDates) {
        Date[] result = new Date[theDates.length];
        for (Calendar date : theDates) {
            result[i] = date.getTime();
        }
        return result;
    }

    public static Calendar[] DateToCalendar(Date[] theDates) {
        Calendar[] result = new Calendar[theDates.length];
        for (Date date : theDates) {
            Calendar calendar = GWCalendarUtils.getToday();
            calendar.setTime(date);
            result[i] = calendar;
        }
        return result;
    }

    public static Calendar clearTime(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public static Date clearTime(Date date) {
        Calendar theCalendar = Calendar.getInstance();
        theCalendar.setTime(date);
        theCalendar.set(11, 0);
        theCalendar.set(12, 0);
        theCalendar.set(13, 0);
        theCalendar.set(14, 0);
        return theCalendar.getTime();
    }

    public static List<AbstractCalendarItem> getAppointmentsForTimeInterval(List<AbstractCalendarItem> appointments, TimeInterval timeInterval) {
        ArrayList<AbstractCalendarItem> items = new ArrayList<AbstractCalendarItem>();
        for (AbstractCalendarItem calendarItem : appointments) {
            if (!calendarItem.isInTimeInterval(timeInterval)) continue;
            items.add(calendarItem);
        }
        return items;
    }

    public static Color getShowAsLevelColor(AppointmentAcceptLevel showAsLevel) {
        if (showAsLevel == AppointmentAcceptLevel.FREE) {
            return Color.WHITE;
        }
        if (showAsLevel == AppointmentAcceptLevel.TENTATIVE) {
            return ColorConstants.TENTATIVE_APPOINTMENT_COLOR;
        }
        if (showAsLevel == AppointmentAcceptLevel.BUSY) {
            return ColorConstants.BUSY_APPOINTMENT_COLOR;
        }
        if (showAsLevel == AppointmentAcceptLevel.OUT_OF_OFFICE) {
            return ColorConstants.OUT_OF_OFFICE_APPOINTMENT_COLOR;
        }
        throw new IllegalStateException("Unknown appointment show as level");
    }

    public static String getWeekDayName(int day, DayNameLength dayNameLength) {
        String weekDayName;
        if (day < 0 || day > 6) {
            throw new IllegalArgumentException("Illegal day index: " + day + ", accepted values are 0 to 6.");
        }
        int x = day;
        if (x >= 7) {
            x %= 7;
        }
        switch (dayNameLength) {
            case FULL: {
                weekDayName = dayNames[x];
                break;
            }
            case MEDIUM: {
                weekDayName = dayMediumNames[x];
                break;
            }
            case SHORTEST: {
                weekDayName = dayShortestNames[x];
                break;
            }
            default: {
                throw new IllegalStateException("unexpected DayNameLength: " + (Object)((Object)dayNameLength));
            }
        }
        return weekDayName;
    }

    public static CalendarViewType getViewFromSettings(IViewDisplaySettings displaySettings) {
        return GWCalendarUtils.getItemViewFromSettings(displaySettings).getView();
    }

    public static PropertiesViewListItem getItemViewFromSettings(IViewDisplaySettings displaySettings) {
        CalendarViewType viewNumber = displaySettings.getCalViewType();
        if (viewNumber == null) {
            viewNumber = CalendarViewType.DAILY;
        }
        return GWCalendarUtils.getCalendarPropertiesViewList().getListItem(viewNumber.getValue());
    }

    public static boolean isShowCalendarAppointments(IViewDisplaySettings displaySettings) {
        return (displaySettings.getItemType() & 8) == 8;
    }

    public static boolean isShowCalendarTasks(IViewDisplaySettings displaySettings) {
        return (displaySettings.getItemType() & 4) == 4;
    }

    public static boolean isShowCalendarNotes(IViewDisplaySettings displaySettings) {
        return (displaySettings.getItemType() & 2) == 2;
    }

    public static void setShowCalendarItems(boolean showAppointments, boolean showTasks, boolean showNotes, IViewDisplaySettings ds) {
        int value = (showAppointments ? 8 : 0) | (showTasks ? 4 : 0) | (showNotes ? 2 : 0);
        ds.setItemType(value == 0 ? 8 : value);
    }

    public static void setShowCalendarItems(boolean showAppointments, boolean showTasks, boolean showNotes, FolderDisplaySettings ds) {
        int value = (showAppointments ? 8 : 0) | (showTasks ? 4 : 0) | (showNotes ? 2 : 0);
        ds.setItemType(value == 0 ? 8 : value);
    }

    @Tested
    public static TimeDuration convertToAllDayEventDuration(TimeDuration duration) {
        if (duration == null) {
            throw new IllegalArgumentException("duration si null");
        }
        int days = duration.getDays();
        int minutes = duration.getDuration() - days * 1440;
        if (minutes > 0) {
            ++days;
        }
        if (days == 0) {
            ++days;
        }
        return new TimeDuration(0, days * 1440);
    }

    @Tested
    public static int calculateDifferenceInDays(Calendar calendar1, Calendar calendar2) {
        int difference;
        Calendar minCalendar;
        Calendar maxCalendar;
        if (calendar1.compareTo(calendar2) < 0) {
            maxCalendar = calendar2;
            minCalendar = calendar1;
        } else {
            maxCalendar = calendar1;
            minCalendar = calendar2;
        }
        int maxYear = maxCalendar.get(1);
        int minYear = minCalendar.get(1);
        int maxDay = maxCalendar.get(6);
        int minDay = minCalendar.get(6);
        if (maxYear == minYear) {
            difference = maxDay - minDay;
        } else {
            int yearDays = 0;
            for (int year = minYear; year < maxYear; ++year) {
                if (year == minYear) {
                    yearDays += GWCalendarUtils.getDaysInYear(year) - minDay;
                    continue;
                }
                yearDays += GWCalendarUtils.getDaysInYear(year);
            }
            difference = yearDays + maxDay;
        }
        return difference;
    }

    public static int getDaysInYear(int year) {
        return year % 4 == 0 ? 366 : 365;
    }

    @Tested
    public static Date roundAppointmentStartDate(Date startDate) {
        if (startDate == null) {
            throw new IllegalArgumentException("startDate is null");
        }
        Calendar date = Calendar.getInstance();
        date.setTime(startDate);
        if (date.get(14) > 0) {
            date.add(13, 1);
        }
        date.set(14, 0);
        if (date.get(13) > 0) {
            date.add(12, 1);
        }
        date.set(13, 0);
        int minutes = date.get(12);
        if (minutes != 0 && minutes != 30) {
            if (minutes > 30) {
                date.add(11, 1);
                date.set(12, 0);
            } else {
                date.set(12, 30);
            }
        }
        logger.debug((Object)(startDate + " rounded to " + date.getTime()));
        return date.getTime();
    }

    public static PropertiesViewList getCalendarPropertiesViewList() {
        if (calendarPopertiesViewList == null) {
            List loadedList = ApplicationOptions.getInstance().getList(LIST_NAME);
            calendarPopertiesViewList = loadedList == null || loadedList.isEmpty() ? new PropertiesViewList() : new PropertiesViewList(loadedList);
        }
        return calendarPopertiesViewList;
    }

    public static void setCalendarPropertiesViewList(PropertiesViewList list) {
        calendarPopertiesViewList = list;
        ApplicationOptions.getInstance().put(LIST_NAME, list.getList());
    }

    public static JMenu buildNewCalendarItemMenu(MVCController controller, String itemType) {
        return GWCalendarUtils.buildNewCalendarItemMenu(controller, itemType, null);
    }

    public static JMenu buildNewCalendarItemMenu(MVCController controller, String itemType, Map actionMap) {
        AppAction action;
        GWMenu menu = new GWMenu(StringResources.NEW);
        if (itemType.equals("Appointment") || itemType.equals("CalendarItem")) {
            action = controller.getActionList().getAction(ActionKey.NEW_APPOINTMENT);
            menu.add(new JMenuItem(action));
            action = controller.getActionList().getAction(ActionKey.NEW_POSTED_APPOINTMENT);
            menu.add(new JMenuItem(action));
            if (actionMap != null) {
                actionMap.put(ActionKey.NEW_APPOINTMENT, action);
                actionMap.put(ActionKey.NEW_POSTED_APPOINTMENT, action);
            }
        }
        if (itemType.equals("AllDayEvent") || itemType.equals("CalendarItem")) {
            action = controller.getActionList().getAction(ActionKey.NEW_ALL_DAY_EVENT);
            menu.add(new JMenuItem(action));
            action = controller.getActionList().getAction(ActionKey.NEW_POSTED_ALL_DAY_EVENT);
            menu.add(new JMenuItem(action));
            if (actionMap != null) {
                actionMap.put(ActionKey.NEW_ALL_DAY_EVENT, action);
                actionMap.put(ActionKey.NEW_POSTED_ALL_DAY_EVENT, action);
            }
        }
        if (itemType.equals("Task") || itemType.equals("CalendarItem")) {
            action = controller.getActionList().getAction(ActionKey.NEW_TASK);
            menu.add(new JMenuItem(action));
            action = controller.getActionList().getAction(ActionKey.NEW_POSTED_TASK);
            menu.add(new JMenuItem(action));
            if (actionMap != null) {
                actionMap.put(ActionKey.NEW_TASK, action);
                actionMap.put(ActionKey.NEW_POSTED_TASK, action);
            }
        }
        if (itemType.equals("Note") || itemType.equals("CalendarItem")) {
            action = controller.getActionList().getAction(ActionKey.NEW_REMINDERNOTE);
            menu.add(new JMenuItem(action));
            action = controller.getActionList().getAction(ActionKey.NEW_POSTED_REMINDERNOTE);
            menu.add(new JMenuItem(action));
            if (actionMap != null) {
                actionMap.put(ActionKey.NEW_REMINDERNOTE, action);
                actionMap.put(ActionKey.NEW_POSTED_REMINDERNOTE, action);
            }
        }
        return menu;
    }

    public static Calendar[] cloneCalendarArray(Calendar[] arrayToCopy) {
        Calendar[] copy = new Calendar[arrayToCopy.length];
        for (int i = 0; i < arrayToCopy.length; ++i) {
            copy[i] = (Calendar)arrayToCopy[i].clone();
        }
        return copy;
    }

    @Tested
    public static boolean hasTimeFraction(Calendar date) {
        if (date == null) {
            throw new IllegalArgumentException("date is null");
        }
        return date.get(11) != 0 || date.get(12) != 0 || date.get(13) != 0 || date.get(14) != 0;
    }

    public static TimeZone getTimeZone(boolean alternate) {
        if (alternate) {
            return OptionManager.getInstance().getDateTimeOptions().getAlternateTimeZone();
        }
        return OptionManager.getInstance().getDateTimeOptions().getTimeZone();
    }

    public static Day[] convertCalendarsToDays(Calendar[] dates) {
        if (dates == null || dates.length == 0) {
            logger.warn((Object)"no selected dates");
            return new Day[0];
        }
        Day[] days = new Day[dates.length];
        for (int i = 0; i < dates.length; ++i) {
            days[i] = new Day(dates[i]);
        }
        return days;
    }

    public static Calendar[] convertDaysToCalendars(Day[] days) {
        Calendar[] dates;
        if (days == null || days.length == 0) {
            logger.warn((Object)"no days");
            dates = new Calendar[]{};
        } else {
            dates = new Calendar[days.length];
            for (int i = 0; i < dates.length; ++i) {
                dates[i] = GWCalendarUtils.convertDayToCalendar(days[i]);
            }
        }
        return dates;
    }

    public static Calendar convertDayToCalendar(Day day) {
        return GWCalendarUtils.convertDayToCalendar(day, null);
    }

    public static Calendar convertDayToCalendar(Day day, TimeZone timeZone) {
        if (day == null) {
            throw new IllegalArgumentException("day is null");
        }
        Calendar calendar = GWCalendarUtils.getTodayWithoutTimeFraction();
        if (timeZone != null) {
            calendar.setTimeZone(timeZone);
            GWCalendarUtils.clearTime(calendar);
        }
        calendar.set(1, day.getYear());
        calendar.set(6, day.getDayOfYear());
        calendar.get(1);
        return calendar;
    }

    @Tested
    public static Calendar applyDayToCalendar(Day day, Calendar calendar) {
        if (day == null) {
            throw new IllegalArgumentException("day is null");
        }
        if (calendar == null) {
            calendar = GWCalendarUtils.getTodayWithoutTimeFraction();
        }
        calendar.set(1, day.getYear());
        calendar.set(6, day.getDayOfYear());
        return calendar;
    }

    @Tested
    public static Calendar roundCalendarToMinutes(Calendar calendar, int step) {
        long nextMillis;
        if (calendar == null) {
            throw new IllegalArgumentException("calendar is null");
        }
        if (step < 1) {
            throw new IllegalArgumentException("step is less than 1");
        }
        if (step > 60) {
            throw new IllegalArgumentException("step is bigger than 60");
        }
        if (60 % step > 0) {
            throw new IllegalArgumentException("60 devided by " + step + " has reminder");
        }
        Calendar result = (Calendar)calendar.clone();
        GWCalendarUtils.clearTime(result);
        result.set(11, calendar.get(11));
        long currentMillis = calendar.getTimeInMillis();
        long previousMillis = result.getTimeInMillis();
        for (nextMillis = previousMillis + (long)(step * 60000); currentMillis >= nextMillis; nextMillis += (long)(step * 60000)) {
            result.add(12, step);
            previousMillis = nextMillis;
        }
        if (nextMillis - currentMillis <= currentMillis - previousMillis) {
            result.add(12, step);
        }
        logger.debug((Object)("rounded " + DateAndTimeFormattingUtils.calendarToLogString(calendar) + " > " + DateAndTimeFormattingUtils.calendarToLogString(result)));
        assert (result.getTimeZone().equals(calendar.getTimeZone()));
        return result;
    }

    @Tested
    public static int calculatePositionInDay(Day currentDay, Calendar calendar, int step) {
        if (currentDay == null) {
            throw new IllegalArgumentException("currentDay is null");
        }
        int position = -1;
        Calendar date = GWCalendarUtils.roundCalendarToMinutes(calendar, step);
        Calendar day = GWCalendarUtils.convertDayToCalendar(currentDay, calendar.getTimeZone());
        int intervals = 1440 / step;
        if (date.getTimeInMillis() >= day.getTimeInMillis()) {
            position = -2;
            for (int i = 0; i < intervals; ++i) {
                if (date.getTimeInMillis() == day.getTimeInMillis()) {
                    position = i;
                    break;
                }
                day.add(12, step);
            }
        }
        assert (position < intervals && position >= -2) : "invalid position: " + position + " (for " + currentDay + ", " + DateAndTimeFormattingUtils.calendarToLogString(calendar) + ", " + step + ')';
        return position;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DayNameLength {
        FULL,
        MEDIUM,
        SHORTEST;

    }
}

