/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar;

import com.appframework.components.ArrayIcon;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public abstract class MultilineLabel
extends OrientablePanel {
    private static Logger logger = Logger.getLogger(MultilineLabel.class);
    private volatile int labelHeight = 0;
    protected Insets insets = new Insets(2, 2, 2, 2);
    protected int iconTextGap = 3;
    protected int iconIconGap = 2;
    protected int iconXOffset = 2;
    protected int iconYOffset = 4;
    protected String text = "";
    private ImageIcon statusIcon = null;
    private List substrings = new ArrayList();
    private int oldWidth = 0;
    protected boolean isMultiLine = true;
    protected boolean isLTR = UIUtils.getComponentOrientation().isLeftToRight();

    public MultilineLabel() {
        this("");
    }

    public MultilineLabel(String text) {
        this.setText(text);
    }

    public void setText(String theText) {
        this.text = theText == null ? "" : theText;
    }

    public void setStatusIcon(ImageIcon statusIcon) {
        this.statusIcon = statusIcon;
    }

    public void setStatusIcon(ArrayList icons) {
        if (icons.size() == 1) {
            this.statusIcon = (ImageIcon)icons.get(0);
        } else if (icons.size() > 1) {
            this.statusIcon = new ArrayIcon(icons.toArray(new Icon[icons.size()]), 1, 0);
        }
    }

    public ImageIcon getStatusIcon() {
        return this.statusIcon;
    }

    protected int getStatusIconWidth() {
        return this.statusIcon != null ? this.statusIcon.getIconWidth() : 0;
    }

    public Dimension getPreferredSize() {
        if (this.isMultiLine) {
            return new Dimension(this.getWidth(), this.getPreferredHeight(this.getWidth()));
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int textWidth = SwingUtilities.computeStringWidth(fm, this.text);
        int height = this.insets.top + fm.getHeight() + this.insets.bottom;
        int width = this.insets.left + this.getStatusIconWidth() + this.iconTextGap + textWidth + this.insets.right;
        return new Dimension(width, height);
    }

    public int getPreferredHeight(int width) {
        this.updateSubstrings(width);
        return this.labelHeight;
    }

    private void updateSubstrings(int width) {
        if (this.oldWidth != width) {
            this.substrings.clear();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            if (this.isMultiLine) {
                this.substrings = UIUtils.breakStringIntoSubstrings(this.text, fontMetrics, width - (this.insets.left + this.insets.right) * 2 - this.getStatusIconWidth());
            } else {
                this.substrings.add(this.text);
            }
            this.labelHeight = this.insets.top + fontMetrics.getHeight() * this.substrings.size() + this.insets.bottom;
            this.oldWidth = width;
        }
    }

    public final void paint(Graphics g) {
        g = UIUtils.enableAntialiasing(g);
        super.paint(g);
        this.paintStatusMargin(g);
        this.paintSelection(g);
        this.paintIcons(g);
        this.paintMultilineText(g);
    }

    protected void paintStatusMargin(Graphics g) {
    }

    protected void paintIcons(Graphics g) {
        if (this.statusIcon != null) {
            int x = this.isLTR ? this.iconXOffset : this.getWidth() - this.iconXOffset - this.statusIcon.getIconWidth();
            this.statusIcon.paintIcon(this, g, x, this.iconYOffset);
        }
    }

    protected int getIconX(int inset, int iconWidth) {
        int x = this.isLTR ? inset : this.getWidth() - iconWidth - inset;
        return x;
    }

    protected int getTextStartX() {
        return this.insets.left + this.getStatusIconWidth() + this.iconTextGap;
    }

    protected int getTextAreaWidth() {
        return this.getWidth();
    }

    private void paintMultilineText(Graphics g) {
        this.updateSubstrings(this.getTextAreaWidth());
        g.setColor(this.getForeground());
        int nSize = this.substrings.size();
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        for (int i = 0; i < nSize; ++i) {
            int x;
            String text = (String)this.substrings.get(i);
            if (this.isLTR) {
                x = this.getTextStartX();
            } else {
                int textWidth = SwingUtilities.computeStringWidth(metrics, text);
                x = this.getWidth() - this.getTextStartX() - textWidth;
            }
            g.drawString(text, x, g.getFontMetrics().getHeight() * (i + 1) - 2);
        }
    }

    protected int getSelectionX(int width) {
        if (this.isLTR) {
            return width;
        }
        return this.getWidth() - width;
    }

    protected abstract void paintSelection(Graphics var1);
}

