/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.ToolBarProperties;

import com.novell.gw.jclient.api.enums.CalendarViewType;
import com.novell.gw.jclient.application.ExtendedGWTable;
import com.novell.gw.jclient.application.GWTable;
import com.novell.gw.jclient.application.controls.ColoredScrollPane;
import com.novell.gw.jclient.application.controls.basicdialogs.OkCancelDialog;
import com.novell.gw.jclient.application.controls.gwcalendar.ToolBarProperties.NewViewListItemDialog;
import com.novell.gw.jclient.application.controls.gwcalendar.ToolBarProperties.PropertiesViewList;
import com.novell.gw.jclient.application.controls.gwcalendar.ToolBarProperties.PropertiesViewListItem;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButton;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;

public class CalendarViewPropertiesDialog
extends OkCancelDialog {
    private GWTable table;
    private PropertiesViewList itemList;
    private OrientableButton btnMoveUp;
    private OrientableButton btnMoveDown;
    private OrientableButton btnEdit;
    private OrientableButton btnDelete;
    private OrientableRadioButton rbtnSimple;
    private OrientableRadioButton rbtnExtended;
    public static final int VIEW_SIMPLE = 0;
    public static final int VIEW_EXTENDED = 1;

    public CalendarViewPropertiesDialog(JFrame frame, PropertiesViewList theItemList, int view) {
        super(frame);
        this.buildUI(theItemList, view);
    }

    public CalendarViewPropertiesDialog(JDialog dialog, PropertiesViewList theItemList, int theView) {
        super(dialog);
        this.buildUI(theItemList, theView);
    }

    private void buildUI(PropertiesViewList theItemList, int theView) {
        this.itemList = new PropertiesViewList(theItemList);
        this.initTable();
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout(5, 5));
        ColoredScrollPane tableScroll = new ColoredScrollPane(this.table);
        OrientableLabel lbl = new OrientableLabel(StringResources.VIEW_LIST);
        lbl.setLabelFor(tableScroll);
        contentPane.add((Component)tableScroll, "Center");
        contentPane.add((Component)lbl, "North");
        contentPane.add((Component)this.buildButtonPanel(), "After");
        contentPane.add((Component)this.buildRBtnPanel(), "South");
        tableScroll.setPreferredSize(new Dimension(200, this.table.getPreferredSize().height));
        contentPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setTitle(StringResources.CALENDAR_VIEW_PROPERTIES);
        this.pack();
        this.setModal(true);
        this.rbtnSimple.setSelected(theView == 0);
        this.rbtnExtended.setSelected(theView == 1);
        this.setLocationRelativeTo(null);
        this.setEnableButtons(this.itemList.size() > 1);
        if (this.itemList.size() == 1) {
            this.btnEdit.setEnabled(true);
        }
    }

    private JPanel buildButtonPanel() {
        OrientablePanel pnlBtn = new OrientablePanel(new BorderLayout());
        OrientablePanel pnl = new OrientablePanel(new GridLayout(7, 1, 5, 5));
        this.btnMoveUp = new OrientableButton(StringResources.MOVE_UP);
        this.btnMoveDown = new OrientableButton(StringResources.MOVE_DOWN);
        OrientableButton btnNew = new OrientableButton(StringResources.NEW_D);
        this.btnEdit = new OrientableButton(StringResources.EDIT_D);
        this.btnDelete = new OrientableButton(StringResources.DELETE);
        this.btnMoveUp.addActionListener(new MoveUpAction());
        this.btnMoveDown.addActionListener(new MoveDownAction());
        btnNew.addActionListener(new NewItemAction());
        this.btnEdit.addActionListener(new EditItemAction());
        this.btnDelete.addActionListener(new DeleteItemAction());
        pnl.add(this.getBtnOk());
        pnl.add(this.getBtnCancel());
        pnl.add(this.btnMoveUp);
        pnl.add(this.btnMoveDown);
        pnl.add(btnNew);
        pnl.add(this.btnEdit);
        pnl.add(this.btnDelete);
        pnlBtn.add((Component)pnl, "North");
        return pnlBtn;
    }

    private JPanel buildRBtnPanel() {
        OrientablePanel pnlMain = new OrientablePanel(new BorderLayout());
        OrientablePanel pnl = new OrientablePanel(new BorderLayout(15, 0));
        this.rbtnSimple = new OrientableRadioButton(StringResources.SIMPLE_NAVIGATION);
        this.rbtnExtended = new OrientableRadioButton(StringResources.EXTENDED_NAVIGATION);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.rbtnSimple);
        bg.add(this.rbtnExtended);
        pnl.add((Component)this.rbtnSimple, "Before");
        pnl.add((Component)this.rbtnExtended, "After");
        pnlMain.add((Component)pnl, "Before");
        this.rbtnSimple.setSelected(true);
        return pnlMain;
    }

    private void initTable() {
        this.table = new ExtendedGWTable(new TableModel());
        this.table.setSelectionMode(0);
        if (this.itemList.size() != 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
        this.table.setShowGrid(false);
    }

    public PropertiesViewList getButtonList() {
        return this.itemList;
    }

    public int getView() {
        if (this.rbtnSimple.isSelected()) {
            return 0;
        }
        return 1;
    }

    public boolean showDialog() {
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        return this.isOkActionProcessed();
    }

    private void setEnableButtons(boolean t) {
        this.btnMoveDown.setEnabled(t);
        this.btnMoveUp.setEnabled(t);
        this.btnDelete.setEnabled(t);
        this.btnEdit.setEnabled(t);
    }

    private class EditItemAction
    extends AbstractAction {
        private EditItemAction() {
        }

        public void actionPerformed(ActionEvent e) {
            int row = CalendarViewPropertiesDialog.this.table.getSelectedRow();
            if (row == -1) {
                return;
            }
            NewViewListItemDialog dialog = new NewViewListItemDialog((JDialog)CalendarViewPropertiesDialog.this, CalendarViewPropertiesDialog.this.itemList.getListItem(row));
            if (dialog.showDialog()) {
                CalendarViewPropertiesDialog.this.itemList.setName(row, dialog.getName());
                CalendarViewPropertiesDialog.this.itemList.setView(row, dialog.getView());
                ((TableModel)CalendarViewPropertiesDialog.this.table.getModel()).fireTableDataChanged();
            }
        }
    }

    private class DeleteItemAction
    extends AbstractAction {
        private DeleteItemAction() {
        }

        public void actionPerformed(ActionEvent e) {
            block3: {
                CalendarViewPropertiesDialog.this.itemList.remove(CalendarViewPropertiesDialog.this.table.getSelectedRow());
                try {
                    ((TableModel)CalendarViewPropertiesDialog.this.table.getModel()).fireTableDataChanged();
                }
                catch (IllegalArgumentException exc) {
                    if (CalendarViewPropertiesDialog.this.itemList.size() == 0) break block3;
                    CalendarViewPropertiesDialog.this.table.setRowSelectionInterval(CalendarViewPropertiesDialog.this.itemList.size() - 1, CalendarViewPropertiesDialog.this.itemList.size() - 1);
                }
            }
            CalendarViewPropertiesDialog.this.setEnableButtons(CalendarViewPropertiesDialog.this.itemList.size() > 1);
            if (CalendarViewPropertiesDialog.this.itemList.size() == 1) {
                CalendarViewPropertiesDialog.this.btnEdit.setEnabled(true);
            }
        }
    }

    private class NewItemAction
    extends AbstractAction {
        private NewItemAction() {
        }

        public void actionPerformed(ActionEvent e) {
            NewViewListItemDialog dialog = new NewViewListItemDialog((JDialog)CalendarViewPropertiesDialog.this, new PropertiesViewListItem("", CalendarViewType.DAILY));
            if (dialog.showDialog()) {
                CalendarViewPropertiesDialog.this.itemList.add(dialog.getName(), dialog.getView());
                ((TableModel)CalendarViewPropertiesDialog.this.table.getModel()).fireTableDataChanged();
                CalendarViewPropertiesDialog.this.table.setRowSelectionInterval(CalendarViewPropertiesDialog.this.itemList.size() - 1, CalendarViewPropertiesDialog.this.itemList.size() - 1);
                CalendarViewPropertiesDialog.this.setEnableButtons(CalendarViewPropertiesDialog.this.itemList.size() > 1);
            }
        }
    }

    private class MoveDownAction
    extends AbstractAction {
        private MoveDownAction() {
        }

        public void actionPerformed(ActionEvent e) {
            int selected = CalendarViewPropertiesDialog.this.table.getSelectedRow();
            if (selected < CalendarViewPropertiesDialog.this.itemList.size() - 1) {
                CalendarViewPropertiesDialog.this.itemList.changeItems(selected, selected + 1);
                ((TableModel)CalendarViewPropertiesDialog.this.table.getModel()).fireTableDataChanged();
                CalendarViewPropertiesDialog.this.table.setRowSelectionInterval(selected + 1, selected + 1);
            }
        }
    }

    private class MoveUpAction
    extends AbstractAction {
        private MoveUpAction() {
        }

        public void actionPerformed(ActionEvent e) {
            int selected = CalendarViewPropertiesDialog.this.table.getSelectedRow();
            if (selected > 0) {
                CalendarViewPropertiesDialog.this.itemList.changeItems(selected, selected - 1);
                ((TableModel)CalendarViewPropertiesDialog.this.table.getModel()).fireTableDataChanged();
                CalendarViewPropertiesDialog.this.table.setRowSelectionInterval(selected - 1, selected - 1);
            }
        }
    }

    private class TableModel
    extends AbstractTableModel {
        private TableModel() {
        }

        public int getRowCount() {
            return CalendarViewPropertiesDialog.this.itemList.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return CalendarViewPropertiesDialog.this.itemList.getName(rowIndex);
            }
            if (columnIndex == 1) {
                return CalendarViewPropertiesDialog.this.itemList.getListItem(rowIndex);
            }
            return null;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public String getColumnName(int column) {
            if (column == 0) {
                return StringResources.NAME;
            }
            if (column == 1) {
                return StringResources.VIEW;
            }
            return null;
        }
    }
}

