/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.ToolBarProperties;

import com.novell.gw.jclient.api.enums.CalendarViewType;
import com.novell.gw.jclient.application.controls.gwcalendar.ToolBarProperties.PropertiesViewList;
import com.novell.gw.jclient.application.controls.gwcalendar.ToolBarProperties.PropertiesViewListItem;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NewViewListItemDialog
extends GWDialog {
    private GWTextField tf;
    private OrientableComboBox cb;
    private PropertiesViewListItem item;
    private Object[] cbItems;
    private boolean btnOKPressed = false;

    public NewViewListItemDialog(JDialog owner, PropertiesViewListItem theItem) {
        super(owner);
        this.item = theItem;
        this.initComponents();
        this.buildUI();
        this.setTitle(StringResources.NEW_VIEW);
        this.setModal(true);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void buildUI() {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout(15, 5));
        OrientablePanel pnl = new OrientablePanel(new GridLayout(2, 1, 5, 5));
        OrientableLabel lbl = new OrientableLabel(StringResources.NAME + ':');
        pnl.add(lbl);
        lbl = new OrientableLabel(StringResources.VIEW + ':');
        pnl.add(lbl);
        contentPane.add((Component)pnl, "Before");
        pnl = new OrientablePanel(new GridLayout(2, 1, 5, 5));
        pnl.add(this.tf);
        pnl.add(this.cb);
        contentPane.add((Component)pnl, "Center");
        pnl = new OrientablePanel(new GridLayout(2, 1, 5, 5));
        pnl.add(this.btnOK);
        pnl.add(this.btnCancel);
        contentPane.add((Component)pnl, "After");
        contentPane.setBorder(new EmptyBorder(10, 10, 10, 10));
    }

    private void initComponents() {
        int nSize = PropertiesViewList.getItemTypesList().size();
        this.cbItems = new Object[nSize];
        for (int i = 0; i < nSize; ++i) {
            this.cbItems[i] = PropertiesViewList.getItemTypesList().get(i);
        }
        this.tf = new GWTextField(this.item.getName());
        this.tf.getDocument().addDocumentListener(new AddFieldListener());
        this.cb = new OrientableComboBox(this.cbItems);
        this.cb.setSelectedIndex(this.getSelectedIndex(this.cbItems));
        this.tf.setPreferredSize(new Dimension(200, this.tf.getPreferredSize().height));
        if (this.tf.getText().length() == 0) {
            this.btnOK.setEnabled(false);
        }
        this.btnOK.addActionListener(new BtnOkAction());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                super.windowClosed(e);
            }
        });
    }

    private int getSelectedIndex(Object[] o) {
        for (int i = 0; i < o.length; ++i) {
            if (!((PropertiesViewListItem)o[i]).getViewName().equals(this.item.getViewName())) continue;
            return i;
        }
        return -1;
    }

    public String getName() {
        return this.tf.getText();
    }

    public CalendarViewType getView() {
        return ((PropertiesViewListItem)this.cb.getSelectedItem()).getView();
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.btnOKPressed;
    }

    private class AddFieldListener
    implements DocumentListener {
        private AddFieldListener() {
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
            NewViewListItemDialog.this.btnOK.setEnabled(true);
        }

        public void removeUpdate(DocumentEvent e) {
            if (NewViewListItemDialog.this.tf.getText().length() == 0) {
                NewViewListItemDialog.this.btnOK.setEnabled(false);
            }
        }
    }

    private class BtnOkAction
    implements ActionListener {
        private BtnOkAction() {
        }

        public void actionPerformed(ActionEvent e) {
            NewViewListItemDialog.this.btnOKPressed = true;
        }
    }
}

