/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar;

import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Calendar;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;

public class TypingWindow {
    private static Logger logger = Logger.getLogger(TypingWindow.class);
    private static TypingWindow instance;
    private TypingDialog typingDialog;
    private String type;
    private Calendar currentTime = GWCalendarUtils.getToday();
    private MVCController controller;
    private boolean escPressed = false;

    public static TypingWindow getInstance(Window theOwner) {
        if (instance == null || TypingWindow.instance.typingDialog.getOwner() != theOwner) {
            instance = new TypingWindow(theOwner);
        }
        return instance;
    }

    public void show(String theItemType, Calendar theCurrentDate, String theText, Point theLocation, Dimension theSize, MVCController theController) {
        this.type = theItemType;
        this.currentTime = theCurrentDate;
        this.controller = theController;
        this.typingDialog.setText(theText);
        this.typingDialog.setLocation(theLocation);
        this.typingDialog.setSize(theSize);
        this.escPressed = false;
        this.typingDialog.setVisible(true);
    }

    private TypingWindow(Window theOwner) {
        if (!(theOwner instanceof JFrame)) {
            throw new IllegalArgumentException();
        }
        this.typingDialog = new TypingDialog((JFrame)theOwner);
    }

    public String getText() {
        return this.typingDialog.getText();
    }

    public void setText(String theText) {
        this.typingDialog.setText(theText);
    }

    public Calendar getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(Calendar currentTime) {
        this.currentTime = currentTime;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    private void processCreateNewItem() {
        String text = this.getText();
        if (text.trim().length() > 0) {
            this.controller.processCommand(new Command(1310, new PostedItemInformation(this.type, this.currentTime, text)));
        }
    }

    private void hideTypingFrame() {
        this.typingDialog.hide();
    }

    public static class PostedItemInformation {
        private String type;
        private Calendar currentTime;
        private String subject;

        public PostedItemInformation(String type, Calendar currentTime, String subject) {
            this.type = type;
            this.currentTime = currentTime;
            this.subject = subject;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Calendar getCurrentTime() {
            return this.currentTime;
        }

        public void setCurrentTime(Calendar currentTime) {
            this.currentTime = currentTime;
        }

        public String getSubject() {
            return this.subject;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }
    }

    private class TypingDialog
    extends JDialog {
        private JTextArea taText;

        public TypingDialog(JFrame theOwner) throws HeadlessException {
            super(theOwner);
            this.buildUI();
        }

        public TypingDialog(JDialog theOwner) throws HeadlessException {
            super(theOwner);
            this.buildUI();
        }

        private void buildUI() {
            this.setUndecorated(true);
            JPanel contactPane = (JPanel)this.getContentPane();
            this.taText = new GWTextArea();
            this.taText.addFocusListener(new FrameFocusListener());
            this.taText.addKeyListener(new FrameKeyListener());
            contactPane.add((Component)this.taText, "Center");
        }

        public String getText() {
            return this.taText.getText();
        }

        public void setText(String theText) {
            this.taText.setText(theText);
        }
    }

    private class FrameKeyListener
    extends KeyAdapter {
        private FrameKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27 || e.getKeyCode() == 10 || e.getKeyCode() == 9) {
                TypingWindow.this.escPressed = e.getKeyCode() == 27;
                TypingWindow.this.hideTypingFrame();
                return;
            }
            super.keyPressed(e);
        }
    }

    private class FrameFocusListener
    implements FocusListener {
        private FrameFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            TypingWindow.this.hideTypingFrame();
            if (!TypingWindow.this.escPressed) {
                TypingWindow.this.processCreateNewItem();
            }
        }
    }
}

