/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.calendarpanel;

import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.enums.CalendarViewType;
import com.novell.gw.jclient.application.commands.AttributeKey;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendar;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarController;
import com.novell.gw.jclient.application.controls.gwcalendar.ToolBarProperties.PropertiesViewList;
import com.novell.gw.jclient.application.controls.gwcalendar.calendarpanel.CalendarToolBar;
import com.novell.gw.jclient.application.interfaces.ISelectedItemsInfo;
import com.novell.gw.jclient.bl.om.items.ItemAndItemListInfo;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarToolBarController
extends MVCController<CalendarToolBar> {
    private static Logger logger = Logger.getLogger(CalendarToolBarController.class);

    public CalendarToolBarController(CalendarToolBar view, MVCController theParentController) {
        super(view, theParentController);
    }

    @Override
    protected void initListeners() {
        Level level = this.getFrameLevel();
        AppEventListener listener = new SELECTED_DATE_CHANGED_listener();
        AppEventListenerDescriptor descriptor = new AppEventListenerDescriptor(level, 70, listener);
        this.addListenerDescriptor(descriptor);
        listener = new ENABLE_PLUS_listener();
        descriptor = new AppEventListenerDescriptor(level, 1580, listener);
        this.addListenerDescriptor(descriptor);
        listener = new CALENDAR_TOOLBAR_CHANGED_listener();
        descriptor = new AppEventListenerDescriptor(level, 81, listener);
        this.addListenerDescriptor(descriptor);
        listener = new GWITEM_SELECTED_listener();
        descriptor = new AppEventListenerDescriptor(level, 20, listener);
        this.addListenerDescriptor(descriptor);
    }

    private class GWITEM_SELECTED_listener
    extends AppEventListener {
        private GWITEM_SELECTED_listener() {
        }

        public void handle(AppEvent theEvent) {
            Object o = theEvent.getData();
            if (o instanceof ISelectedItemsInfo) {
                ISelectedItemsInfo itemsInfo = (ISelectedItemsInfo)o;
                CalendarToolBar toolBar = (CalendarToolBar)CalendarToolBarController.this.getMVCView();
                CalendarViewType calendarViewTypeType = toolBar.getViewType();
                GWCalendar gwCalendar = (GWCalendar)CalendarToolBarController.this.getParentController().getMVCView();
                if (!itemsInfo.hasItems()) {
                    return;
                }
                if (calendarViewTypeType == CalendarViewType.DAILY && gwCalendar.getViewsToggleType() == CalendarViewType.DAILY) {
                    toolBar.setItemInfoForDaylyView(new ItemAndItemListInfo(itemsInfo.getItemList(), itemsInfo.getItem()));
                } else if (calendarViewTypeType == CalendarViewType.WEEKLY && gwCalendar.getViewsToggleType() == CalendarViewType.WEEKLY) {
                    toolBar.setItemInfoForWeeklyView(new ItemAndItemListInfo(itemsInfo.getItemList(), itemsInfo.getItem()));
                }
            }
        }
    }

    private class CALENDAR_TOOLBAR_CHANGED_listener
    extends AppEventListener {
        private CALENDAR_TOOLBAR_CHANGED_listener() {
        }

        public void handle(AppEvent theEvent) {
            ((CalendarToolBar)CalendarToolBarController.this.getMVCView()).fireRebuild((PropertiesViewList)theEvent.getData());
        }
    }

    private class ENABLE_PLUS_listener
    extends AppEventListener {
        private ENABLE_PLUS_listener() {
        }

        public void handle(AppEvent theEvent) {
            Object att = theEvent.getAttribute((Object)AttributeKey.CALENDAR);
            if (att != null) {
                MVCController topController = (MVCController)att;
                if (CalendarToolBarController.this.isChildOf(topController)) {
                    ((CalendarToolBar)CalendarToolBarController.this.getMVCView()).setMVCModel(theEvent.getData());
                }
            } else {
                ((CalendarToolBar)CalendarToolBarController.this.getMVCView()).setMVCModel(theEvent.getData());
            }
        }
    }

    private class SELECTED_DATE_CHANGED_listener
    extends AppEventListener {
        private SELECTED_DATE_CHANGED_listener() {
        }

        public void handle(AppEvent event) {
            CalendarViewType calendarViewTypeType = ((CalendarToolBar)CalendarToolBarController.this.getMVCView()).getViewType();
            Calendar selectedDate = (Calendar)event.getData();
            Date date = selectedDate.getTime();
            Date olddate = ((CalendarToolBar)CalendarToolBarController.this.getMVCView()).getDate();
            if (olddate != null && (olddate.getDay() != date.getDay() || olddate.getTime() + 8640000L < date.getTime() || olddate.getTime() - 8640000L > date.getTime())) {
                GWCalendarController gwCalendarController = ControlsUtils.getParentGWCalendarController(CalendarToolBarController.this);
                assert (gwCalendarController != null);
                if (calendarViewTypeType == CalendarViewType.DAILY) {
                    ((CalendarToolBar)CalendarToolBarController.this.getMVCView()).setItemInfoForDaylyView(null);
                    gwCalendarController.itemSelected(null);
                } else if (calendarViewTypeType == CalendarViewType.WEEKLY) {
                    ((CalendarToolBar)CalendarToolBarController.this.getMVCView()).setItemInfoForWeeklyView(null);
                    gwCalendarController.itemSelected(null);
                }
            }
            ((CalendarToolBar)CalendarToolBarController.this.getMVCView()).setDate(date);
            Object att = event.getAttribute((Object)AttributeKey.CALENDAR);
            if (att != null) {
                MVCController topController = (MVCController)att;
                if (CalendarToolBarController.this.isChildOf(topController)) {
                    ((CalendarToolBar)CalendarToolBarController.this.getMVCView()).setMVCModel(selectedDate);
                }
            } else {
                ((CalendarToolBar)CalendarToolBarController.this.getMVCView()).setMVCModel(selectedDate);
            }
        }
    }
}

