/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes;

import com.appframework.level.LevelManager;
import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.ActiveItemLabel;
import com.novell.gw.jclient.application.controls.gwcalendar.StaticItemLabel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.AcceptsDroppedCalendarItems;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.AppointmentPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.CalendarItemDragGestureListener;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.StaticCalendarItemPanel;
import com.novell.gw.jclient.bl.om.items.ItemAndItemListInfo;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.event.MouseListener;
import java.util.Date;
import org.apache.log4j.Logger;

public abstract class ActiveCalendarItemPanel
extends StaticCalendarItemPanel
implements AcceptsDroppedCalendarItems {
    private static Logger logger = Logger.getLogger(ActiveCalendarItemPanel.class);
    private MouseListener labelMouseListener;
    private Rectangle dragRect;

    public ActiveCalendarItemPanel(boolean multiLineLabels, MVCController theParentController, MouseListener theLabelMouseListener) {
        super(multiLineLabels, theParentController);
        this.labelMouseListener = theLabelMouseListener;
        this.setOpaque(false);
    }

    protected StaticItemLabel createLabel(boolean multiline, ItemAndItemListInfo itemAndItemListInfo) {
        ActiveItemLabel label = (ActiveItemLabel)this.getLabelForItem(multiline, itemAndItemListInfo);
        label.addMouseListener(this.labelMouseListener);
        CalendarItemDragGestureListener dragListener = new CalendarItemDragGestureListener(label, ControlsUtils.getUserGuid(this.getController()));
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(label, 3, dragListener);
        return label;
    }

    protected StaticItemLabel getLabelForItem(boolean multiline, ItemAndItemListInfo itemAndItemListInfo) {
        return new ActiveItemLabel(multiline, itemAndItemListInfo, this.getBackground(), this.getController(), true);
    }

    protected void disposeLabel(StaticItemLabel theLabel) {
        ActiveItemLabel label = (ActiveItemLabel)theLabel;
        LevelManager.release(label.getController().getLevel());
        label.removeMouseListener(this.labelMouseListener);
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)UIUtils.enableAntialiasing(g);
        this.drawDragRect(g2);
        super.paint(g);
    }

    public void highlightDragHours(Point theLocation, long theDurationInMinutes) {
        int x = 2;
        int y = 2;
        int w = this.getWidth() - 4;
        int h = this.getHeight() - 4;
        this.dragRect = new Rectangle(x, y, w, h);
        Rectangle rect = new Rectangle(x, y - 20, w, h + 40);
        this.scrollRectToVisible(rect);
        this.repaint();
    }

    public void clearHighlightDragHours() {
        this.dragRect = null;
        this.repaint();
    }

    private void drawDragRect(Graphics2D g2) {
        if (this.dragRect == null) {
            return;
        }
        g2.setColor(Color.BLUE);
        g2.setStroke(AppointmentPanel.HOUR_LINE_STROKE);
        g2.drawRect(this.dragRect.x, this.dragRect.y, this.dragRect.width, this.dragRect.height);
        g2.setStroke(AppointmentPanel.DEFAULT_LINE_STROKE);
        g2.setColor(Color.BLACK);
    }

    public Date getDragDate() {
        if (this.dragRect != null) {
            return this.getCurrentDate().getTime();
        }
        return null;
    }
}

