/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes;

import com.appframework.Application;
import com.appframework.drag.DragManager;
import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.novell.gw.ab.UnresolvedAddressException;
import com.novell.gw.jclient.api.enums.ItemType;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.item.MoveItemCallBack;
import com.novell.gw.jclient.application.actions.send.ActionSend;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.AllDayEventsBoxesPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.AcceptsDroppedCalendarItems;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.AppointmentPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.NotesPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.TaskPanel;
import com.novell.gw.jclient.application.controls.itemedit.ComposeMode;
import com.novell.gw.jclient.application.dialogs.ChangeToManageDialog;
import com.novell.gw.jclient.application.frames.FramesFactory;
import com.novell.gw.jclient.application.frames.compose.FrameCompose;
import com.novell.gw.jclient.application.frames.compose.FrameComposeActionList;
import com.novell.gw.jclient.application.frames.compose.FrameComposePostedItem;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.impl.dnd.GWFlavors;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.items.AbstractCalendarItem;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import com.novell.gw.jclient.bl.om.items.sendoptions.ComposeItemSendOptions;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.io.IOException;
import java.util.Date;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class CalendarItemDropTargetListener
extends DropTargetAdapter {
    private static final Logger logger = Logger.getLogger(CalendarItemDropTargetListener.class);
    protected AcceptsDroppedCalendarItems panel;
    private MVCController controller;
    private ItemType itemType;
    private boolean isAllDayEvent = false;

    public CalendarItemDropTargetListener(AcceptsDroppedCalendarItems thePanel, MVCController theController) {
        this.panel = thePanel;
        this.controller = theController;
        if (this.panel instanceof AppointmentPanel) {
            this.itemType = ItemType.APPT;
        } else if (this.panel instanceof AllDayEventsBoxesPanel) {
            this.itemType = ItemType.APPT;
            this.isAllDayEvent = true;
        } else if (this.panel instanceof NotesPanel) {
            this.itemType = ItemType.NOTE;
        } else if (this.panel instanceof TaskPanel) {
            this.itemType = ItemType.TODO;
        }
    }

    protected void moveOrCopyItem(Transferable data, boolean isMove) throws UnresolvedAddressException, GWCommandException {
        Date newStartDate;
        AbstractCalendarItem newItem;
        logger.debug((Object)"moveItem entered");
        AbstractItem item = DragManager.getInstance().getItem();
        assert (item != null) : "item is null";
        boolean changeType = this.itemType != item.getNativeItem().getItemType() && this.itemType != null;
        boolean wasCalendarItem = item instanceof AbstractCalendarItem;
        if (changeType) {
            newItem = isMove ? (AbstractCalendarItem)ChangeToManageDialog.changeItemTo(item, this.itemType, item.getNativeItem().isHTMLMessage(), false) : (AbstractCalendarItem)ChangeToManageDialog.changeItemTo(item, this.itemType, true, false, false);
            if (newItem == null) {
                return;
            }
        } else {
            assert (item instanceof AbstractCalendarItem) : "illegal item type: " + item.getClass().getName();
            newItem = (AbstractCalendarItem)item;
        }
        if ((newStartDate = this.getStartDate(item.getDate())) == null) {
            logger.debug((Object)"Abnormal function termination - new start date is NULL!");
            return;
        }
        Date[] startDates = new Date[]{newStartDate};
        long duration = this.getItemDuration(item);
        Date newEndDate = new Date(newStartDate.getTime() + duration);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("duration: " + duration));
            logger.debug((Object)("newStartDate: " + newStartDate));
            logger.debug((Object)("newEndDate: " + newEndDate));
        }
        if (item.isPersonal()) {
            logger.debug((Object)"original item was personal");
            if (this.itemType != item.getNativeItem().getItemType()) {
                if (this.isAllDayEvent) {
                    ((AppointmentItem)newItem).setAllDayEvent(true);
                }
                newItem.setStartDates(startDates);
                newItem.setEndDate(newEndDate);
                FrameComposePostedItem frameCompose = new FrameComposePostedItem(newItem, false, ComposeMode.NEW, ControlsUtils.getUserGuid(this.controller));
                frameCompose.showMe();
                GlobalCommand command = new GlobalCommand(480, frameCompose);
                ((FrameComposeActionList)frameCompose.getController()).processCommand(command);
            } else {
                assert (wasCalendarItem) : "original item was not AbstractCalendarItem, but was supposed to be";
                this.checkResetAllDayEvent((AbstractCalendarItem)item);
                ((AbstractCalendarItem)item).setStartDates(startDates);
                ((AbstractCalendarItem)item).setEndDate(newEndDate);
                MoveItemCallBack callBack = new MoveItemCallBack();
                String userGuid = ControlsUtils.getUserGuid(this.controller);
                GWCommandManager.getInstance(userGuid).modifyItem(item, callBack);
            }
        } else if (!wasCalendarItem) {
            logger.debug((Object)"original item was NOT calandar item");
            assert (changeType) : "type of item did not changed but was supposed to change";
            newItem.setStartDates(startDates);
            newItem.setEndDate(newEndDate);
            if (this.isAllDayEvent) {
                logger.debug((Object)"all day event");
                ((AppointmentItem)newItem).setAllDayEvent(true);
            }
            MessageUtils.showBusyCursor(true);
            FrameCompose frameCompose = FramesFactory.getComposeFrame(newItem, true, ComposeMode.NEW, ControlsUtils.getUserGuid(this.controller));
            MessageUtils.showBusyCursor(false);
            frameCompose.showMe();
            GlobalCommand command = new GlobalCommand(480, frameCompose);
            ((FrameComposeActionList)frameCompose.getController()).processCommand(command);
        } else if (item.canResend()) {
            this.moveFromMeItem(item, newItem, changeType);
        } else if (item.isReceived()) {
            newItem = (AbstractCalendarItem)ChangeToManageDialog.changeItemTo(item, this.itemType, true, false, false);
            newItem.setStartDates(startDates);
            newItem.setEndDate(newEndDate);
            this.moveRecievedItem(newItem);
        }
        logger.debug((Object)"moveItem exited");
    }

    private void moveRecievedItem(AbstractItem newItem) {
        FrameComposePostedItem frameCompose = new FrameComposePostedItem(newItem, false, ComposeMode.NEW, ControlsUtils.getUserGuid(this.controller));
        frameCompose.showMe();
        GlobalCommand command = new GlobalCommand(480, frameCompose);
        ((FrameComposeActionList)frameCompose.getController()).processCommand(command);
    }

    private void moveFromMeItem(AbstractItem oldItem, AbstractItem newItem, boolean changeType) throws GWCommandException {
        Date newStartDate = this.getStartDate(oldItem.getDate());
        if (newStartDate == null) {
            logger.debug((Object)"Abnormal function termination - new start date is NULL!");
            return;
        }
        Date[] startDates = new Date[]{newStartDate};
        long duration = this.getItemDuration(oldItem);
        Date newEndDate = new Date(newStartDate.getTime() + duration);
        int result = changeType ? 0 : JOptionPane.showConfirmDialog(Application.getParentForModalDialogs(), StringResources.RESCHEDULE_QUESTION, StringResources.NOVELL_GROUPWISE, 1);
        if (result == 0) {
            FrameCompose frameCompose = this.createResendFrame((AbstractCalendarItem)newItem, startDates, newEndDate, changeType, 0);
            if (frameCompose == null) {
                return;
            }
            ActionSend actionSend = (ActionSend)((FrameComposeActionList)frameCompose.getController()).getAction(ActionKey.SEND_ITEM);
            actionSend.setDisableSignature(true);
            frameCompose.showMe();
            GlobalCommand command = new GlobalCommand(480, frameCompose);
            ((FrameComposeActionList)frameCompose.getController()).processCommand(command);
        } else if (result == 1) {
            int retractOption = oldItem.getNativeItem().getBoxType() == 2 ? 0 : 1;
            FrameCompose frameCompose = this.createResendFrame((AbstractCalendarItem)newItem, startDates, newEndDate, changeType, retractOption);
            if (frameCompose == null) {
                return;
            }
            GlobalCommand command = new GlobalCommand(480, frameCompose);
            ((FrameComposeActionList)frameCompose.getController()).processCommand(command);
            frameCompose.setSpellCheckSuppressed(true);
            ActionSend actionSend = (ActionSend)((FrameComposeActionList)frameCompose.getController()).getAction(ActionKey.SEND_ITEM);
            actionSend.setDisableSignature(true);
            actionSend.actionPerformed(null);
            actionSend.setDisableSignature(false);
        }
    }

    private long getItemDuration(AbstractItem item) {
        assert (item != null) : "item is null";
        long duration = -1L;
        if (item instanceof AbstractCalendarItem) {
            duration = this.getItemDuration((AbstractCalendarItem)item);
        }
        if (duration < 0L || duration > 86400000L) {
            duration = this.isAllDayEvent ? 86400000L : 3600000L;
        }
        assert (duration >= 0L && duration <= 86400000L) : "illegal duration value: " + duration + " (ms)";
        return duration;
    }

    protected long getItemDuration(AbstractCalendarItem originalItem) {
        if (this.panel instanceof TaskPanel && originalItem instanceof AppointmentItem) {
            return 1800000L;
        }
        if (this.panel instanceof AppointmentPanel && originalItem instanceof AppointmentItem && ((AppointmentItem)originalItem).isAllDayEvent()) {
            return 3600000L;
        }
        if (this.panel instanceof AllDayEventsBoxesPanel && originalItem instanceof AppointmentItem && !((AppointmentItem)originalItem).isAllDayEvent()) {
            return 86400000L;
        }
        if (this.isAllDayEvent && !(originalItem instanceof AppointmentItem)) {
            return 86400000L;
        }
        return originalItem.getDuration();
    }

    private boolean checkResetAllDayEvent(AbstractCalendarItem originalItem) {
        if (this.panel instanceof AppointmentPanel && originalItem instanceof AppointmentItem && ((AppointmentItem)originalItem).isAllDayEvent()) {
            ((AppointmentItem)originalItem).setAllDayEvent(false);
            return false;
        }
        if (this.panel instanceof AllDayEventsBoxesPanel && originalItem instanceof AppointmentItem && !((AppointmentItem)originalItem).isAllDayEvent()) {
            ((AppointmentItem)originalItem).setAllDayEvent(true);
            return true;
        }
        return false;
    }

    protected FrameCompose createResendFrame(AbstractCalendarItem item, Date[] startDates, Date newEndDate, boolean typeChanged, int resendRetractOption) throws GWCommandException {
        AbstractCalendarItem newItem = !typeChanged ? (AbstractCalendarItem)GWEngineUtils.composeResendItem(item, resendRetractOption) : item;
        if (newItem == null) {
            return null;
        }
        this.checkResetAllDayEvent(newItem);
        ComposeItemSendOptions composeItemSendOptions = newItem.getComposeItemSendOptions(null);
        if (newItem.isRecurring()) {
            Date[] newStartDates = newItem.getStartDates();
            long timeDifference = startDates[0].getTime() - newStartDates[0].getTime();
            for (Date curStartDate : newStartDates) {
                curStartDate.setTime(curStartDate.getTime() + timeDifference);
            }
            newItem.setStartDates(newStartDates);
        } else {
            newItem.setStartDates(startDates);
        }
        newItem.setEndDate(newEndDate);
        FrameCompose frameCompose = FramesFactory.getComposeFrame(newItem, true, ComposeMode.NEW, ControlsUtils.getUserGuid(this.controller));
        if (composeItemSendOptions != null) {
            frameCompose.getItemEdit().setSendOptions(composeItemSendOptions);
        }
        return frameCompose;
    }

    public void dragOver(DropTargetDragEvent dtde) {
        String userGuid = ControlsUtils.getUserGuid(this.controller);
        try {
            if (!dtde.getCurrentDataFlavorsAsList().contains(GWFlavors.userGuidFlavor) || !userGuid.equals(dtde.getTransferable().getTransferData(GWFlavors.userGuidFlavor))) {
                dtde.rejectDrag();
            }
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        AbstractItem item = DragManager.getInstance().getItem();
        if (!this.panel.acceptsDraggableItem(item)) {
            logger.debug((Object)("panel (" + this.panel.getClass().getName() + ") rejected item (" + item + ')'));
            dtde.rejectDrag();
        }
        long durationInMinutes = this.getItemDuration(item) / 60000L;
        this.panel.highlightDragHours(dtde.getLocation(), durationInMinutes);
    }

    public void dragExit(DropTargetEvent dtde) {
        this.panel.clearHighlightDragHours();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(DropTargetDropEvent dtde) {
        try {
            if (dtde.getCurrentDataFlavorsAsList().contains(GWFlavors.transferItemsFlavor)) {
                MessageUtils.showBusyCursor(true);
                dtde.acceptDrop(dtde.getDropAction());
                Transferable data = dtde.getTransferable();
                if (dtde.getDropAction() == 1) {
                    this.moveOrCopyItem(data, false);
                } else if (dtde.getDropAction() == 2) {
                    this.moveOrCopyItem(data, true);
                }
                MessageUtils.showBusyCursor(false);
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        finally {
            dtde.dropComplete(true);
            this.panel.clearHighlightDragHours();
        }
    }

    protected Date getStartDate(Date date) {
        return this.panel.getDragDate();
    }

    public MVCController getController() {
        return this.controller;
    }
}

