/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes;

import com.appframework.level.LevelManager;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.message.IAppointment;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.ActiveItemLabel;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarController;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarPopup;
import com.novell.gw.jclient.application.controls.gwcalendar.StaticItemLabel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.BorderedCalendarItemPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.StaticCalendarItemPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.UnfocusablePopupMenu;
import com.novell.gw.jclient.application.controls.gwcalendar.monthly.monthlyview.Glass;
import com.novell.gw.jclient.application.controls.gwcalendar.monthly.monthlyview.GlassPanelLayout;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarUtils;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.ItemAndItemListInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Calendar;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLayeredPane;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarItemPanelPopup
extends UnfocusablePopupMenu {
    private static Logger logger = Logger.getLogger(CalendarItemPanelPopup.class);
    private StaticCalendarItemPanel contentPanel;
    private JLayeredPane mainPanel;
    private UnfocusablePopupMenu tipPopup;
    private ActiveItemLabel tipLabel;
    private TipMouseListener tipMouseAdapter;
    private MVCController parentController;

    public CalendarItemPanelPopup(MVCController controller) {
        this.parentController = controller;
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.mainPanel = new JLayeredPane();
        this.mainPanel.setLayout(new GlassPanelLayout());
        this.mainPanel.setBorder(null);
        Glass glass = new Glass();
        this.mainPanel.add((Component)glass, "Glass");
        this.mainPanel.setLayer(glass, JLayeredPane.MODAL_LAYER, 0);
        GlassPanelMouseHandler mouseHandler = new GlassPanelMouseHandler();
        glass.addMouseListener(mouseHandler);
        glass.addMouseMotionListener(mouseHandler);
        this.initToolTips();
        this.add((Component)this.mainPanel, "Center");
    }

    private void initToolTips() {
        this.tipPopup = new UnfocusablePopupMenu();
        this.tipPopup.setOpaque(false);
        this.tipPopup.setLayout(new BorderLayout());
        this.tipPopup.setBorder(BorderFactory.createEmptyBorder());
        this.tipPopup.setFocusOwner(this.getFocusOwner());
        this.tipMouseAdapter = new TipMouseListener();
    }

    public void setContentPanel(StaticCalendarItemPanel theContentPanel) {
        if (this.contentPanel != null) {
            this.mainPanel.remove(this.contentPanel);
            LevelManager.release(this.contentPanel.getController().getLevel());
            this.contentPanel.removeItems();
        }
        this.contentPanel = theContentPanel;
        if (this.contentPanel != null) {
            this.mainPanel.add((Component)this.contentPanel, "Center");
            this.mainPanel.setLayer(this.contentPanel, JLayeredPane.DEFAULT_LAYER, 0);
        }
        this.updateUI();
    }

    public boolean contens(BorderedCalendarItemPanel thePanel) {
        return this.contentPanel != null && this.contentPanel.getCurrentDate().equals(thePanel.getCurrentDate());
    }

    private StaticItemLabel getLabel(Point thePoint) {
        Component label = this.contentPanel.getComponentAt(thePoint);
        if (label == null) {
            return null;
        }
        if (label instanceof StaticItemLabel) {
            return (StaticItemLabel)label;
        }
        return null;
    }

    private void handleToolTip(MouseEvent e) {
        Point point = e.getPoint();
        StaticItemLabel label = this.getLabel(point);
        if (label == null) {
            return;
        }
        if (label.equals(this.tipLabel)) {
            return;
        }
        this.closeToolTip();
        Rectangle bounds = label.getBounds();
        Dimension size = new Dimension(label.getPreferredSize());
        int X = bounds.x;
        int Y = bounds.y;
        AbstractItem item = label.getItem();
        this.tipLabel = (ActiveItemLabel)this.contentPanel.createLabel(false, new ItemAndItemListInfo(label.getItemList(), item));
        this.tipLabel.setPaintSelectionBorder(true);
        this.tipLabel.addMouseListener(this.tipMouseAdapter);
        this.tipLabel.setSelected(label.isSelected());
        this.tipPopup.add((Component)this.tipLabel, "Center");
        if (item instanceof AppointmentItem) {
            this.tipLabel.setBackground(((IAppointment)item.getNativeItem()).getShowAsLevel().getColor());
        }
        size.width = size.width < this.contentPanel.getWidth() ? this.contentPanel.getWidth() : (size.width += 3);
        this.tipPopup.setPreferredSize(size);
        if (!UIUtils.getComponentOrientation().isLeftToRight()) {
            X -= 8;
        }
        this.tipPopup.show(this.contentPanel, X, Y);
    }

    private void closeToolTip() {
        this.tipPopup.setVisible(false);
        if (this.tipLabel != null) {
            this.tipLabel.removeMouseListener(this.tipMouseAdapter);
            this.tipPopup.remove(this.tipLabel);
            if (!this.tipLabel.getController().isReleased()) {
                LevelManager.release(this.tipLabel.getController().getLevel());
            }
            this.tipLabel = null;
        }
    }

    public void close() {
        this.setContentPanel(null);
        this.closeToolTip();
        this.setVisible(false);
    }

    public StaticCalendarItemPanel getContentPanel() {
        return this.contentPanel;
    }

    public Calendar getCurrentDate() {
        if (this.contentPanel != null) {
            return this.contentPanel.getCurrentDate();
        }
        return null;
    }

    public void setItems(Calendar theTime, List<? extends AbstractItem> dayItems, IItemList itemList, String theType) {
        if (this.contentPanel != null) {
            this.contentPanel.setItems(theTime, dayItems, itemList, theType);
            this.closeToolTip();
        }
    }

    public void setShowItems(boolean theShow, String theType) {
        if (this.contentPanel != null) {
            this.contentPanel.setShowItems(theShow, theType);
        }
    }

    private class TipMouseListener
    extends MouseAdapter {
        private boolean wasPopup;

        private TipMouseListener() {
        }

        public void mouseExited(MouseEvent e) {
            if (!this.wasPopup) {
                this.wasPopup = false;
                CalendarItemPanelPopup.this.closeToolTip();
            }
        }

        public void mousePressed(MouseEvent e) {
            if (!this.wasPopup) {
                this.wasPopup = e.isPopupTrigger();
            }
            if (!CalendarItemPanelPopup.this.getFocusOwner().isFocusOwner()) {
                CalendarItemPanelPopup.this.getFocusOwner().grabFocus();
            }
            CalendarItemPanelPopup.this.tipLabel.getController().processCommand(new Command(70, CalendarItemPanelPopup.this.contentPanel.getCurrentDate()));
        }

        public void mouseReleased(MouseEvent e) {
            if (!this.wasPopup) {
                this.wasPopup = e.isPopupTrigger();
            }
        }
    }

    private class GlassPanelMouseHandler
    implements MouseListener,
    MouseMotionListener {
        private GlassPanelMouseHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            GWCalendarController gwCalendarController = ControlsUtils.getParentGWCalendarController(CalendarItemPanelPopup.this.parentController);
            assert (gwCalendarController != null);
            gwCalendarController.itemSelected(null);
            CalendarItemPanelPopup.this.getContentPanel().getController().processCommand(new Command(70, CalendarItemPanelPopup.this.getContentPanel().getCurrentDate()));
            if (OS.isDoubleClick(e)) {
                try {
                    String userGuid = ControlsUtils.getUserGuid(CalendarItemPanelPopup.this.parentController);
                    CalendarUtils.showCalendarFrame(userGuid, CalendarItemPanelPopup.this.getContentPanel().getCurrentDate().getTime());
                }
                catch (GWCommandException e1) {
                    logger.error((Object)e1);
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.doPopup(e);
        }

        public void mousePressed(MouseEvent e) {
            this.doPopup(e);
        }

        private void doPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                StaticCalendarItemPanel contentPanel = CalendarItemPanelPopup.this.contentPanel;
                GWCalendarPopup popup = new GWCalendarPopup("CalendarItem", contentPanel.getController());
                popup.setDate(contentPanel.getCurrentDate().getTime());
                popup.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
            if (!CalendarItemPanelPopup.this.contains(e.getPoint())) {
                CalendarItemPanelPopup.this.close();
            }
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            CalendarItemPanelPopup.this.handleToolTip(e);
        }
    }
}

