/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes;

import com.novell.gw.jclient.application.controls.busysearch.AvailableTimeGrid;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

public class DayLabelsPanel
extends OrientablePanel {
    private static Logger logger = Logger.getLogger(DayLabelsPanel.class);
    protected int height = 20;
    protected Border labelBorder;
    private Calendar gcCurrentDay = GWCalendarUtils.getToday();
    protected Calendar gcStartDay = GWCalendarUtils.getToday();
    private DateFormat dateFormat;
    private int daysCount = 7;
    private DayLabelContainerAdapter dayLabelContainerAdapter;

    public DayLabelsPanel(int theDaysCount) {
        super(new GridLayout());
        this.daysCount = theDaysCount;
        this.init();
        this.buildDaysPanel();
        this.dayLabelContainerAdapter = new DayLabelContainerAdapter();
        this.addContainerListener(this.dayLabelContainerAdapter);
        this.addComponentListener(new DayLabelComponentAdapter());
    }

    public DayLabelsPanel() {
        this(7);
    }

    protected void init() {
        this.labelBorder = BorderFactory.createLineBorder(Color.darkGray);
        Locale locale = EngineCommandManager.getLocale();
        TimeZone timeZone = OptionManager.getInstance().getDateTimeOptions().getTimeZone();
        this.dateFormat = DateFormat.getDateInstance(3, locale);
        this.dateFormat.setTimeZone(timeZone);
    }

    protected void buildDaysPanel() {
        this.removeAll();
        for (int i = 0; i < this.daysCount; ++i) {
            this.addLabel();
        }
    }

    public void setPreferredSize(Dimension preferredSize) {
        super.setPreferredSize(preferredSize);
        super.setMinimumSize(preferredSize);
    }

    public void setTitles(Date theStartDay, Date theCurrentDay) {
        this.gcStartDay.setTime(theStartDay);
        if (theCurrentDay == null) {
            this.gcCurrentDay.setTime(new Date(0L));
        } else {
            this.gcCurrentDay.setTime(theCurrentDay);
        }
        Calendar day = GWCalendarUtils.getToday();
        day.setTime(theStartDay);
        boolean isShort = this.isShortTitle();
        int nCount = this.getComponentCount();
        for (int i = 0; i < nCount; ++i) {
            JLabel lbl = this.getLabel(i);
            if (lbl == null) {
                return;
            }
            this.setTextToLabel(lbl, day, isShort);
            day.add(5, 1);
        }
    }

    protected JLabel getLabel(int i) {
        return (JLabel)this.getComponent(i);
    }

    protected boolean isShortTitle() {
        boolean isShort = false;
        StringBuilder str = new StringBuilder("Mon 23/12/04");
        Graphics g = this.getGraphics();
        if (g != null && g.getFontMetrics().getStringBounds(str.toString(), g).getWidth() > (double)(this.getWidth() / this.getComponentCount() - 10)) {
            isShort = true;
        }
        return isShort;
    }

    protected void setTextToLabel(JLabel lbl, Calendar day, boolean isShortText) {
        StringBuffer str;
        if (GWCalendarUtils.isSameDate(day, this.gcCurrentDay)) {
            lbl.setBackground(ColorConstants.CURRENT_DAY_COLOR);
            lbl.setForeground(Color.white);
        } else {
            if (GWCalendarUtils.isSameDate(day, GWCalendarUtils.getToday())) {
                lbl.setBackground(ColorConstants.TODAY_COLOR);
            } else {
                lbl.setBackground(this.getBackground());
            }
            lbl.setForeground(Color.black);
        }
        if (day.get(7) == 1 || day.get(7) == 7) {
            lbl.setForeground(Color.red);
        }
        if (isShortText) {
            str = new StringBuffer(this.dateFormat.format(day.getTime()));
        } else {
            str = new StringBuffer(GWCalendarUtils.dayMediumNames[day.get(7) - 1]);
            str.append(' ').append(this.dateFormat.format(day.getTime()));
        }
        lbl.setText(str.toString());
    }

    public void addLabel() {
        OrientableLabel lblDay = new OrientableLabel(" ");
        lblDay.setHorizontalAlignment(0);
        lblDay.setBorder(this.labelBorder);
        if (this.getComponentCount() == this.daysCount - 1) {
            lblDay.setBorder(new AvailableTimeGrid.BusyDayLabelBorder(true));
        }
        lblDay.setOpaque(true);
        this.add(lblDay);
    }

    public void removeLabel() {
        if (this.getComponentCount() < 1) {
            return;
        }
        this.remove(this.getComponentCount() - 1);
        this.validate();
    }

    public void setDaysCount(int theDaysCount) {
        this.daysCount = theDaysCount;
        this.removeContainerListener(this.dayLabelContainerAdapter);
        this.buildDaysPanel();
        this.addContainerListener(this.dayLabelContainerAdapter);
    }

    class DayLabelComponentAdapter
    extends ComponentAdapter {
        DayLabelComponentAdapter() {
        }

        public void componentResized(ComponentEvent e) {
            DayLabelsPanel panel = DayLabelsPanel.this;
            panel.setTitles(panel.gcStartDay.getTime(), panel.gcCurrentDay.getTime());
        }
    }

    class DayLabelContainerAdapter
    extends ContainerAdapter {
        DayLabelContainerAdapter() {
        }

        public void componentAdded(ContainerEvent e) {
            DayLabelsPanel.this.setTitles(DayLabelsPanel.this.gcStartDay.getTime(), DayLabelsPanel.this.gcCurrentDay.getTime());
        }

        public void componentRemoved(ContainerEvent e) {
            DayLabelsPanel.this.setTitles(DayLabelsPanel.this.gcStartDay.getTime(), DayLabelsPanel.this.gcCurrentDay.getTime());
        }
    }
}

