/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes;

import com.novell.gw.jclient.application.controls.gwcalendar.DateAndTimeFormattingUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.AppointmentPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.text.DateFormat;
import java.util.Calendar;
import javax.swing.JComponent;
import javax.swing.border.Border;

public abstract class HourLabelsPanel
extends OrientablePanel {
    private static final Dimension LABEL_DIMENTION = new Dimension(PLAFChanger.getFontSize() * 5 - 10, AppointmentPanel.QUARTER_LABEL_HEIGHT * 4);
    private Border border;
    protected boolean alternateTimeZoneUsed = false;
    protected int secOffset = 0;
    private Calendar currentTime00 = GWCalendarUtils.getTodayWithoutTimeFraction();

    public HourLabelsPanel(Border theBorder) {
        this(theBorder, false);
    }

    public HourLabelsPanel(Border theBorder, boolean alternate) {
        this.border = theBorder;
        this.alternateTimeZoneUsed = alternate;
        this.init();
        this.buildUI(this.currentTime00);
    }

    protected abstract void init();

    protected abstract JComponent getLabel(Calendar var1, DateFormat var2);

    protected void buildUI() {
        this.buildUI(this.currentTime00);
    }

    protected void buildUI(Calendar calendar) {
        assert (calendar != null) : "gc is null";
        Calendar gc = (Calendar)calendar.clone();
        this.currentTime00 = (Calendar)calendar.clone();
        this.removeAll();
        this.setLayout(this.alternateTimeZoneUsed ? new GridBagLayout() : new GridLayout(0, 1, 0, 0));
        this.setBackground(ColorConstants.TIME_PANEL_COLOR);
        GWCalendarUtils.clearTime(gc);
        gc.get(11);
        gc.setTimeZone(GWCalendarUtils.getTimeZone(this.alternateTimeZoneUsed));
        DateFormat timeFormat = this.getTimeFormat();
        if (this.alternateTimeZoneUsed && gc.get(12) > 0) {
            this.createEmptyLabel((double)gc.get(12) / 60.0);
            gc.add(10, 1);
        }
        for (int i = 0; i < 24; ++i) {
            if (this.alternateTimeZoneUsed && i == 23 && gc.get(12) > 0) {
                this.createEmptyLabel(1.0 - (double)gc.get(12) / 60.0);
            } else {
                JComponent label = this.getLabel(gc, timeFormat);
                label.setPreferredSize(LABEL_DIMENTION);
                label.setMinimumSize(LABEL_DIMENTION);
                label.setMaximumSize(LABEL_DIMENTION);
                label.setBorder(this.border);
                if (this.alternateTimeZoneUsed) {
                    GridBagConstraints c = new GridBagConstraints();
                    c.gridx = 0;
                    c.weighty = 1.0;
                    c.fill = 3;
                    this.add((Component)label, c);
                } else {
                    this.add(label);
                }
            }
            gc.add(10, 1);
        }
    }

    private void createEmptyLabel(double koef) {
        Dimension LABEL_DIMENTIONX = new Dimension(PLAFChanger.getFontSize() * 5 - 10, (int)((double)AppointmentPanel.QUARTER_LABEL_HEIGHT * koef * 4.0));
        OrientableLabel label = new OrientableLabel();
        label.setBackground(this.getBackground());
        label.setPreferredSize(LABEL_DIMENTIONX);
        label.setMinimumSize(LABEL_DIMENTIONX);
        label.setMaximumSize(LABEL_DIMENTIONX);
        label.setBorder(this.border);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        this.add((Component)label, c);
    }

    protected DateFormat getTimeFormat() {
        DateFormat format = DateAndTimeFormattingUtils.getDateFormat(OptionManager.getInstance().getDateTimeOptions().getTimeFormat());
        format.setTimeZone(GWCalendarUtils.getTimeZone(this.alternateTimeZoneUsed));
        return format;
    }

    public static int getPanelWidth() {
        return HourLabelsPanel.LABEL_DIMENTION.width;
    }
}

