/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.DateAndTimeFormattingUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarEventType;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.DateVerifier;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.MonthlyCalendar;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateSelectorPopup;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateTextField;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateValueChangeListener;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.ImageResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDateSelector<D extends DateTextField>
extends OrientablePanel
implements DateValueChangeListener {
    private static Logger logger = Logger.getLogger(AbstractDateSelector.class);
    private Calendar currentDate;
    protected AbstractButton pickerButton;
    protected MonthlyCalendar calendar;
    private DateSelectorPopup popup;
    protected D dateField;
    private List<DateValueChangeListener> dateValueListeners = new ArrayList<DateValueChangeListener>();

    protected AbstractDateSelector() {
        this.init();
    }

    protected DateFormat getDateFormat() {
        String format = OptionManager.getInstance().getDateTimeOptions().getShortDateFormat();
        return DateAndTimeFormattingUtils.getDateFormat(format);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(null);
        this.dateField = this.createDateTextField();
        assert (this.dateField != null) : "created date text field is null";
        ((Component)this.dateField).addKeyListener(new DatePickerListener());
        this.add((Component)this.dateField, "Center");
        this.initPickerButton();
        this.add((Component)this.pickerButton, "After");
        this.calendar = this.createCalendar();
        assert (this.calendar != null) : "created calendar is null";
    }

    protected abstract MonthlyCalendar createCalendar();

    protected abstract DateTextField createDateTextField();

    protected void initPopup() {
        Window frame = SwingUtilities.getWindowAncestor(this);
        if (frame instanceof JFrame) {
            this.popup = new DateSelectorPopup((JFrame)frame, this.calendar);
        } else if (frame instanceof JDialog) {
            this.popup = new DateSelectorPopup((JDialog)frame, this.calendar);
        }
    }

    protected void showPopup(Component invoker) {
        if (this.popup == null) {
            this.initPopup();
        }
        if (this.popup != null) {
            this.calendar.setDate((Calendar)this.currentDate.clone());
            int x = invoker.getLocationOnScreen().x - this.calendar.getPreferredSize().width;
            int y = invoker.getLocationOnScreen().y + invoker.getHeight();
            this.popup.setLocation(x, y);
            this.calendar.updateTodayField();
            this.popup.show();
        }
    }

    protected void handleKey(int keyCode) {
        switch (keyCode) {
            case 40: {
                this.showPopup(this.pickerButton);
            }
        }
    }

    public D getTextComponent() {
        return this.dateField;
    }

    public void addDateChangeListener(DateValueChangeListener listener) {
        this.dateValueListeners.add(listener);
    }

    public void removeDateChangeListener(DateValueChangeListener listener) {
        this.dateValueListeners.remove(listener);
    }

    public void refreshUIOptions() {
        if (this.calendar != null) {
            this.calendar.getCalendarComponent().getModel().refreshUIOptions();
            this.calendar.getCalendarComponent().update();
            if (this.popup != null) {
                this.popup.setSize(new Dimension((int)this.calendar.getPreferredSize().getWidth(), (int)this.popup.getPreferredSize().getHeight()));
            }
        }
    }

    protected void fireDateChanged(DateChangeEvent e) {
        for (DateValueChangeListener listener : this.dateValueListeners) {
            listener.valueChanged(e);
        }
    }

    protected void initPickerButton() {
        this.pickerButton = UIUtils.createToolButton(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AbstractDateSelector.this.processDatePickerActionEvent(e);
            }
        });
        this.pickerButton.setIcon(ImageResources.ACT_DATEPICKER);
    }

    protected void processDatePickerActionEvent(ActionEvent e) {
        if (!((Component)this.dateField).isFocusOwner()) {
            ((JComponent)this.dateField).requestFocusInWindow();
        }
        Component invoker = (Component)e.getSource();
        this.showPopup(invoker);
    }

    protected void addListeners() {
        this.calendar.addValueChangeListener(this);
        ((DateTextField)this.dateField).addValueChangeListener(this);
    }

    protected void removeListeners() {
        this.calendar.removeValueChangeListener(this);
        ((DateTextField)this.dateField).removeValueChangeListener(this);
    }

    public void addValueChangeListener(DateValueChangeListener theListener) {
        this.calendar.addValueChangeListener(theListener);
    }

    public void removeValueChangeListener(DateValueChangeListener theListener) {
        this.calendar.removeValueChangeListener(theListener);
    }

    @Override
    public void valueChanged(DateChangeEvent e) {
        if (!CalendarEventType.SELECT.equals((Object)e.getType()) && e.getSource() instanceof MonthlyCalendar) {
            logger.debug((Object)"non-SELECT event from Calendar, ignoring");
            return;
        }
        Calendar newDate = e.getDate();
        if (!newDate.equals(this.calendar.getDate())) {
            this.calendar.setDate(newDate);
        }
        if (!newDate.equals(((DateTextField)this.dateField).getDate())) {
            this.removeListeners();
            ((DateTextField)this.dateField).setDate(newDate);
            this.addListeners();
        }
        if (!newDate.equals(this.currentDate)) {
            this.setCurrentDate(newDate);
            this.processDateChangeEvent(newDate);
        }
        ((JComponent)this.dateField).requestFocusInWindow();
    }

    protected Calendar getCurrentDate() {
        return this.currentDate == null ? null : (Calendar)this.currentDate.clone();
    }

    protected void setCurrentDate(Calendar currentDate) {
        this.currentDate = (Calendar)currentDate.clone();
    }

    public void setDateVerifier(DateVerifier dateVerifier) {
        ((DateTextField)this.dateField).setDateVerifier(dateVerifier);
        this.calendar.getCalendarComponent().getModel().setDateVerifier(dateVerifier);
    }

    protected abstract void processDateChangeEvent(Calendar var1);

    private class DatePickerListener
    extends KeyAdapter {
        private DatePickerListener() {
        }

        public void keyPressed(KeyEvent e) {
            int keyCode = e.getKeyCode();
            AbstractDateSelector.this.handleKey(keyCode);
        }
    }
}

