/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector;

import com.novell.gw.jclient.application.controls.gwcalendar.DateAndTimeFormattingUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.DateVerifier;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateValueChangeListener;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DocumentChangeHandler;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.timepicker.MutableTextField;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.apache.log4j.Logger;

public class DateTextField
extends GWTextField
implements DateValueChangeListener,
MutableTextField {
    private static final Logger logger = Logger.getLogger(DateTextField.class);
    private DateFormat format;
    private Calendar calendar;
    private ArrayList<DateValueChangeListener> listeners;
    private DocumentChangeHandler documentHandler;
    private int century = 0;
    private DateVerifier dateVerifier = null;

    public DateTextField(DateFormat theFormat, DocumentChangeHandler theHandler) {
        this(theFormat, theHandler, GWCalendarUtils.getTodayWithoutTimeFraction());
    }

    public DateTextField(DateFormat theFormat, DocumentChangeHandler theHandler, Calendar theDate) {
        if (theFormat == null) {
            throw new IllegalArgumentException("Date format can not be NULL");
        }
        if (theHandler == null) {
            throw new IllegalArgumentException("Document handler can not be NULL");
        }
        this.listeners = new ArrayList();
        this.format = theFormat;
        this.documentHandler = theHandler;
        this.setDocument(new TextDocument());
        this.addFocusListener(new CommitFocusListener());
        this.addValueChangeListener(this);
        this.setDate(theDate);
    }

    public void setDate(Calendar newDate) {
        if (newDate == null) {
            throw new IllegalArgumentException("Date can not be NULL");
        }
        if (this.dateVerifier != null) {
            newDate = this.dateVerifier.verify(newDate);
        }
        if (this.calendar == null) {
            this.calendar = GWCalendarUtils.getToday();
        }
        if (!this.calendar.equals(newDate)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("date changed" + DateAndTimeFormattingUtils.calendarToLogString(this.calendar) + " > " + DateAndTimeFormattingUtils.calendarToLogString(newDate) + " (" + this + ')'));
                if (!this.calendar.getTimeZone().equals(newDate.getTimeZone())) {
                    logger.warn((Object)("Changing time zone: " + this.calendar.getTimeZone().getDisplayName() + " > " + newDate.getTimeZone().getDisplayName() + " (" + this + ')'));
                }
            }
            this.calendar.setTime(newDate.getTime());
            this.fireValueChanged(new DateChangeEvent((Calendar)this.calendar.clone(), this));
        }
    }

    public void valueChanged(DateChangeEvent e) {
        this.refreshText();
    }

    protected void refreshText() {
        String text = this.format.format(this.calendar.getTime());
        this.century = this.calendar.get(1) / 100;
        this.setText(text);
    }

    private void handleFocusLost() {
        this.commit();
    }

    public void commit() {
        String text = this.getText();
        Pattern pattern = Pattern.compile("(\\d+)\\/(\\d+)\\/(\\d{4}+)");
        Matcher m = pattern.matcher(text);
        Calendar newDate = GWCalendarUtils.getToday();
        if (m.matches()) {
            try {
                newDate.setTime(this.format.parse(text));
            }
            catch (ParseException ex) {
                logger.error((Object)"Exception while parsing date format");
                ex.printStackTrace();
            }
            if (this.dateVerifier != null) {
                newDate = this.dateVerifier.verify(newDate);
            }
            this.setDate(newDate);
            this.refreshText();
            return;
        }
        if (text.length() > 0) {
            try {
                int year;
                newDate.setTime(this.format.parse(text));
                if (newDate.get(1) / 100 != this.century) {
                    year = this.century * 100 + newDate.get(1) % 100;
                } else {
                    year = newDate.get(1);
                    this.century = year / 100;
                }
                newDate.set(1, year);
                this.setDate(newDate);
            }
            catch (ParseException e) {
                try {
                    newDate.setTime(GWCalendarUtils.getDateFormatMMDD().parse(text));
                    newDate.set(1, GWCalendarUtils.getToday().get(1));
                    this.setDate(newDate);
                }
                catch (ParseException e1) {
                    newDate.setTime(GWCalendarUtils.getToday().getTime());
                }
            }
        }
        this.refreshText();
    }

    private void fireValueChanged(DateChangeEvent e) {
        for (DateValueChangeListener listener : this.listeners) {
            listener.valueChanged(e);
        }
    }

    public void addValueChangeListener(DateValueChangeListener theListener) {
        this.listeners.add(theListener);
    }

    public void removeValueChangeListener(DateValueChangeListener theListener) {
        this.listeners.remove(theListener);
    }

    protected boolean handleChange(String theText) {
        if (this.documentHandler.canHandle(theText)) {
            this.handleChange(this.documentHandler.getField(theText), this.documentHandler.getShift(theText));
            return true;
        }
        return false;
    }

    private void handleChange(int field, int shift) {
        this.unselectAll();
        this.commit();
        Calendar c = (Calendar)this.calendar.clone();
        c.add(field, shift);
        this.setDate(c);
        this.selectAll();
    }

    protected boolean handleRemove(int theOffs, int theLen) {
        return false;
    }

    private void unselectAll() {
        this.setCaretPosition(0);
        this.moveCaretPosition(0);
    }

    public Calendar getDate() {
        return (Calendar)this.calendar.clone();
    }

    public DateVerifier getDateVerifier() {
        return this.dateVerifier;
    }

    public void setDateVerifier(DateVerifier dateVerifier) {
        this.dateVerifier = dateVerifier;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(" [");
        builder.append("name = ");
        builder.append(this.getName());
        builder.append(']');
        return builder.toString();
    }

    private class TextDocument
    extends PlainDocument {
        private TextDocument() {
        }

        public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (!DateTextField.this.handleChange(text)) {
                super.replace(offset, length, text, attrs);
            }
        }

        public void remove(int offs, int len) throws BadLocationException {
            if (!DateTextField.this.handleRemove(offs, len)) {
                super.remove(offs, len);
            }
        }
    }

    private class CommitFocusListener
    extends FocusAdapter {
        private CommitFocusListener() {
        }

        public void focusLost(FocusEvent e) {
            DateTextField.this.handleFocusLost();
        }
    }
}

