/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector;

import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DurationTimeFormat;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DurationToken;
import com.novell.gw.jclient.bl.om.items.TimeDuration;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DurationDayFormat
extends DurationTimeFormat {
    public TimeDuration parse(int theStartMinutes, String theText) throws ParseException {
        DurationToken token;
        Pattern pattern = Pattern.compile("\\d{1,}");
        Matcher matcher = pattern.matcher(theText);
        ArrayList<DurationToken> result = new ArrayList<DurationToken>();
        while (matcher.find()) {
            String digits = matcher.group();
            int start = matcher.start();
            int end = matcher.end();
            token = new DurationToken(digits, start, end);
            result.add(token);
        }
        if (result.isEmpty()) {
            throw new ParseException("No duration founded", 0);
        }
        DurationToken[] tokens = new DurationToken[result.size()];
        result.toArray(tokens);
        int days = 0;
        for (int i = 0; i < tokens.length; ++i) {
            token = tokens[i];
            int digits = 0;
            try {
                digits = Integer.parseInt(token.getDigits());
            }
            catch (NumberFormatException e) {
                throw new ParseException("Duration is out of range", 0);
            }
            days += digits;
        }
        int rezMinutes = 0;
        if (days > 0) {
            rezMinutes = days * 1440;
        }
        if (rezMinutes > 0) {
            return new TimeDuration(theStartMinutes, theStartMinutes + rezMinutes);
        }
        throw new ParseException("Can not parse duration", 0);
    }
}

