/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector;

import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DurationFormat;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DurationToken;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.TimeDuration;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DurationTimeFormat
implements DurationFormat {
    public String format(TimeDuration theDuration) {
        int days = theDuration.getDays();
        int hours = theDuration.getHours();
        int minutes = theDuration.getMinutes();
        StringBuilder result = new StringBuilder();
        if (days > 0) {
            result.append(days);
            result.append(' ');
            result.append(days == 1 ? StringResources.DAY : StringResources.DAYS);
        }
        if (hours > 0) {
            if (result.length() > 0) {
                result.append(' ');
            }
            result.append(hours);
            result.append(' ');
            result.append(hours == 1 ? StringResources.HOUR : StringResources.HOURS);
        }
        if (minutes > 0) {
            if (result.length() > 0) {
                result.append(' ');
            }
            result.append(minutes);
            result.append(' ');
            result.append(minutes == 1 ? StringResources.MINUTE : StringResources.MINUTES);
        }
        return result.toString();
    }

    public TimeDuration parse(int theStartMinutes, String theText) throws ParseException {
        Pattern pattern = Pattern.compile("(\\d{1,}\\.\\d{1,})|(\\d{1,}\\.)|(\\d{1,})|(\\.\\d{1,})");
        Matcher matcher = pattern.matcher(theText);
        ArrayList<DurationToken> result = new ArrayList<DurationToken>();
        while (matcher.find()) {
            String digits = matcher.group();
            int start = matcher.start();
            int end = matcher.end();
            DurationToken token = new DurationToken(digits, start, end);
            result.add(token);
        }
        if (result.isEmpty()) {
            throw new ParseException("No duration founded", 0);
        }
        DurationToken[] tokens = new DurationToken[result.size()];
        result.toArray(tokens);
        double days = 0.0;
        double hours = 0.0;
        double minutes = 0.0;
        for (int i = 0; i < tokens.length; ++i) {
            DurationToken token = tokens[i];
            double digits = 0.0;
            try {
                digits = Double.parseDouble(token.getDigits());
            }
            catch (NumberFormatException e) {
                throw new ParseException("Duration is out of range", 0);
            }
            int end = token.getEnd();
            String txt = theText.substring(end, theText.length()).trim().toLowerCase();
            if (txt.startsWith(StringResources.DAYS_FIRST_CHARS_LOWER_CASE)) {
                days += digits;
                continue;
            }
            if (txt.startsWith(StringResources.HOURS_FIRST_CHARS_LOWER_CASE)) {
                hours += digits;
                continue;
            }
            if (txt.startsWith(StringResources.MINUTES_FIRST_CHARS_LOWER_CASE)) {
                minutes += digits;
                continue;
            }
            if (digits < 10.0) {
                hours += digits;
                continue;
            }
            minutes += digits;
        }
        double rezMinutes = 0.0;
        if (days > 0.0) {
            rezMinutes = days * 1440.0;
        }
        if (hours > 0.0) {
            rezMinutes += hours * 60.0;
        }
        if (minutes > 0.0) {
            rezMinutes += minutes;
        }
        if (rezMinutes > 0.0) {
            return new TimeDuration(theStartMinutes, theStartMinutes + (int)rezMinutes);
        }
        throw new ParseException("Can not parse duration", 0);
    }
}

