/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.autodate.AutoDateDialog;
import com.novell.gw.jclient.application.controls.autodate.SetDateDialog;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.MonthlyCalendar;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.AbstractDateSelector;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateDocumentHandler;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateSelectorPopup;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DocumentChangeHandler;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.ExtendedDateTextField;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.RecuringDateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.RecuringDateChangeListener;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.RecuringMonthlyCalendar;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.RecurringModel;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecuringDateSelector
extends AbstractDateSelector<ExtendedDateTextField> {
    private AutoDateDialog autoDateDialog;
    private SetDateDialog setDateDialog;
    private RecurringModel model;
    private ArrayList recuringListeners = new ArrayList();
    private Comparator comparator;
    protected JFrame parentFrame;

    public RecuringDateSelector() {
        this.model = new RecurringModel();
        this.comparator = new CalendarComparator();
    }

    public RecuringDateSelector(boolean hasRecurringLabel) {
        this();
        if (!hasRecurringLabel) {
            this.calendar = new MonthlyCalendar(GWCalendarUtils.getToday(), true, true);
        }
    }

    @Override
    protected ExtendedDateTextField createDateTextField() {
        return new ExtendedDateTextField(this.getDateFormat(), (DocumentChangeHandler)new DateDocumentHandler(), StringResources.RECURRING_DATE);
    }

    public void setDate(Calendar theDate) {
        this.setDates(new Calendar[]{theDate});
    }

    public void setParentFrame(JFrame parentFrame) {
        this.parentFrame = parentFrame;
    }

    public void setDates(Calendar[] theDates) {
        this.model.setDates(theDates);
        if (!this.model.isEmpty()) {
            this.removeListeners();
            Calendar newDate = theDates[0];
            this.calendar.setDate(newDate);
            ((ExtendedDateTextField)this.dateField).setDate(newDate);
            ((ExtendedDateTextField)this.dateField).setTextMode(this.model.isRecuring());
            this.setCurrentDate(newDate);
            this.addListeners();
            this.fireRecuringDateChanged(new RecuringDateChangeEvent(theDates, this));
            this.fireDateChanged(new DateChangeEvent(newDate, this));
        }
    }

    public Calendar getDate() {
        Calendar[] arr = this.getDates();
        if (arr != null && arr.length > 0) {
            return arr[0];
        }
        return Calendar.getInstance();
    }

    public Calendar[] getDates() {
        if (!this.model.isRecuring()) {
            ((ExtendedDateTextField)this.dateField).commit();
        }
        Calendar[] dates = this.model.getDates();
        Arrays.sort(dates, this.comparator);
        return dates;
    }

    public boolean isRecuring() {
        return this.model.isRecuring();
    }

    @Override
    protected MonthlyCalendar createCalendar() {
        RecuringMonthlyCalendar monthlyCalendar = new RecuringMonthlyCalendar(GWCalendarUtils.getToday(), true);
        monthlyCalendar.addRecuringLabelListener(new RecuringLabelMouseListener());
        return monthlyCalendar;
    }

    private void initAutoDateDialog() {
        Window frame = SwingUtilities.getWindowAncestor(this);
        if (frame instanceof JFrame) {
            this.autoDateDialog = new AutoDateDialog((JFrame)frame);
        } else if (this.parentFrame != null) {
            this.autoDateDialog = new AutoDateDialog(this.parentFrame);
        }
        this.autoDateDialog.pack();
        UIUtils.centerWindowOnScreen(this.autoDateDialog);
    }

    public void showAutodateDialog() {
        if (this.autoDateDialog == null) {
            this.initAutoDateDialog();
        }
        if (this.autoDateDialog != null) {
            Calendar[] dates = this.model.getDates();
            if (!this.model.isRecuring()) {
                dates = new Calendar[]{};
            }
            this.autoDateDialog.setSelectedDays(GWCalendarUtils.convertCalendarsToDays(dates));
            this.autoDateDialog.setVisible(true);
            if (this.autoDateDialog.isOkActionProcessed()) {
                this.setDates(GWCalendarUtils.convertDaysToCalendars(this.autoDateDialog.getSelectedDays()));
            }
        }
    }

    @Override
    protected void showPopup(Component invoker) {
        if (this.model.isRecuring()) {
            this.showAutodateDialog();
        } else {
            super.showPopup(invoker);
        }
    }

    @Override
    protected void processDateChangeEvent(Calendar newDate) {
        this.setDates(new Calendar[]{newDate});
    }

    private void fireRecuringDateChanged(RecuringDateChangeEvent e) {
        int nSize = this.recuringListeners.size();
        for (int i = 0; i < nSize; ++i) {
            RecuringDateChangeListener listener = (RecuringDateChangeListener)this.recuringListeners.get(i);
            listener.valueChanged(e);
        }
    }

    public void addRecuringDateChangeListener(RecuringDateChangeListener theListener) {
        this.recuringListeners.add(theListener);
    }

    public void removeRecuringDateChangeListener(RecuringDateChangeListener theListener) {
        this.recuringListeners.remove(theListener);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.pickerButton.setEnabled(isEnabled);
        ((ExtendedDateTextField)this.dateField).setEnabled(isEnabled);
    }

    private static class CalendarComparator
    implements Comparator {
        private CalendarComparator() {
        }

        public int compare(Object o1, Object o2) {
            long t2;
            Calendar c1 = (Calendar)o1;
            Calendar c2 = (Calendar)o2;
            long t1 = c1.getTimeInMillis();
            if (t1 == (t2 = c2.getTimeInMillis())) {
                return 0;
            }
            return t1 > t2 ? 1 : -1;
        }
    }

    private class RecuringLabelMouseListener
    extends MouseAdapter {
        private RecuringLabelMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            RecuringDateSelector selector = RecuringDateSelector.this;
            selector.showAutodateDialog();
            Window window = SwingUtilities.getWindowAncestor((Component)e.getSource());
            if (window instanceof DateSelectorPopup) {
                window.setVisible(false);
            }
        }
    }
}

